/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.core.compatibility.Point;
import com.jediterm.terminal.model.LinesStorage;
import com.jediterm.terminal.model.LinesStorageKt;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeWidthOperation {
    private static final Logger LOG = LoggerFactory.getLogger(TerminalTextBuffer.class);
    private final TerminalTextBuffer myTextBuffer;
    private final int myNewWidth;
    private final int myNewHeight;
    private final Map<TrackingPoint, Point> myTrackingPoints = new HashMap<TrackingPoint, Point>();
    private final List<TerminalLine> myAllLines = new ArrayList<TerminalLine>();
    private TerminalLine myCurrentLine;
    private int myCurrentLineLength;

    ChangeWidthOperation(@NotNull TerminalTextBuffer textBuffer, int newWidth, int newHeight) {
        this.myTextBuffer = textBuffer;
        this.myNewWidth = newWidth;
        this.myNewHeight = newHeight;
    }

    void addPointToTrack(@NotNull Point point, boolean isForceVisible) {
        if (isForceVisible && (point.y < 0 || point.y >= this.myTextBuffer.getHeight())) {
            LOG.warn("Registered visible point " + String.valueOf(point) + " is outside screen: [0, " + (this.myTextBuffer.getHeight() - 1) + "]");
            point.y = Math.min(Math.max(point.y, 0), this.myTextBuffer.getHeight() - 1);
        }
        this.myTrackingPoints.put(new TrackingPoint(point, isForceVisible), null);
    }

    @NotNull
    Point getTrackedPoint(@NotNull Point original) {
        Point result = this.myTrackingPoints.get(new TrackingPoint(original, false));
        if (result != null) {
            return result;
        }
        result = this.myTrackingPoints.get(new TrackingPoint(original, true));
        if (result != null) {
            return result;
        }
        LOG.warn("Not tracked point: " + String.valueOf(original));
        return original;
    }

    void run() {
        int newY;
        int newX;
        List<TrackingPoint> points;
        int i;
        LinesStorage historyLinesStorage = this.myTextBuffer.getHistoryLinesStorageOrBackup$core();
        for (int i2 = 0; i2 < historyLinesStorage.getSize(); ++i2) {
            TerminalLine line = historyLinesStorage.get(i2);
            this.addLine(line);
        }
        int screenStartInd = this.myAllLines.size() - 1;
        if (this.myCurrentLine == null || this.myCurrentLineLength == this.myNewWidth) {
            ++screenStartInd;
        }
        if (screenStartInd < 0) {
            throw new IndexOutOfBoundsException("screenStartInd < 0: " + screenStartInd);
        }
        LinesStorage screenLinesStorage = this.myTextBuffer.getScreenLinesStorageOrBackup$core();
        if (screenLinesStorage.getSize() > this.myTextBuffer.getHeight()) {
            LOG.warn("Terminal height < screen buffer line count: " + this.myTextBuffer.getHeight() + " < " + screenLinesStorage.getSize());
        }
        int oldScreenLineCount = Math.min(screenLinesStorage.getSize(), this.myTextBuffer.getHeight());
        for (i = 0; i < oldScreenLineCount; ++i) {
            points = this.findPointsAtY(i);
            for (TrackingPoint trackingPoint : points) {
                newX = (this.myCurrentLineLength + trackingPoint.getX()) % this.myNewWidth;
                newY = this.myAllLines.size() + (this.myCurrentLineLength + trackingPoint.getX()) / this.myNewWidth;
                if (this.myCurrentLine != null) {
                    --newY;
                }
                this.myTrackingPoints.put(trackingPoint, new Point(newX, newY));
            }
            this.addLine(screenLinesStorage.get(i));
        }
        for (i = oldScreenLineCount; i < this.myTextBuffer.getHeight(); ++i) {
            points = this.findPointsAtY(i);
            for (TrackingPoint trackingPoint : points) {
                newX = trackingPoint.getX() % this.myNewWidth;
                newY = i - oldScreenLineCount + this.myAllLines.size() + trackingPoint.getX() / this.myNewWidth;
                this.myTrackingPoints.put(trackingPoint, new Point(newX, newY));
            }
        }
        int emptyBottomLineCount = this.getEmptyBottomLineCount();
        int bottomMostPointY = 0;
        for (Map.Entry entry : this.myTrackingPoints.entrySet()) {
            if (!((TrackingPoint)entry.getKey()).getForceVisible()) continue;
            Point resultPoint = Objects.requireNonNull((Point)entry.getValue());
            bottomMostPointY = Math.max(bottomMostPointY, resultPoint.y);
        }
        screenStartInd = Math.max(screenStartInd, this.myAllLines.size() - Math.min(this.myAllLines.size(), this.myNewHeight) - emptyBottomLineCount);
        screenStartInd = Math.min(screenStartInd, this.myAllLines.size() - Math.min(this.myAllLines.size(), this.myNewHeight));
        screenStartInd = Math.max(screenStartInd, bottomMostPointY - this.myNewHeight + 1);
        historyLinesStorage.clear();
        LinesStorageKt.addAllToBottom(historyLinesStorage, this.myAllLines.subList(0, screenStartInd));
        screenLinesStorage.clear();
        LinesStorageKt.addAllToBottom(screenLinesStorage, this.myAllLines.subList(screenStartInd, Math.min(screenStartInd + this.myNewHeight, this.myAllLines.size())));
        for (Map.Entry entry : this.myTrackingPoints.entrySet()) {
            Point p = (Point)entry.getValue();
            if (p != null) {
                p.y -= screenStartInd;
            } else {
                TrackingPoint key = (TrackingPoint)entry.getKey();
                p = new Point(key.getX(), key.getY());
                entry.setValue(p);
            }
            p.x = Math.min(this.myNewWidth, Math.max(0, p.x));
            p.y = Math.min(this.myNewHeight, Math.max(0, p.y));
        }
    }

    private int getEmptyBottomLineCount() {
        int ind;
        for (ind = this.myAllLines.size() - 1; ind >= 0 && this.myAllLines.get(ind).isNulOrEmpty(); --ind) {
        }
        return this.myAllLines.size() - 1 - ind;
    }

    @NotNull
    private List<TrackingPoint> findPointsAtY(int y) {
        List<TrackingPoint> result = Collections.emptyList();
        for (TrackingPoint key : this.myTrackingPoints.keySet()) {
            if (key.getY() != y) continue;
            if (result.isEmpty()) {
                result = new ArrayList<TrackingPoint>();
            }
            result.add(key);
        }
        return result;
    }

    private void addLine(@NotNull TerminalLine line) {
        if (line.isNul()) {
            if (this.myCurrentLine != null) {
                this.myCurrentLine = null;
                this.myCurrentLineLength = 0;
            }
            this.myAllLines.add(TerminalLine.createEmpty());
            return;
        }
        line.forEachEntry(entry -> {
            int len;
            if (entry.isNul()) {
                return;
            }
            for (int entryProcessedLength = 0; entryProcessedLength < entry.getLength(); entryProcessedLength += len) {
                if (this.myCurrentLine != null && this.myCurrentLineLength == this.myNewWidth) {
                    this.myCurrentLine.setWrapped(true);
                    this.myCurrentLine = null;
                    this.myCurrentLineLength = 0;
                }
                if (this.myCurrentLine == null) {
                    this.myCurrentLine = new TerminalLine();
                    this.myCurrentLineLength = 0;
                    this.myAllLines.add(this.myCurrentLine);
                }
                len = Math.min(this.myNewWidth - this.myCurrentLineLength, entry.getLength() - entryProcessedLength);
                TerminalLine.TextEntry newEntry = ChangeWidthOperation.subEntry(entry, entryProcessedLength, len);
                this.myCurrentLine.appendEntry(newEntry);
                this.myCurrentLineLength += len;
            }
        });
        if (!line.isWrapped()) {
            this.myCurrentLine = null;
            this.myCurrentLineLength = 0;
        }
    }

    @NotNull
    private static TerminalLine.TextEntry subEntry(@NotNull TerminalLine.TextEntry entry, int startInd, int count) {
        if (startInd == 0 && count == entry.getLength()) {
            return entry;
        }
        return new TerminalLine.TextEntry(entry.getStyle(), entry.getText().subBuffer(startInd, count));
    }

    public static class TrackingPoint {
        private final int myX;
        private final int myY;
        private final boolean myForceVisible;

        public TrackingPoint(Point p, boolean forceVisible) {
            this(p.x, p.y, forceVisible);
        }

        public TrackingPoint(int x, int y, boolean forceVisible) {
            this.myX = x;
            this.myY = y;
            this.myForceVisible = forceVisible;
        }

        public int getX() {
            return this.myX;
        }

        public int getY() {
            return this.myY;
        }

        public boolean getForceVisible() {
            return this.myForceVisible;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TrackingPoint)) {
                return false;
            }
            TrackingPoint that = (TrackingPoint)o;
            return this.myX == that.myX && this.myY == that.myY && this.myForceVisible == that.myForceVisible;
        }

        public int hashCode() {
            return Objects.hash(this.myX, this.myY, this.myForceVisible);
        }
    }
}

