/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.ServiceVolume;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerComposeConfigMappingCollector
implements DockerComposeConfiguration.Visitor<Boolean> {
    private static final Logger LOG = Logger.getInstance(DockerComposeConfigMappingCollector.class);
    private final Map<String, PathMappingSettings> myServiceMappings;
    @NotNull
    private final String myDockerComposeBaseDirectory;

    public DockerComposeConfigMappingCollector(@NotNull String dockerComposeBaseFile) {
        if (dockerComposeBaseFile == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(0);
        }
        this.myServiceMappings = new HashMap<String, PathMappingSettings>();
        this.myDockerComposeBaseDirectory = PathUtil.toSystemIndependentName((String)PathUtil.getParentPath((String)dockerComposeBaseFile));
    }

    @Override
    public Boolean visit(@NotNull DockerComposeConfigurationV1 configuration) {
        if (configuration == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, DockerComposeServiceV1> entry : configuration.getServices().entrySet()) {
            String serviceName = entry.getKey();
            DockerComposeServiceV1 service = entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, service);
        }
        return true;
    }

    @Override
    public Boolean visit(@NotNull DockerComposeConfigurationV2 configuration) {
        if (configuration == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(2);
        }
        for (Map.Entry<String, DockerComposeServiceV2> entry : configuration.getServices().entrySet()) {
            String serviceName = entry.getKey();
            DockerComposeServiceV2 service = entry.getValue();
            if (service == null || !StringUtil.isNotEmpty((String)serviceName)) continue;
            this.collectVolumes(serviceName, service);
        }
        return true;
    }

    private void collectVolumes(@NotNull String serviceName, @NotNull DockerComposeServiceBase service) {
        List<ServiceVolume> volumes;
        if (serviceName == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(3);
        }
        if (service == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(4);
        }
        if ((volumes = service.getVolumes()) == null || volumes.isEmpty()) {
            return;
        }
        PathMappingSettings mappings2 = this.myServiceMappings.containsKey(serviceName) ? this.myServiceMappings.get(serviceName) : new PathMappingSettings();
        for (ServiceVolume volume2 : volumes) {
            boolean isAbsolutePath;
            if (!volume2.isBind()) continue;
            String sourcePath = volume2.getSource();
            String targetPath = volume2.getTarget();
            if (sourcePath == null || targetPath == null || !(isAbsolutePath = FileUtil.isAbsolutePlatformIndependent((String)sourcePath)) && !StringUtil.startsWith((CharSequence)sourcePath, (CharSequence)".")) continue;
            String unifiedLocal = PathUtil.toSystemIndependentName((String)sourcePath);
            String absolute = isAbsolutePath ? unifiedLocal : this.myDockerComposeBaseDirectory + "/" + unifiedLocal;
            mappings2.addMapping(FileUtil.toCanonicalPath((String)absolute, (char)'/'), targetPath);
        }
        if (!mappings2.isEmpty()) {
            this.myServiceMappings.put(serviceName, mappings2);
        }
    }

    @NotNull
    public PathMappingSettings collect(@NotNull DockerCloudConfiguration configuration, @NotNull String serviceName, @NotNull List<String> configurationFiles) {
        if (configuration == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(5);
        }
        if (serviceName == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(6);
        }
        if (configurationFiles == null) {
            DockerComposeConfigMappingCollector.$$$reportNull$$$0(7);
        }
        this.parse(configuration, configurationFiles);
        PathMappingSettings result2 = this.myServiceMappings.get(serviceName);
        return result2 != null ? result2 : new PathMappingSettings();
    }

    private void parse(@NotNull DockerCloudConfiguration configuration, @NotNull List<String> configFiles) {
        block4: {
            if (configuration == null) {
                DockerComposeConfigMappingCollector.$$$reportNull$$$0(8);
            }
            if (configFiles == null) {
                DockerComposeConfigMappingCollector.$$$reportNull$$$0(9);
            }
            try {
                DockerComposeFileConfigurationProvider.getInstance().getConfigFor(configuration, configFiles).accept(this);
            }
            catch (IOException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break block4;
                LOG.warn("Cannot read docker-compose file: " + String.valueOf(configFiles), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeBaseFile";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/DockerComposeConfigMappingCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectVolumes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "collect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

