/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.apps;

import circlet.client.api.apps.ApplicationIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcirclet/client/api/apps/ApplicationIdentifierResolver;", "", "<init>", "()V", "idPrefix", "", "clientIdPrefix", "resolve", "Lcirclet/client/api/apps/ApplicationIdentifier;", "applicationIdentifierAsString", "spaceport-client-api"})
public final class ApplicationIdentifierResolver {
    @NotNull
    public static final ApplicationIdentifierResolver INSTANCE = new ApplicationIdentifierResolver();
    @NotNull
    private static final String idPrefix = "id:";
    @NotNull
    private static final String clientIdPrefix = "clientId:";

    private ApplicationIdentifierResolver() {
    }

    @NotNull
    public final ApplicationIdentifier resolve(@NotNull String applicationIdentifierAsString) {
        ApplicationIdentifier applicationIdentifier;
        Intrinsics.checkNotNullParameter((Object)applicationIdentifierAsString, (String)"applicationIdentifierAsString");
        if (StringsKt.equals((String)applicationIdentifierAsString, (String)"me", (boolean)true)) {
            applicationIdentifier = ApplicationIdentifier.Me.INSTANCE;
        } else if (StringsKt.startsWith((String)applicationIdentifierAsString, (String)clientIdPrefix, (boolean)true)) {
            String string = applicationIdentifierAsString.substring(clientIdPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            applicationIdentifier = new ApplicationIdentifier.ClientId(string);
        } else if (StringsKt.startsWith((String)applicationIdentifierAsString, (String)idPrefix, (boolean)true)) {
            String string = applicationIdentifierAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            applicationIdentifier = new ApplicationIdentifier.Id(string);
        } else {
            applicationIdentifier = new ApplicationIdentifier.Id(applicationIdentifierAsString);
        }
        return applicationIdentifier;
    }
}

