/*
 * Decompiled with CFR 0.152.
 */
package libraries.klogging;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import libraries.klogging.JVMLogger;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002\u001a\u001f\u0010\u0006\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00030\tj\u0002`\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"defaultLogger", "Llibraries/klogging/KLogger;", "name", "", "clazz", "Lkotlin/reflect/KClass;", "loggerNameFromSource", "nameSource", "Llibraries/klogging/LoggerNameSource;", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/String;", "libraries-klogging"})
public final class KLoggerStaticFactoryKt {
    private static final KLogger defaultLogger(String name) {
        Logger slf4jLogger = LoggerFactory.getLogger((String)name);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }

    private static final KLogger defaultLogger(KClass<?> clazz) {
        Class<?> ourClass = JvmClassMappingKt.getJavaClass(clazz);
        Class<?> parentClass = ourClass.getDeclaringClass();
        Class<?> javaClazz = parentClass != null && clazz.isCompanion() ? parentClass : ourClass;
        Logger slf4jLogger = LoggerFactory.getLogger(javaClazz);
        Intrinsics.checkNotNull((Object)slf4jLogger);
        return new KLogger(new JVMLogger(slf4jLogger));
    }

    @NotNull
    public static final String loggerNameFromSource(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        String name = nameSource.getClass().getName();
        Intrinsics.checkNotNull((Object)name);
        return StringsKt.contains$default((CharSequence)name, (CharSequence)"Kt$", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)name, (String)"Kt$", null, (int)2, null) : (StringsKt.contains$default((CharSequence)name, (CharSequence)"$", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)name, (String)"$", null, (int)2, null) : name);
    }

    public static final /* synthetic */ KLogger access$defaultLogger(String name) {
        return KLoggerStaticFactoryKt.defaultLogger(name);
    }

    public static final /* synthetic */ KLogger access$defaultLogger(KClass clazz) {
        return KLoggerStaticFactoryKt.defaultLogger(clazz);
    }
}

