/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import libraries.io.HexKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lruntime/utils/SHA1Hasher;", "", "<init>", "()V", "hasher", "Ljava/security/MessageDigest;", "update", "", "data", "", "", "hashAsString", "platform-runtime"})
final class SHA1Hasher {
    @NotNull
    private final MessageDigest hasher;

    public SHA1Hasher() {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        Intrinsics.checkNotNull((Object)messageDigest);
        this.hasher = messageDigest;
        this.hasher.reset();
    }

    public final void update(@NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        String string = data2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.hasher.update(byArray);
    }

    public final void update(int data2) {
        int shiftingData = data2;
        for (int i = 0; i < 4; ++i) {
            this.hasher.update((byte)(shiftingData & 0xFF));
            shiftingData >>= 8;
        }
    }

    @NotNull
    public final String hashAsString() {
        byte[] byArray = this.hasher.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return HexKt.toHexString(byArray);
    }
}

