/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api.richText;

import circlet.client.api.richText.RtBlockNode;
import circlet.client.api.richText.RtBlockUnfurl;
import circlet.client.api.richText.RtBlockquote;
import circlet.client.api.richText.RtBreak;
import circlet.client.api.richText.RtBulletList;
import circlet.client.api.richText.RtCode;
import circlet.client.api.richText.RtDocument;
import circlet.client.api.richText.RtDocumentMark;
import circlet.client.api.richText.RtDocumentVisitorKt;
import circlet.client.api.richText.RtEmoji;
import circlet.client.api.richText.RtHeading;
import circlet.client.api.richText.RtHorizontalRule;
import circlet.client.api.richText.RtImage;
import circlet.client.api.richText.RtInlineNode;
import circlet.client.api.richText.RtInlineNodeWithMarks;
import circlet.client.api.richText.RtListItem;
import circlet.client.api.richText.RtMention;
import circlet.client.api.richText.RtOrderedList;
import circlet.client.api.richText.RtParagraph;
import circlet.client.api.richText.RtTable;
import circlet.client.api.richText.RtTableCell;
import circlet.client.api.richText.RtTableHeader;
import circlet.client.api.richText.RtTableRow;
import circlet.client.api.richText.RtTableRowContent;
import circlet.client.api.richText.RtText;
import circlet.client.api.richText.RtUnfurl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.klogging.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 M2\u00020\u0001:\u0001MB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00052\u0006\u0010.\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u00106\u001a\u000207H\u0016J\u0010\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010:\u001a\u00020;H\u0016J\u0014\u0010=\u001a\u00020\u00052\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?J2\u0010A\u001a\u00020\u00052\f\u0010B\u001a\b\u0012\u0004\u0012\u00020;0?2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020;0D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00050FH\u0002J\u0012\u0010G\u001a\b\u0012\u0004\u0012\u00020;0?*\u00020@H\u0002J.\u0010H\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020;0D2\u0006\u0010I\u001a\u00020J2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\u00050LH\u0002\u00a8\u0006N"}, d2={"Lcirclet/client/api/richText/RtDocumentVisitor;", "", "<init>", "()V", "visitDocument", "", "document", "Lcirclet/client/api/richText/RtDocument;", "visitBlockNode", "blockNode", "Lcirclet/client/api/richText/RtBlockNode;", "visitHeading", "heading", "Lcirclet/client/api/richText/RtHeading;", "visitParagraph", "paragraph", "Lcirclet/client/api/richText/RtParagraph;", "visitBulletList", "list", "Lcirclet/client/api/richText/RtBulletList;", "visitOrderedList", "Lcirclet/client/api/richText/RtOrderedList;", "visitListItem", "listItem", "Lcirclet/client/api/richText/RtListItem;", "visitBlockquote", "blockquote", "Lcirclet/client/api/richText/RtBlockquote;", "visitCodeBlock", "code", "Lcirclet/client/api/richText/RtCode;", "visitText", "text", "", "visitHorizontalRule", "visitBreak", "visitEmoji", "emoji", "Lcirclet/client/api/richText/RtEmoji;", "visitImage", "image", "Lcirclet/client/api/richText/RtImage;", "visitMention", "mention", "Lcirclet/client/api/richText/RtMention;", "visitInlineUnfurl", "unfurl", "Lcirclet/client/api/richText/RtUnfurl;", "visitBlockUnfurl", "Lcirclet/client/api/richText/RtBlockUnfurl;", "visitTable", "table", "Lcirclet/client/api/richText/RtTable;", "visitTh", "content", "Lcirclet/client/api/richText/RtTableRowContent;", "visitTd", "onMarkStart", "mark", "Lcirclet/client/api/richText/RtDocumentMark;", "onMarkEnd", "visitInlineNodes", "children", "", "Lcirclet/client/api/richText/RtInlineNode;", "withMarks", "requiredMarks", "openedMarks", "", "block", "Lkotlin/Function0;", "getSortedMarks", "closeMarksDownTo", "index", "", "onClose", "Lkotlin/Function1;", "Companion", "spaceport-client-api"})
@SourceDebugExtension(value={"SMAP\nRtDocumentVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtDocumentVisitor.kt\ncirclet/client/api/richText/RtDocumentVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1863#2,2:178\n1863#2,2:180\n1863#2,2:182\n1863#2,2:184\n1863#2,2:186\n1863#2:188\n1863#2,2:189\n1864#2:191\n1863#2,2:192\n1863#2,2:194\n1863#2,2:196\n1872#2,3:198\n*S KotlinDebug\n*F\n+ 1 RtDocumentVisitor.kt\ncirclet/client/api/richText/RtDocumentVisitor\n*L\n9#1:178,2\n38#1:180,2\n43#1:182,2\n48#1:184,2\n53#1:186,2\n70#1:188\n71#1:189,2\n70#1:191\n82#1:192,2\n88#1:194,2\n99#1:196,2\n129#1:198,3\n*E\n"})
public class RtDocumentVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void visitDocument(@NotNull RtDocument document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Iterable $this$forEach$iv = document2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public final void visitBlockNode(@NotNull RtBlockNode blockNode) {
        Intrinsics.checkNotNullParameter((Object)blockNode, (String)"blockNode");
        RtBlockNode rtBlockNode = blockNode;
        if (rtBlockNode instanceof RtHeading) {
            this.visitHeading((RtHeading)blockNode);
        } else if (rtBlockNode instanceof RtParagraph) {
            this.visitParagraph((RtParagraph)blockNode);
        } else if (rtBlockNode instanceof RtBulletList) {
            this.visitBulletList((RtBulletList)blockNode);
        } else if (rtBlockNode instanceof RtOrderedList) {
            this.visitOrderedList((RtOrderedList)blockNode);
        } else if (rtBlockNode instanceof RtBlockquote) {
            this.visitBlockquote((RtBlockquote)blockNode);
        } else if (rtBlockNode instanceof RtCode) {
            this.visitCodeBlock((RtCode)blockNode);
        } else if (rtBlockNode instanceof RtHorizontalRule) {
            this.visitHorizontalRule();
        } else if (rtBlockNode instanceof RtTable) {
            this.visitTable((RtTable)blockNode);
        } else if (rtBlockNode instanceof RtBlockUnfurl) {
            this.visitBlockUnfurl((RtBlockUnfurl)blockNode);
        } else {
            Companion.getLogger().error("Unsupported block node '" + Reflection.getOrCreateKotlinClass(blockNode.getClass()).getSimpleName() + "'");
        }
    }

    public void visitHeading(@NotNull RtHeading heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        this.visitInlineNodes(heading.getChildren());
    }

    public void visitParagraph(@NotNull RtParagraph paragraph) {
        Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
        this.visitInlineNodes(paragraph.getChildren());
    }

    public void visitBulletList(@NotNull RtBulletList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Iterable $this$forEach$iv = list2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtListItem it = (RtListItem)element$iv;
            boolean bl = false;
            this.visitListItem(it);
        }
    }

    public void visitOrderedList(@NotNull RtOrderedList list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        Iterable $this$forEach$iv = list2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtListItem it = (RtListItem)element$iv;
            boolean bl = false;
            this.visitListItem(it);
        }
    }

    public void visitListItem(@NotNull RtListItem listItem) {
        Intrinsics.checkNotNullParameter((Object)listItem, (String)"listItem");
        Iterable $this$forEach$iv = listItem.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitBlockquote(@NotNull RtBlockquote blockquote) {
        Intrinsics.checkNotNullParameter((Object)blockquote, (String)"blockquote");
        Iterable $this$forEach$iv = blockquote.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitCodeBlock(@NotNull RtCode code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.visitInlineNodes(code.getChildren());
    }

    public void visitText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
    }

    public void visitHorizontalRule() {
    }

    public void visitBreak() {
    }

    public void visitEmoji(@NotNull RtEmoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
    }

    public void visitImage(@NotNull RtImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
    }

    public void visitMention(@NotNull RtMention mention) {
        Intrinsics.checkNotNullParameter((Object)mention, (String)"mention");
    }

    public void visitInlineUnfurl(@NotNull RtUnfurl unfurl) {
        Intrinsics.checkNotNullParameter((Object)unfurl, (String)"unfurl");
    }

    public void visitBlockUnfurl(@NotNull RtBlockUnfurl unfurl) {
        Intrinsics.checkNotNullParameter((Object)unfurl, (String)"unfurl");
    }

    public void visitTable(@NotNull RtTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Iterable $this$forEach$iv = table.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtTableRow row = (RtTableRow)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = row.getChildren();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                RtTableRowContent content2 = (RtTableRowContent)element$iv2;
                boolean bl2 = false;
                RtTableRowContent rtTableRowContent = content2;
                if (rtTableRowContent instanceof RtTableHeader) {
                    this.visitTh(content2);
                    continue;
                }
                if (rtTableRowContent instanceof RtTableCell) {
                    this.visitTd(content2);
                    continue;
                }
                Companion.getLogger().error("Unsupported table row children " + content2);
            }
        }
    }

    public void visitTh(@NotNull RtTableRowContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Iterable $this$forEach$iv = content2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void visitTd(@NotNull RtTableRowContent content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Iterable $this$forEach$iv = content2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtBlockNode it = (RtBlockNode)element$iv;
            boolean bl = false;
            this.visitBlockNode(it);
        }
    }

    public void onMarkStart(@NotNull RtDocumentMark mark) {
        Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
    }

    public void onMarkEnd(@NotNull RtDocumentMark mark) {
        Intrinsics.checkNotNullParameter((Object)mark, (String)"mark");
    }

    public final void visitInlineNodes(@NotNull List<? extends RtInlineNode> children) {
        Intrinsics.checkNotNullParameter(children, (String)"children");
        List openedMarks = new ArrayList();
        Iterable $this$forEach$iv = children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtInlineNode inlineNode = (RtInlineNode)element$iv;
            boolean bl = false;
            this.withMarks(this.getSortedMarks(inlineNode), openedMarks, (Function0<Unit>)((Function0)() -> RtDocumentVisitor.visitInlineNodes$lambda$10$lambda$9(inlineNode, this)));
        }
        this.closeMarksDownTo(openedMarks, 0, (Function1<? super RtDocumentMark, Unit>)((Function1)arg_0 -> RtDocumentVisitor.visitInlineNodes$lambda$11(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final void withMarks(List<? extends RtDocumentMark> requiredMarks, List<RtDocumentMark> openedMarks, Function0<Unit> block) {
        this.closeMarksDownTo(openedMarks, requiredMarks.size(), (Function1<? super RtDocumentMark, Unit>)((Function1)arg_0 -> RtDocumentVisitor.withMarks$lambda$12(this, arg_0)));
        Iterable $this$forEachIndexed$iv = requiredMarks;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mark;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RtDocumentMark rtDocumentMark = (RtDocumentMark)item$iv;
            int index = n;
            boolean bl = false;
            RtDocumentMark openedMark = (RtDocumentMark)CollectionsKt.getOrNull(openedMarks, (int)index);
            if (Intrinsics.areEqual((Object)openedMark, (Object)mark)) continue;
            if (!Intrinsics.areEqual((Object)openedMark, (Object)mark)) {
                this.closeMarksDownTo(openedMarks, index, (Function1<? super RtDocumentMark, Unit>)((Function1)arg_0 -> RtDocumentVisitor.withMarks$lambda$14$lambda$13(this, arg_0)));
            }
            ((Collection)openedMarks).add(mark);
            this.onMarkStart((RtDocumentMark)mark);
        }
        block.invoke();
    }

    private final List<RtDocumentMark> getSortedMarks(RtInlineNode $this$getSortedMarks) {
        if (!($this$getSortedMarks instanceof RtInlineNodeWithMarks)) {
            return CollectionsKt.emptyList();
        }
        return RtDocumentVisitorKt.sortRichTextMarks((Collection<? extends RtDocumentMark>)((RtInlineNodeWithMarks)$this$getSortedMarks).getMarks());
    }

    private final void closeMarksDownTo(List<RtDocumentMark> $this$closeMarksDownTo, int index, Function1<? super RtDocumentMark, Unit> onClose2) {
        while ($this$closeMarksDownTo.size() > index) {
            RtDocumentMark removedMark = (RtDocumentMark)CollectionsKt.removeLast($this$closeMarksDownTo);
            onClose2.invoke((Object)removedMark);
        }
    }

    private static final Unit visitInlineNodes$lambda$10$lambda$9(RtInlineNode $inlineNode, RtDocumentVisitor this$0) {
        Intrinsics.checkNotNullParameter((Object)$inlineNode, (String)"$inlineNode");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        RtInlineNode rtInlineNode = $inlineNode;
        if (rtInlineNode instanceof RtText) {
            this$0.visitText(((RtText)$inlineNode).getValue());
        } else if (rtInlineNode instanceof RtBreak) {
            this$0.visitBreak();
        } else if (rtInlineNode instanceof RtEmoji) {
            this$0.visitEmoji((RtEmoji)$inlineNode);
        } else if (rtInlineNode instanceof RtImage) {
            this$0.visitImage((RtImage)$inlineNode);
        } else if (rtInlineNode instanceof RtMention) {
            this$0.visitMention((RtMention)$inlineNode);
        } else if (rtInlineNode instanceof RtUnfurl) {
            this$0.visitInlineUnfurl((RtUnfurl)$inlineNode);
        } else {
            Companion.getLogger().error("Unsupported inline node '" + Reflection.getOrCreateKotlinClass($inlineNode.getClass()).getSimpleName() + "'");
        }
        return Unit.INSTANCE;
    }

    private static final Unit visitInlineNodes$lambda$11(RtDocumentVisitor this$0, RtDocumentMark it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onMarkEnd(it);
        return Unit.INSTANCE;
    }

    private static final Unit withMarks$lambda$12(RtDocumentVisitor this$0, RtDocumentMark it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onMarkEnd(it);
        return Unit.INSTANCE;
    }

    private static final Unit withMarks$lambda$14$lambda$13(RtDocumentVisitor this$0, RtDocumentMark it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onMarkEnd(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcirclet/client/api/richText/RtDocumentVisitor$Companion;", "Llibraries/klogging/KLogging;", "<init>", "()V", "spaceport-client-api"})
    public static final class Companion
    extends KLogging {
        private Companion() {
            super(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

