/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api.oauth;

import circlet.platform.api.PrimitivesExKt;
import circlet.platform.api.oauth.JWTPayload;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.api.oauth.TokenInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import runtime.Base64;
import runtime.json.JsonDslKt;
import runtime.json.JsonObjectParser;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0003\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"log", "Llibraries/klogging/KLogger;", "toTokenInfo", "Lcirclet/platform/api/oauth/TokenInfo;", "Lcirclet/platform/api/oauth/OAuthTokenResponse$Success;", "payload", "Lcirclet/platform/api/oauth/JWTPayload;", "TOKEN_PARTS_SEPARATOR", "", "extractPayloadText", "", "token", "platform-api"})
@SourceDebugExtension(value={"SMAP\nTokenInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenInfo.kt\ncirclet/platform/api/oauth/TokenInfoKt\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 KLoggers.kt\nlibraries/klogging/KLoggersKt\n*L\n1#1,87:1\n70#2,5:88\n14#3:93\n*S KotlinDebug\n*F\n+ 1 TokenInfo.kt\ncirclet/platform/api/oauth/TokenInfoKt\n*L\n82#1:88,5\n9#1:93\n*E\n"})
public final class TokenInfoKt {
    @NotNull
    private static final KLogger log;
    private static final char TOKEN_PARTS_SEPARATOR = '.';

    @NotNull
    public static final TokenInfo toTokenInfo(@NotNull OAuthTokenResponse.Success $this$toTokenInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toTokenInfo, (String)"<this>");
        return new TokenInfo($this$toTokenInfo.getAccessToken(), PrimitivesExKt.addSeconds(PrimitivesExKt.getNow(), $this$toTokenInfo.getExpiresIn()), $this$toTokenInfo.getRefreshToken(), "");
    }

    @NotNull
    public static final JWTPayload payload(@NotNull TokenInfo $this$payload) {
        Intrinsics.checkNotNullParameter((Object)$this$payload, (String)"<this>");
        String string = TokenInfoKt.extractPayloadText($this$payload.getAccessToken());
        if (string == null) {
            throw new IllegalStateException("Invalid JWT payload".toString());
        }
        String payloadText = string;
        return (JWTPayload)JsonDslKt.map(JsonDslKt.jsonObject(payloadText), TokenInfoKt::payload$lambda$0);
    }

    private static final String extractPayloadText(String token2) {
        String string;
        int headerEndIndex = StringsKt.indexOf$default((CharSequence)token2, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (-1 == headerEndIndex) {
            return null;
        }
        int payloadStartIndex = headerEndIndex + 1;
        if (payloadStartIndex >= token2.length()) {
            return null;
        }
        int payloadEndIndex = StringsKt.indexOf$default((CharSequence)token2, (char)'.', (int)payloadStartIndex, (boolean)false, (int)4, null);
        if (-1 == payloadEndIndex) {
            return null;
        }
        String string2 = token2.substring(payloadStartIndex, payloadEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String payloadBase64 = string2;
        try {
            string = Base64.INSTANCE.decodeUTF8(payloadBase64);
        }
        catch (Throwable t) {
            KLogger this_$iv = log;
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                boolean bl = false;
                String msgStr$iv = "Base64 decoding fails for " + payloadBase64;
                this_$iv.error(t, msgStr$iv);
            }
            string = null;
        }
        return string;
    }

    private static final JWTPayload payload$lambda$0(JsonObjectParser $this$map) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$this$map");
        return new JWTPayload(JsonDslKt.getString($this$map, "sub"));
    }

    static {
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(TokenInfo.class));
    }
}

