/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.client.circlet.platform.client.arenas;

import circlet.platform.api.services.ArenaResponse;
import circlet.platform.api.services.ArenasFailureReason;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0006\b\t\n\u000b\f\rJ\u0019\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007\u0082\u0001\u0006\u000e\u000f\u0010\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "Lcirclet/platform/api/services/ArenasFailureReason;", "toResp", "Lcirclet/platform/api/services/ArenaResponse$Failed;", "arenaId", "Lcirclet/platform/api/ArenaId;", "", "(Ljava/lang/String;)Lcirclet/platform/api/services/ArenaResponse$Failed;", "NoServerResponse", "ArenaNotFoundInCache", "RefNotFoundInCache", "Exception", "Empty", "NestedRefInTombstone", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$ArenaNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Empty;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Exception;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NestedRefInTombstone;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NoServerResponse;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$RefNotFoundInCache;", "platform-client"})
public interface ClientFailureReason
extends ArenasFailureReason {
    @NotNull
    public ArenaResponse.Failed toResp(@NotNull String var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$ArenaNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "arenaId", "Lcirclet/platform/api/ArenaId;", "", "<init>", "(Ljava/lang/String;)V", "getArenaId", "()Ljava/lang/String;", "Ljava/lang/String;", "print", "platform-client"})
    public static final class ArenaNotFoundInCache
    implements ClientFailureReason {
        @NotNull
        private final String arenaId;

        public ArenaNotFoundInCache(@NotNull String arenaId) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            this.arenaId = arenaId;
        }

        @NotNull
        public final String getArenaId() {
            return this.arenaId;
        }

        @Override
        @NotNull
        public String print() {
            return "Arena " + this.arenaId + " is not found in cache";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ArenaResponse.Failed toResp(@NotNull ClientFailureReason $this, @NotNull String arenaId) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            return new ArenaResponse.Failed(arenaId, $this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Empty;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "<init>", "()V", "print", "", "platform-client"})
    public static final class Empty
    implements ClientFailureReason {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @NotNull
        public String print() {
            return "Unresolved record with empty failure reason: the possible cause - server has older version than client.";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$Exception;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "error", "", "<init>", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "print", "platform-client"})
    public static final class Exception
    implements ClientFailureReason {
        @Nullable
        private final String error;

        public Exception(@Nullable String error2) {
            this.error = error2;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        @Override
        @NotNull
        public String print() {
            String string = this.error;
            if (string == null) {
                string = "unknown";
            }
            return string;
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NestedRefInTombstone;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "containerSelector", "", "<init>", "(Ljava/lang/String;)V", "print", "platform-client"})
    public static final class NestedRefInTombstone
    implements ClientFailureReason {
        @NotNull
        private final String containerSelector;

        public NestedRefInTombstone(@NotNull String containerSelector) {
            Intrinsics.checkNotNullParameter((Object)containerSelector, (String)"containerSelector");
            this.containerSelector = containerSelector;
        }

        @Override
        @NotNull
        public String print() {
            return "Unresolved(TS) ref is from other tombstone record " + this.containerSelector;
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$NoServerResponse;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "method", "", "<init>", "(Ljava/lang/String;)V", "getMethod", "()Ljava/lang/String;", "print", "platform-client"})
    public static final class NoServerResponse
    implements ClientFailureReason {
        @NotNull
        private final String method;

        public NoServerResponse(@NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.method = method;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @Override
        @NotNull
        public String print() {
            return "No response from server on calling " + this.method + ", should be investigated and fixed on server-side";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u0012\n\u0010\u0005\u001a\u00060\u0004j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00060\u0004j\u0002`\u0006\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000e"}, d2={"Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason$RefNotFoundInCache;", "Lcirclet/platform/client/circlet/platform/client/arenas/ClientFailureReason;", "arenaId", "Lcirclet/platform/api/ArenaId;", "", "id", "Lcirclet/platform/api/TID;", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getArenaId", "()Ljava/lang/String;", "Ljava/lang/String;", "getId", "print", "platform-client"})
    public static final class RefNotFoundInCache
    implements ClientFailureReason {
        @NotNull
        private final String arenaId;
        @NotNull
        private final String id;

        public RefNotFoundInCache(@NotNull String arenaId, @NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)arenaId, (String)"arenaId");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.arenaId = arenaId;
            this.id = id2;
        }

        @NotNull
        public final String getArenaId() {
            return this.arenaId;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String print() {
            return "Ref " + this.arenaId + "/" + this.id + " is not found in cache";
        }

        @Override
        @NotNull
        public ArenaResponse.Failed toResp(@NotNull String arenaId) {
            return DefaultImpls.toResp(this, arenaId);
        }
    }
}

