/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.workspaces;

import circlet.platform.api.ClientSupportFlag;
import circlet.platform.api.ClientType;
import circlet.platform.api.oauth.CodeChallenge;
import circlet.platform.api.oauth.OAuthFlowKt;
import circlet.platform.api.oauth.OAuthTokenResponse;
import circlet.platform.api.oauth.OpenSet;
import circlet.platform.api.oauth.XScope;
import circlet.platform.workspaces.WorkspaceConfiguration;
import circlet.platform.workspaces.WorkspaceConfigurationKt;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.Http;
import runtime.net.Uri;
import runtime.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0012\b\u0002\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010,J(\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\b\u0010/\u001a\u0004\u0018\u000100H\u0096@\u00a2\u0006\u0002\u00101R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R \u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lcirclet/platform/workspaces/WorkspaceConfigurationImpl;", "Lcirclet/platform/workspaces/WorkspaceConfiguration;", "server", "", "apiServer", "clientId", "clientSecret", "features", "Lcirclet/platform/api/ClientSupportFlags;", "Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/ClientSupportFlag;", "http", "Lruntime/net/Http;", "codeVerifier", "Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "requiredScope", "Lcirclet/platform/api/oauth/XScope;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/oauth/OpenSet;Lruntime/net/Http;Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;Lcirclet/platform/api/oauth/XScope;)V", "getServer", "()Ljava/lang/String;", "getApiServer", "getClientId", "getClientSecret", "getFeatures", "()Lcirclet/platform/api/oauth/OpenSet;", "Lcirclet/platform/api/oauth/OpenSet;", "getHttp", "()Lruntime/net/Http;", "getCodeVerifier", "()Lcirclet/platform/workspaces/WorkspaceConfiguration$CodeVerifier;", "getRequiredScope", "()Lcirclet/platform/api/oauth/XScope;", "codeChallenge", "Lcirclet/platform/api/oauth/CodeChallenge$S256;", "getCodeChallenge", "()Lcirclet/platform/api/oauth/CodeChallenge$S256;", "codeChallenge$delegate", "Lkotlin/Lazy;", "codeFlowURL", "redirectUri", "refreshTokenFlow", "Lcirclet/platform/api/oauth/OAuthTokenResponse;", "refreshToken", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleCodeFlowRedirect", "uri", "clientType", "Lcirclet/platform/api/ClientType;", "(Ljava/lang/String;Ljava/lang/String;Lcirclet/platform/api/ClientType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "platform-app-state"})
@SourceDebugExtension(value={"SMAP\nWorkspaceConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceConfiguration.kt\ncirclet/platform/workspaces/WorkspaceConfigurationImpl\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n14#2,5:165\n1#3:170\n*S KotlinDebug\n*F\n+ 1 WorkspaceConfiguration.kt\ncirclet/platform/workspaces/WorkspaceConfigurationImpl\n*L\n88#1:165,5\n*E\n"})
public final class WorkspaceConfigurationImpl
implements WorkspaceConfiguration {
    @NotNull
    private final String server;
    @NotNull
    private final String apiServer;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final OpenSet<ClientSupportFlag> features;
    @NotNull
    private final Http http;
    @NotNull
    private final WorkspaceConfiguration.CodeVerifier codeVerifier;
    @Nullable
    private final XScope requiredScope;
    @NotNull
    private final Lazy codeChallenge$delegate;

    public WorkspaceConfigurationImpl(@NotNull String server, @NotNull String apiServer, @NotNull String clientId, @NotNull String clientSecret, @NotNull OpenSet<ClientSupportFlag> features2, @NotNull Http http, @NotNull WorkspaceConfiguration.CodeVerifier codeVerifier, @Nullable XScope requiredScope) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)apiServer, (String)"apiServer");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter(features2, (String)"features");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        this.server = server;
        this.apiServer = apiServer;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.features = features2;
        this.http = http;
        this.codeVerifier = codeVerifier;
        this.requiredScope = requiredScope;
        KLogger this_$iv = WorkspaceConfigurationKt.access$getLog$p();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            boolean bl = false;
            String msgStr$iv = "WorkspaceConfiguration.init()";
            this_$iv.debug(msgStr$iv);
        }
        this.codeChallenge$delegate = LazyKt.lazy(() -> WorkspaceConfigurationImpl.codeChallenge_delegate$lambda$1(this));
    }

    public /* synthetic */ WorkspaceConfigurationImpl(String string, String string2, String string3, String string4, OpenSet openSet, Http http, WorkspaceConfiguration.CodeVerifier codeVerifier, XScope xScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            openSet = OpenSet.None.INSTANCE;
        }
        if ((n & 0x80) != 0) {
            xScope = null;
        }
        this(string, string2, string3, string4, openSet, http, codeVerifier, xScope);
    }

    @Override
    @NotNull
    public String getServer() {
        return this.server;
    }

    @Override
    @NotNull
    public String getApiServer() {
        return this.apiServer;
    }

    @Override
    @NotNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @NotNull
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    @NotNull
    public OpenSet<ClientSupportFlag> getFeatures() {
        return this.features;
    }

    @Override
    @NotNull
    public Http getHttp() {
        return this.http;
    }

    @Override
    @NotNull
    public WorkspaceConfiguration.CodeVerifier getCodeVerifier() {
        return this.codeVerifier;
    }

    @Override
    @Nullable
    public XScope getRequiredScope() {
        return this.requiredScope;
    }

    private final CodeChallenge.S256 getCodeChallenge() {
        Lazy lazy = this.codeChallenge$delegate;
        return (CodeChallenge.S256)lazy.getValue();
    }

    @Override
    @NotNull
    public String codeFlowURL(@NotNull String redirectUri) {
        Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
        String string = this.getServer();
        String string2 = this.getClientId();
        CodeChallenge.S256 s256 = this.getCodeChallenge();
        XScope xScope = this.getRequiredScope();
        if (xScope == null) {
            xScope = XScope.All.INSTANCE;
        }
        XScope xScope2 = xScope;
        return OAuthFlowKt.codeFlowURL$default(string, string2, redirectUri, null, xScope2, true, s256, 8, null);
    }

    @Override
    @Nullable
    public Object refreshTokenFlow(@NotNull String refreshToken2, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        Http http = this.getHttp();
        String string = this.getServer();
        String string2 = this.getClientId();
        String string3 = this.getClientSecret();
        XScope xScope = this.getRequiredScope();
        if (xScope == null) {
            xScope = XScope.All.INSTANCE;
        }
        return OAuthFlowKt.refreshTokenFlow$default(http, string, string2, string3, refreshToken2, xScope, null, $completion, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object handleCodeFlowRedirect(@NotNull String uri, @NotNull String redirectUri, @Nullable ClientType clientType, @NotNull Continuation<? super OAuthTokenResponse> $completion) {
        Pair pair;
        Pair[] pairArray;
        String string = Uri.INSTANCE.extractQuery(uri);
        if (string == null) {
            return new OAuthTokenResponse.Error(uri, "500", "Error parsing redirect uri: " + uri, null, 8, null);
        }
        String query2 = string;
        MultiMap<String, String> queryParameters = Uri.INSTANCE.parseQuery(query2);
        String string2 = (String)kotlin.collections.CollectionsKt.firstOrNull((Iterable)queryParameters.get("code"));
        if (string2 == null) {
            return new OAuthTokenResponse.Error(uri, "500", "Error parsing redirect uri, code is missing: " + uri, null, 8, null);
        }
        String code = string2;
        boolean qr = StringsKt.contains$default((CharSequence)uri, (CharSequence)"qr-token", (boolean)false, (int)2, null);
        Pair[] pairArray2 = pairArray = new Pair[1];
        int n = 0;
        ClientType clientType2 = clientType;
        if (clientType2 != null) {
            void it;
            ClientType clientType3 = clientType2;
            int n2 = n;
            Pair[] pairArray3 = pairArray2;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)"X-Client-Type", (Object)it.name());
            pairArray2 = pairArray3;
            n = n2;
            pair = pair2;
        } else {
            pair = null;
        }
        pairArray2[n] = pair;
        Map<String, String> headers = CollectionsKt.mapOfNotNull(pairArray);
        if (qr) {
            return OAuthFlowKt.qrCodeFlowToken(this.getHttp(), this.getServer(), this.getClientId(), this.getClientSecret(), code, true, this.getRequiredScope(), headers, $completion);
        }
        return OAuthFlowKt.codeFlowToken(this.getHttp(), this.getServer(), this.getClientId(), redirectUri, this.getClientSecret(), code, this.getCodeVerifier().getValue(), headers, $completion);
    }

    private static final CodeChallenge.S256 codeChallenge_delegate$lambda$1(WorkspaceConfigurationImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return CodeChallenge.Companion.s256(this$0.getCodeVerifier().getValue());
    }
}

