/*
 * Decompiled with CFR 0.152.
 */
package circlet.principals;

import circlet.client.api.CApplicationPrincipalDetails;
import circlet.client.api.CBuiltInServicePrincipalDetails;
import circlet.client.api.CPrincipalDetails;
import circlet.client.api.CUserPrincipalDetails;
import circlet.client.api.CUserWithEmailPrincipalDetails;
import circlet.principals.ProjectPrincipal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.batchSource.SortableItem;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\rH\u0002J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcirclet/principals/WeightedPrincipal;", "Lruntime/batchSource/SortableItem;", "principal", "Lcirclet/principals/ProjectPrincipal;", "<init>", "(Lcirclet/principals/ProjectPrincipal;)V", "getPrincipal", "()Lcirclet/principals/ProjectPrincipal;", "key", "", "getKey", "()Ljava/lang/String;", "weight", "", "getWeight", "()I", "getPrincipalWeight", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "spaceport-app-state"})
public final class WeightedPrincipal
implements SortableItem {
    @NotNull
    private final ProjectPrincipal principal;
    @NotNull
    private final String key;
    private final int weight;

    public WeightedPrincipal(@NotNull ProjectPrincipal principal) {
        String string;
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        this.principal = principal;
        CPrincipalDetails details = this.principal.getPrincipal().getDetails();
        if (details instanceof CUserPrincipalDetails) {
            string = ((CUserPrincipalDetails)details).getUser().getId();
        } else if (details instanceof CApplicationPrincipalDetails) {
            string = ((CApplicationPrincipalDetails)details).getApp().getId();
        } else if (details instanceof CBuiltInServicePrincipalDetails) {
            string = ((CBuiltInServicePrincipalDetails)details).getKey();
            if (string == null) {
                string = ((CBuiltInServicePrincipalDetails)details).getName();
            }
        } else {
            string = details instanceof CUserWithEmailPrincipalDetails ? ((CUserWithEmailPrincipalDetails)details).getEmail() : "";
        }
        this.key = string;
        this.weight = this.getPrincipalWeight();
    }

    @NotNull
    public final ProjectPrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    private final int getPrincipalWeight() {
        CPrincipalDetails cPrincipalDetails = this.principal.getPrincipal().getDetails();
        return cPrincipalDetails instanceof CUserPrincipalDetails ? 2 : (cPrincipalDetails instanceof CApplicationPrincipalDetails ? 1 : 0);
    }

    @NotNull
    public final ProjectPrincipal component1() {
        return this.principal;
    }

    @NotNull
    public final WeightedPrincipal copy(@NotNull ProjectPrincipal principal) {
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        return new WeightedPrincipal(principal);
    }

    public static /* synthetic */ WeightedPrincipal copy$default(WeightedPrincipal weightedPrincipal, ProjectPrincipal projectPrincipal, int n, Object object) {
        if ((n & 1) != 0) {
            projectPrincipal = weightedPrincipal.principal;
        }
        return weightedPrincipal.copy(projectPrincipal);
    }

    @NotNull
    public String toString() {
        return "WeightedPrincipal(principal=" + this.principal + ")";
    }

    public int hashCode() {
        return this.principal.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WeightedPrincipal)) {
            return false;
        }
        WeightedPrincipal weightedPrincipal = (WeightedPrincipal)other;
        return Intrinsics.areEqual((Object)this.principal, (Object)weightedPrincipal.principal);
    }
}

