/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.FailureInfo;
import runtime.RpcException;
import runtime.ValidationError;
import runtime.ValidationResult;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u000b\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"internalFailure", "", "Lruntime/FailureInfo;", "getInternalFailure", "(Lruntime/FailureInfo;)Ljava/lang/String;", "INTERNAL_SERVER_ERROR_MESSAGE", "message", "Lruntime/ValidationResult;", "messageQuick", "Lruntime/ValidationError;", "getFailureMessage", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nRpcException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RpcException.kt\nruntime/RpcExceptionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class RpcExceptionKt {
    @NotNull
    public static final String INTERNAL_SERVER_ERROR_MESSAGE = "An internal server error occurred. Please contact the server administrator or see server logs for details.";

    @Nullable
    public static final String getInternalFailure(@NotNull FailureInfo $this$internalFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$internalFailure, (String)"<this>");
        return $this$internalFailure.getAuthenticationError() != null || $this$internalFailure.getValidationError() != null || $this$internalFailure.getSecurityError() != null || $this$internalFailure.getRequestError() != null || $this$internalFailure.getTransportError() != null || $this$internalFailure.getNotFoundError() != null ? null : INTERNAL_SERVER_ERROR_MESSAGE;
    }

    @NotNull
    public static final String message(@NotNull FailureInfo $this$message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        if ($this$message.getAuthenticationError() != null) {
            string = $this$message.getAuthenticationError();
        } else if ($this$message.getSecurityError() != null) {
            string = $this$message.getSecurityError();
        } else if ($this$message.getValidationError() != null) {
            string = RpcExceptionKt.message($this$message.getValidationError());
        } else if ($this$message.getRequestError() != null) {
            string = $this$message.getRequestError();
        } else if ($this$message.getTransportError() != null) {
            string = $this$message.getTransportError();
        } else if ($this$message.getNotFoundError() != null) {
            string = $this$message.getNotFoundError();
        } else {
            String string2 = RpcExceptionKt.getInternalFailure($this$message);
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    @NotNull
    public static final String message(@NotNull ValidationResult $this$message) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"<this>");
        if ($this$message.getPrintAllErrors()) {
            ValidationError[] validationErrorArray;
            ValidationError[] it = validationErrorArray = $this$message.getErrors();
            boolean bl = false;
            object = !(it.length == 0) ? validationErrorArray : null;
            if (object == null || (object = ArraysKt.joinToString$default((Object[])object, (CharSequence)"\n", null, null, (int)0, null, RpcExceptionKt::message$lambda$1, (int)30, null)) == null) {
                object = "Validation error";
            }
        } else {
            object = (ValidationError[])ArraysKt.firstOrNull((Object[])$this$message.getErrors());
            if (object == null || (object = RpcExceptionKt.messageQuick((ValidationError)object)) == null) {
                object = "Validation error";
            }
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationError $this$messageQuick) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
                object = $this$messageQuick.getParameter();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "Validation of parameter " + it + " failed: " + $this$messageQuick.getMessage();
                object = string;
                if (string != null) break block3;
            }
            object = $this$messageQuick.getMessage();
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationResult $this$messageQuick) {
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        Object object = (ValidationError)ArraysKt.firstOrNull((Object[])$this$messageQuick.getErrors());
        if (object == null || (object = ((ValidationError)object).getMessage()) == null) {
            object = "Validation error";
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull FailureInfo $this$messageQuick) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"<this>");
        if ($this$messageQuick.getAuthenticationError() != null) {
            string = $this$messageQuick.getAuthenticationError();
        } else if ($this$messageQuick.getSecurityError() != null) {
            string = $this$messageQuick.getSecurityError();
        } else if ($this$messageQuick.getValidationError() != null) {
            string = RpcExceptionKt.messageQuick($this$messageQuick.getValidationError());
        } else if ($this$messageQuick.getRequestError() != null) {
            string = $this$messageQuick.getRequestError();
        } else if ($this$messageQuick.getTransportError() != null) {
            string = $this$messageQuick.getTransportError();
        } else if ($this$messageQuick.getNotFoundError() != null) {
            string = $this$messageQuick.getNotFoundError();
        } else {
            String string2 = RpcExceptionKt.getInternalFailure($this$messageQuick);
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    @NotNull
    public static final String getFailureMessage(@NotNull Throwable $this$getFailureMessage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getFailureMessage, (String)"<this>");
        if ($this$getFailureMessage instanceof RpcException) {
            string = RpcExceptionKt.message(((RpcException)$this$getFailureMessage).getFailure());
        } else {
            string = $this$getFailureMessage.getMessage();
            if (string == null) {
                string = $this$getFailureMessage.toString();
            }
        }
        return string;
    }

    private static final CharSequence message$lambda$1(ValidationError it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RpcExceptionKt.messageQuick(it);
    }
}

