/*
 * Decompiled with CFR 0.152.
 */
package runtime.utils;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.Source;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB5\b\u0016\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ%\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005H\u0096\u0001JK\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001428\u0010\u0017\u001a4\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00060\u0018H\u0096\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u0096\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fX\u0096\u0005\u00a8\u0006 "}, d2={"Lruntime/utils/PersistingMutableProperty;", "T", "Lruntime/reactive/MutableProperty;", "delegate", "store", "Lkotlin/Function1;", "", "<init>", "(Lruntime/reactive/MutableProperty;Lkotlin/jvm/functions/Function1;)V", "defaultValue", "load", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "forEach", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "sink", "forEachWithPrevious", "consume", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "prev", "next", "forceNotify", "changes", "Lruntime/reactive/Source;", "platform-runtime"})
public final class PersistingMutableProperty<T>
implements MutableProperty<T> {
    @NotNull
    private final MutableProperty<T> delegate;
    @NotNull
    private final Function1<T, Unit> store;

    private PersistingMutableProperty(MutableProperty<T> delegate, Function1<? super T, Unit> store2) {
        this.delegate = delegate;
        this.store = store2;
    }

    @Override
    public void forceNotify() {
        this.delegate.forceNotify();
    }

    @Override
    public void forEach(@NotNull Lifetime lifetime, @NotNull Function1<? super T, Unit> sink) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.delegate.forEach(lifetime, sink);
    }

    @Override
    public void forEachWithPrevious(@NotNull Lifetime lifetime, @NotNull Function2<? super T, ? super T, Unit> consume) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(consume, (String)"consume");
        this.delegate.forEachWithPrevious(lifetime, consume);
    }

    @Override
    @NotNull
    public Source<T> getChanges() {
        return this.delegate.getChanges();
    }

    public PersistingMutableProperty(T defaultValue, @NotNull Function1<? super T, Unit> store2, @NotNull Function0<? extends T> load2) {
        Intrinsics.checkNotNullParameter(store2, (String)"store");
        Intrinsics.checkNotNullParameter(load2, (String)"load");
        Object object = load2.invoke();
        if (object == null) {
            object = defaultValue;
        }
        this(Property.Companion.createMutable(object), store2);
    }

    @Override
    public T getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(T value2) {
        this.store.invoke(value2);
        this.delegate.setValue(value2);
    }
}

