/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spaceport.components;

import circlet.platform.api.PrimitivesExKt;
import circlet.workspaces.Workspace;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.spaceport.components.SpaceInactivityDetectorKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\f\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/spaceport/components/SpaceInactivityDetector;", "", "<init>", "()V", "reconnectWorkspaceAfterInactivity", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "workspace", "Lcirclet/workspaces/Workspace;", "reconnectWorkspaceOnIDEOpen", "reconnectWorkspaceOnSleep", "reconnect", "intellij.spaceport"})
@SourceDebugExtension(value={"SMAP\nSpaceInactivityDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceInactivityDetector.kt\ncom/intellij/spaceport/components/SpaceInactivityDetector\n+ 2 LifetimeUtils.kt\nlibraries/coroutines/extra/LifetimeUtilsKt\n*L\n1#1,63:1\n199#2:64\n226#2,5:65\n*S KotlinDebug\n*F\n+ 1 SpaceInactivityDetector.kt\ncom/intellij/spaceport/components/SpaceInactivityDetector\n*L\n59#1:64\n59#1:65,5\n*E\n"})
public final class SpaceInactivityDetector {
    @NotNull
    public static final SpaceInactivityDetector INSTANCE = new SpaceInactivityDetector();

    private SpaceInactivityDetector() {
    }

    public final void reconnectWorkspaceAfterInactivity(@NotNull CoroutineScope coroutineScope, @NotNull Workspace workspace) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this.reconnectWorkspaceOnSleep(coroutineScope, workspace);
        this.reconnectWorkspaceOnIDEOpen(coroutineScope, workspace);
    }

    private final void reconnectWorkspaceOnIDEOpen(CoroutineScope coroutineScope, Workspace workspace) {
        Ref.LongRef lastVisible = new Ref.LongRef();
        lastVisible.element = PrimitivesExKt.getNowMs();
        long reconnectAfterMs = Duration.ofMinutes(10L).toMillis();
        SimpleMessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect(coroutineScope);
        Topic topic = ApplicationActivationListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        appConnection.subscribe(topic, (Object)new ApplicationActivationListener(lastVisible, reconnectAfterMs, workspace){
            final /* synthetic */ Ref.LongRef $lastVisible;
            final /* synthetic */ long $reconnectAfterMs;
            final /* synthetic */ Workspace $workspace;
            {
                this.$lastVisible = $lastVisible;
                this.$reconnectAfterMs = $reconnectAfterMs;
                this.$workspace = $workspace;
            }

            public void applicationActivated(IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                if (PrimitivesExKt.getNowMs() - this.$lastVisible.element > this.$reconnectAfterMs) {
                    SpaceInactivityDetector.access$reconnect(SpaceInactivityDetector.INSTANCE, this.$workspace);
                    SpaceInactivityDetectorKt.access$getLOG$p().info("Reconnecting to workspace because of inactivity");
                }
            }

            public void applicationDeactivated(IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                this.$lastVisible.element = PrimitivesExKt.getNowMs();
            }
        });
    }

    private final void reconnectWorkspaceOnSleep(CoroutineScope coroutineScope, Workspace workspace) {
        Ref.LongRef currentTime = new Ref.LongRef();
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentTime, workspace, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Ref.LongRef $currentTime;
            final /* synthetic */ Workspace $workspace;
            {
                this.$currentTime = $currentTime;
                this.$workspace = $workspace;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.$currentTime.element = PrimitivesExKt.getNowMs();
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)Duration.ofSeconds(20L).toMillis(), (Continuation)((Continuation)this));
                            if (v0 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if (PrimitivesExKt.getNowMs() - this.$currentTime.element <= Duration.ofMinutes(1L).toMillis()) ** GOTO lbl6
                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$workspace, null){
                            int label;
                            final /* synthetic */ Workspace $workspace;
                            {
                                this.$workspace = $workspace;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        SpaceInactivityDetector.access$reconnect(SpaceInactivityDetector.INSTANCE, this.$workspace);
                                        SpaceInactivityDetectorKt.access$getLOG$p().info("Reconnecting to workspace because of computer hibernation");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reconnect(Workspace $this$reconnect) {
        boolean $i$f$using = false;
        LifetimeSource $this$runAndTerminate$iv$iv = new LifetimeSource();
        boolean $i$f$runAndTerminate = false;
        try {
            Lifetime lt = (Lifetime)$this$runAndTerminate$iv$iv;
            boolean bl = false;
            $this$reconnect.getClient().interruptConnection(lt);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeSource it$iv = $this$runAndTerminate$iv$iv;
            boolean bl = false;
            it$iv.terminate();
        }
    }

    public static final /* synthetic */ void access$reconnect(SpaceInactivityDetector $this, Workspace $receiver) {
        $this.reconnect($receiver);
    }
}

