/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.dictionary;

import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectDictionary
implements EditableDictionary {
    @NonNls
    public static final String DEFAULT_CURRENT_DICT_NAME = "project";
    private static final String DEFAULT_PROJECT_DICTIONARY_NAME = "project";
    private String activeName;
    private Set<EditableDictionary> dictionaries;

    public ProjectDictionary() {
    }

    public ProjectDictionary(@NotNull Set<EditableDictionary> dictionaries) {
        if (dictionaries == null) {
            ProjectDictionary.$$$reportNull$$$0(0);
        }
        this.dictionaries = dictionaries;
    }

    @Override
    @NotNull
    public String getName() {
        return "project";
    }

    public void setActiveName(String name) {
        this.activeName = name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        if (word == null) {
            ProjectDictionary.$$$reportNull$$$0(1);
        }
        if (this.dictionaries == null) {
            return null;
        }
        int errors = 0;
        for (Dictionary dictionary : this.dictionaries) {
            Dictionary.LookupStatus status = dictionary.lookup(word);
            if (status == Dictionary.LookupStatus.Alien) {
                ++errors;
                continue;
            }
            if (status != Dictionary.LookupStatus.Present) continue;
            return true;
        }
        if (errors == this.dictionaries.size()) {
            return null;
        }
        return false;
    }

    @Override
    public void addToDictionary(String word) {
        this.getOrCreateActiveDictionary().addToDictionary(word);
    }

    @Override
    public void removeFromDictionary(String word) {
        EditableDictionary dictionary = this.getActiveDictionary();
        if (dictionary == null) {
            return;
        }
        dictionary.removeFromDictionary(word);
    }

    @Nullable
    private EditableDictionary getActiveDictionary() {
        if (this.activeName == null || this.dictionaries == null) {
            return null;
        }
        return this.getDictionaryByName(this.activeName);
    }

    @NotNull
    private EditableDictionary getOrCreateActiveDictionary() {
        EditableDictionary result;
        if (this.activeName == null) {
            this.activeName = "project";
        }
        if ((result = this.getActiveDictionary()) == null) {
            result = new UserDictionary(this.activeName);
            if (this.dictionaries == null) {
                this.dictionaries = ConcurrentHashMap.newKeySet();
            }
            this.dictionaries.add(result);
        }
        EditableDictionary editableDictionary = result;
        if (editableDictionary == null) {
            ProjectDictionary.$$$reportNull$$$0(2);
        }
        return editableDictionary;
    }

    @Nullable
    private EditableDictionary getDictionaryByName(@NotNull String name) {
        if (name == null) {
            ProjectDictionary.$$$reportNull$$$0(3);
        }
        if (this.dictionaries == null) {
            return null;
        }
        for (EditableDictionary dictionary : this.dictionaries) {
            if (!dictionary.getName().equals(name)) continue;
            return dictionary;
        }
        return null;
    }

    @Override
    public void replaceAll(@Nullable Collection<String> words) {
        this.getOrCreateActiveDictionary().replaceAll(words);
    }

    @Override
    public void clear() {
        EditableDictionary dictionary = this.getActiveDictionary();
        if (dictionary == null) {
            return;
        }
        dictionary.clear();
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        if (this.dictionaries == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ProjectDictionary.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set words = CollectionFactory.createSmallMemoryFootprintSet();
        for (Dictionary dictionary : this.dictionaries) {
            words.addAll(dictionary.getWords());
        }
        Set set = words;
        if (set == null) {
            ProjectDictionary.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getEditableWords() {
        EditableDictionary dictionary = this.getActiveDictionary();
        if (dictionary == null) {
            Set<String> set = Set.of();
            if (set == null) {
                ProjectDictionary.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<String> set = dictionary.getEditableWords();
        if (set == null) {
            ProjectDictionary.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getCamelCaseWords() {
        EditableDictionary dictionary = this.getActiveDictionary();
        if (dictionary == null) {
            Set<String> set = Set.of();
            if (set == null) {
                ProjectDictionary.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<String> set = dictionary.getCamelCaseWords();
        if (set == null) {
            ProjectDictionary.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Override
    public void addToDictionary(@Nullable Collection<String> words) {
        this.getOrCreateActiveDictionary().addToDictionary(words);
    }

    public Set<EditableDictionary> getDictionaries() {
        return this.dictionaries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectDictionary that = (ProjectDictionary)o;
        if (!Objects.equals(this.activeName, that.activeName)) {
            return false;
        }
        return Objects.equals(this.dictionaries, that.dictionaries);
    }

    public int hashCode() {
        int result = this.activeName != null ? this.activeName.hashCode() : 0;
        result = 31 * result + (this.dictionaries != null ? this.dictionaries.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "ProjectDictionary{activeName='" + this.activeName + "', dictionaries=" + String.valueOf(this.dictionaries) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dictionaries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/dictionary/ProjectDictionary";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/dictionary/ProjectDictionary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateActiveDictionary";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWords";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableWords";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCamelCaseWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDictionaryByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

