/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.frontend.gateway.action;

import com.intellij.codeWithMe.ClientId;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenActionsUtil;
import com.intellij.station.frontend.StationFrontendBundle;
import com.intellij.station.frontend.action.ToolboxWelcomeRemdevActionKt;
import com.intellij.station.frontend.action.ToolboxWelcomeRemdevPanel;
import com.intellij.station.frontend.action.ToolboxWelcomeRemdevService;
import com.intellij.station.frontend.gateway.action.CombinedRemdevState;
import com.intellij.station.frontend.gateway.action.CombinedWelcomeRemdevActionKt;
import com.intellij.station.frontend.gateway.action.OpenGatewayAction;
import com.intellij.station.frontend.gateway.action.OpenToolboxAction;
import com.intellij.station.frontend.gateway.action.ToggleDefaultAction;
import com.intellij.station.frontend.icons.StationFrontendIcons;
import com.intellij.ui.AnimatedIcon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/station/frontend/gateway/action/CombinedWelcomeRemdevAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.station.frontend.gateway"})
@SourceDebugExtension(value={"SMAP\nCombinedWelcomeRemdevAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CombinedWelcomeRemdevAction.kt\ncom/intellij/station/frontend/gateway/action/CombinedWelcomeRemdevAction\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,188:1\n42#2,3:189\n42#2,3:192\n42#2,3:195\n*S KotlinDebug\n*F\n+ 1 CombinedWelcomeRemdevAction.kt\ncom/intellij/station/frontend/gateway/action/CombinedWelcomeRemdevAction\n*L\n45#1:189,3\n54#1:192,3\n58#1:195,3\n*E\n"})
public final class CombinedWelcomeRemdevAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!ToolboxWelcomeRemdevActionKt.isStationWelcomeScreenPromoEntryPointEnabled()) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)e.getData(WelcomeScreenActionsUtil.NON_MODAL_WELCOME_SCREEN), (Object)true)) {
            e.getPresentation().setIcon(AllIcons.Nodes.Plugin);
        } else if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"WelcomeScreen")) {
            if (FlatWelcomeFrame.USE_TABBED_WELCOME_SCREEN) {
                presentation2.setIcon(StationFrontendIcons.ToolboxWelcome);
            } else {
                presentation2.setIcon(StationFrontendIcons.Toolbox);
            }
        } else {
            presentation2.setIcon(null);
        }
        boolean $i$f$service = false;
        Class<ToolboxWelcomeRemdevService> serviceClass$iv = ToolboxWelcomeRemdevService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        boolean showProgress = (Boolean)((ToolboxWelcomeRemdevService)object).isRunning().getValue();
        presentation2.putClientProperty(WelcomeScreenActionsUtil.TEXT_BUTTON_RIGHT_ICON, showProgress ? AnimatedIcon.Default.INSTANCE : null);
        Object[] objectArray = new Object[4];
        objectArray[0] = new OpenToolboxAction();
        objectArray[1] = new OpenGatewayAction();
        Intrinsics.checkNotNullExpressionValue((Object)Separator.getInstance(), (String)"getInstance(...)");
        objectArray[3] = new ToggleDefaultAction();
        presentation2.putClientProperty(ActionUtil.INLINE_ACTIONS, (Object)CollectionsKt.listOf((Object[])objectArray));
        presentation2.putClientProperty(WelcomeScreenActionsUtil.INLINE_ACTIONS_POPUP_AD_TEXT, (Object)StationFrontendBundle.INSTANCE.message("action.CombinedWelcomeRemdevAction.popupHint", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$service = false;
        Class<CombinedRemdevState> serviceClass$iv = CombinedRemdevState.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((CombinedRemdevState)((Object)object)).isUseGatewayAsDefault()) {
            CombinedWelcomeRemdevActionKt.access$openGateway(e);
        } else {
            boolean $i$f$service2 = false;
            Class<ToolboxWelcomeRemdevService> serviceClass$iv2 = ToolboxWelcomeRemdevService.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ToolboxWelcomeRemdevService remdevService = (ToolboxWelcomeRemdevService)object2;
            if (remdevService.shouldShowPromoPopup()) {
                ToolboxWelcomeRemdevPanel.Companion.showPopup(e);
            } else {
                remdevService.createNewSshConnection(e.getProject());
            }
        }
    }
}

