/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.SwitchToFileEditorAction;
import com.intellij.diff.actions.SwitchToRecentEditorActionGroup;
import com.intellij.diff.actions.impl.MutableDiffRequestChain;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.BlankDiffWindowUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u00a8\u0006\u000f"}, d2={"createEditableContent", "Lcom/intellij/diff/contents/DocumentContent;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "createFileContent", "file", "Ljava/io/File;", "Lcom/intellij/openapi/vfs/VirtualFile;", "createBlankNotificationProvider", "Ljavax/swing/JComponent;", "viewer", "Lcom/intellij/diff/FrameDiffTool$DiffViewer;", "content", "intellij.platform.diff.impl"})
public final class ShowBlankDiffWindowActionKt {
    @NotNull
    public static final DocumentContent createEditableContent(@Nullable Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DocumentContent documentContent = DiffContentFactoryEx.getInstanceEx().documentContent(project, false).buildFromText(text, false);
        Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"buildFromText(...)");
        DocumentContent content = documentContent;
        content.putUserData(BlankDiffWindowUtil.REMEMBER_CONTENT_KEY, (Object)true);
        DiffUtil.addNotification(arg_0 -> ShowBlankDiffWindowActionKt.createEditableContent$lambda$0(content, arg_0), (UserDataHolder)content);
        return content;
    }

    public static /* synthetic */ DocumentContent createEditableContent$default(Project project, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return ShowBlankDiffWindowActionKt.createEditableContent(project, string);
    }

    private static final DocumentContent createFileContent(Project project, File file) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return ShowBlankDiffWindowActionKt.createFileContent(project, virtualFile2);
    }

    private static final DocumentContent createFileContent(Project project, VirtualFile file) {
        return DiffContentFactory.getInstance().createDocument(project, file);
    }

    private static final JComponent createBlankNotificationProvider(FrameDiffTool.DiffViewer viewer, DocumentContent content) {
        EditorEx editorEx;
        if (!(viewer instanceof DiffViewerBase)) {
            return null;
        }
        DiffContext diffContext = ((DiffViewerBase)viewer).getContext();
        Intrinsics.checkNotNullExpressionValue((Object)diffContext, (String)"getContext(...)");
        ContentDiffRequest contentDiffRequest = ((DiffViewerBase)viewer).getRequest();
        Intrinsics.checkNotNullExpressionValue((Object)contentDiffRequest, (String)"getRequest(...)");
        MutableDiffRequestChain.Helper helper = MutableDiffRequestChain.Companion.createHelper(diffContext, (DiffRequest)contentDiffRequest);
        if (helper == null) {
            return null;
        }
        MutableDiffRequestChain.Helper helper2 = helper;
        DiffViewerBase diffViewerBase = (DiffViewerBase)viewer;
        if (diffViewerBase instanceof TwosideTextDiffViewer) {
            List<? extends DocumentContent> list = ((TwosideTextDiffViewer)viewer).getContents();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContents(...)");
            index = CollectionsKt.indexOf(list, (Object)content);
            if (index == -1) {
                return null;
            }
            editorEx = ((TwosideTextDiffViewer)viewer).getEditors().get(index);
        } else if (diffViewerBase instanceof ThreesideTextDiffViewer) {
            List<? extends DocumentContent> list = ((ThreesideTextDiffViewer)viewer).getContents();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getContents(...)");
            index = CollectionsKt.indexOf(list, (Object)content);
            if (index == -1) {
                return null;
            }
            editorEx = ((ThreesideTextDiffViewer)viewer).getEditors().get(index);
        } else {
            return null;
        }
        EditorEx editor = editorEx;
        if (editor.getDocument().getTextLength() != 0) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel((Editor)editor, null, null, EditorNotificationPanel.Status.Info);
        panel.createActionLabel(DiffBundle.message((String)"notification.action.text.blank.diff.select.file", (Object[])new Object[0]), () -> ShowBlankDiffWindowActionKt.createBlankNotificationProvider$lambda$0(editor, viewer, helper2));
        if (!((Collection)BlankDiffWindowUtil.INSTANCE.getRecentFiles$intellij_platform_diff_impl()).isEmpty()) {
            HyperlinkLabel hyperlinkLabel;
            HyperlinkLabel $this$createBlankNotificationProvider_u24lambda_u242 = hyperlinkLabel = panel.createActionLabel(DiffBundle.message((String)"notification.action.text.blank.diff.recent", (Object[])new Object[0]), () -> ShowBlankDiffWindowActionKt.createBlankNotificationProvider$lambda$1(editor));
            boolean bl = false;
            $this$createBlankNotificationProvider_u24lambda_u242.setIcon(AllIcons.General.LinkDropTriangle);
            $this$createBlankNotificationProvider_u24lambda_u242.setIconAtRight(true);
            $this$createBlankNotificationProvider_u24lambda_u242.setUseIconAsLink(true);
        }
        editor.getDocument().addDocumentListener(new DocumentListener(editor, panel){
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ EditorNotificationPanel $panel;
            {
                this.$editor = $editor;
                this.$panel = $panel;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$editor.getDocument().removeDocumentListener((DocumentListener)this);
                DiffNotifications.hideNotification(this.$panel);
            }
        }, (Disposable)viewer);
        return (JComponent)panel;
    }

    private static final JComponent createEditableContent$lambda$0(DocumentContent $content, FrameDiffTool.DiffViewer viewer) {
        return ShowBlankDiffWindowActionKt.createBlankNotificationProvider(viewer, $content);
    }

    private static final void createBlankNotificationProvider$lambda$0(EditorEx $editor, FrameDiffTool.DiffViewer $viewer, MutableDiffRequestChain.Helper $helper) {
        new SwitchToFileEditorAction().perform((Editor)$editor, $viewer, $helper);
    }

    private static final void createBlankNotificationProvider$lambda$1(EditorEx $editor) {
        ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("popup@BlankDiffWindow.Recent.Menu", (ActionGroup)new SwitchToRecentEditorActionGroup());
        Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
        ActionPopupMenu menu = actionPopupMenu;
        menu.setTargetComponent($editor.getComponent());
        AWTEvent event = IdeEventQueue.Companion.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent) {
            JBPopupMenu.showByEvent((MouseEvent)((MouseEvent)event), (JPopupMenu)menu.getComponent());
        } else {
            JBPopupMenu.showByEditor((Editor)((Editor)$editor), (JPopupMenu)menu.getComponent());
        }
    }

    public static final /* synthetic */ DocumentContent access$createFileContent(Project project, VirtualFile file) {
        return ShowBlankDiffWindowActionKt.createFileContent(project, file);
    }

    public static final /* synthetic */ DocumentContent access$createFileContent(Project project, File file) {
        return ShowBlankDiffWindowActionKt.createFileContent(project, file);
    }
}

