/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.BreadcrumbsPlacement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final Supplier<? extends List<? extends Editor>> myEditors;
    @Nullable
    private SyncScrollSupport.Support mySyncScrollSupport;
    protected final AnAction @NotNull [] myActions;

    @ApiStatus.Internal
    public SetEditorSettingsActionGroup(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors) {
        if (settings == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(0);
        }
        if (editors == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(1);
        }
        this(settings, () -> editors);
    }

    @ApiStatus.Internal
    public SetEditorSettingsActionGroup(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Supplier<? extends List<? extends Editor>> editors) {
        if (settings == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(2);
        }
        if (editors == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(3);
        }
        super(DiffBundle.message((String)"editor.settings", (Object[])new Object[0]), null, AllIcons.General.GearPlain);
        this.myTextSettings = settings;
        this.myEditors = editors;
        this.installGutterPopup();
        this.myActions = new AnAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsActionGroup.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsActionGroup.this.myTextSettings.setShowWhitespaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isWhitespacesShown() != value) {
                    editor.getSettings().setWhitespacesShown(value);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$1", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsActionGroup.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsActionGroup.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isLineNumbersShown() != value) {
                    editor.getSettings().setLineNumbersShown(value);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$2", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsActionGroup.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsActionGroup.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isIndentGuidesShown() != value) {
                    editor.getSettings().setIndentGuidesShown(value);
                    editor.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$3", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                boolean hasForcedSoftWraps = ContainerUtil.exists((Iterable)SetEditorSettingsActionGroup.this.myEditors.get(), editor -> Boolean.TRUE.equals(editor.getUserData(EditorImpl.FORCED_SOFT_WRAPS)));
                return this.myForcedSoftWrap || SetEditorSettingsActionGroup.this.myTextSettings.isUseSoftWraps() || hasForcedSoftWraps;
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsActionGroup.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor, boolean value) {
                if (editor == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (editor.getSettings().isUseSoftWraps() == value) {
                    return;
                }
                if (SetEditorSettingsActionGroup.this.mySyncScrollSupport != null) {
                    SetEditorSettingsActionGroup.this.mySyncScrollSupport.enterDisableScrollSection();
                }
                try {
                    AbstractToggleUseSoftWrapsAction.toggleSoftWraps((Editor)editor, null, (boolean)value);
                }
                finally {
                    if (SetEditorSettingsActionGroup.this.mySyncScrollSupport != null) {
                        SetEditorSettingsActionGroup.this.mySyncScrollSupport.exitDisableScrollSection();
                    }
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors) {
                if (editors == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!SetEditorSettingsActionGroup.this.myTextSettings.isUseSoftWraps()) {
                    for (Editor editor : editors) {
                        this.myForcedSoftWrap = this.myForcedSoftWrap || ((EditorImpl)editor).getSoftWrapModel().shouldSoftWrapsBeForced();
                    }
                }
                super.applyDefaults(editors);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editors";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyDefaults";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new EditorHighlightingLayerGroup(), new EditorBreadcrumbsPlacementGroup()};
    }

    public void setSyncScrollSupport(@Nullable SyncScrollSupport.Support syncScrollSupport) {
        this.mySyncScrollSupport = syncScrollSupport;
    }

    public void installGutterPopup() {
        for (Editor editor : this.myEditors.get()) {
            ((EditorGutterComponentEx)editor.getGutter()).setGutterPopupGroup((ActionGroup)this);
        }
    }

    public void applyDefaults() {
        for (AnAction action2 : this.myActions) {
            if (!(action2 instanceof EditorSettingAction)) continue;
            ((EditorSettingAction)action2).applyDefaults(this.myEditors.get());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(5);
        }
        e.getPresentation().setPopupGroup(e.isFromActionToolbar());
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction editorSettingsGroup = ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu.EditorSettings");
        ArrayList<Object> actions = new ArrayList<Object>();
        ContainerUtil.addAll(actions, (Object[])this.myActions);
        actions.add(editorSettingsGroup);
        actions.add(Separator.getInstance());
        if (e != null && e.getData(DiffDataKeys.MERGE_VIEWER) != null) {
            actions.add(Separator.getInstance());
            actions.add(ActionManager.getInstance().getAction("ContextHelp"));
        }
        if (e != null && "DiffToolbar".equals(e.getPlace())) {
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                SetEditorSettingsActionGroup.$$$reportNull$$$0(6);
            }
            return anActionArray;
        }
        ActionGroup gutterGroup = (ActionGroup)ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu");
        ArrayList<AnAction> result = new ArrayList<AnAction>(Arrays.asList(gutterGroup.getChildren(e)));
        result.add((AnAction)Separator.getInstance());
        SetEditorSettingsActionGroup.replaceOrAppend(result, editorSettingsGroup, new DefaultActionGroup(actions));
        AnAction[] anActionArray = result.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            SetEditorSettingsActionGroup.$$$reportNull$$$0(7);
        }
        return anActionArray;
    }

    protected static <T> void replaceOrAppend(List<T> list, T from, T to) {
        int index = list.indexOf(from);
        if (index == -1) {
            index = list.size();
        }
        list.remove(from);
        list.add(index, to);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }

    private class EditorHighlightingLayerGroup
    extends ActionGroup
    implements EditorSettingAction,
    DumbAware {
        private final AnAction[] myOptions;

        EditorHighlightingLayerGroup() {
            super(DiffBundle.message((String)"highlighting.level", (Object[])new Object[0]), true);
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])HighlightingLevel.values(), level -> new OptionAction((HighlightingLevel)((Object)level)), (Object[])AnAction.EMPTY_ARRAY);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(1);
            }
            this.apply(SetEditorSettingsActionGroup.this.myTextSettings.getHighlightingLevel());
        }

        private void apply(@NotNull HighlightingLevel layer) {
            if (layer == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(2);
            }
            for (Editor editor : SetEditorSettingsActionGroup.this.myEditors.get()) {
                if (!(editor instanceof EditorImpl)) continue;
                ((EditorImpl)editor).setHighlightingPredicate(layer.getCondition());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorHighlightingLayerGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorHighlightingLayerGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final HighlightingLevel myLayer;

            OptionAction(HighlightingLevel layer) {
                if (layer == null) {
                    OptionAction.$$$reportNull$$$0(0);
                }
                super(layer.getText(), null, layer.getIcon());
                this.myLayer = layer;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    OptionAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(2);
                }
                return SetEditorSettingsActionGroup.this.myTextSettings.getHighlightingLevel() == this.myLayer;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(3);
                }
                SetEditorSettingsActionGroup.this.myTextSettings.setHighlightingLevel(this.myLayer);
                EditorHighlightingLayerGroup.this.apply(this.myLayer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "layer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorHighlightingLayerGroup$OptionAction";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorHighlightingLayerGroup$OptionAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private class EditorBreadcrumbsPlacementGroup
    extends ActionGroup
    implements EditorSettingAction,
    DumbAware {
        private final AnAction[] myOptions;

        EditorBreadcrumbsPlacementGroup() {
            ActionUtil.copyFrom((AnAction)this, (String)"EditorBreadcrumbsSettings");
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])BreadcrumbsPlacement.values(), option -> new OptionAction((BreadcrumbsPlacement)((Object)option)), (Object[])AnAction.EMPTY_ARRAY);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                EditorBreadcrumbsPlacementGroup.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                EditorBreadcrumbsPlacementGroup.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorBreadcrumbsPlacementGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorBreadcrumbsPlacementGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final BreadcrumbsPlacement myOption;

            OptionAction(BreadcrumbsPlacement option) {
                if (option == null) {
                    OptionAction.$$$reportNull$$$0(0);
                }
                ActionUtil.copyFrom((AnAction)this, (String)option.getActionId());
                this.myOption = option;
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    OptionAction.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(2);
                }
                return SetEditorSettingsActionGroup.this.myTextSettings.getBreadcrumbsPlacement() == this.myOption;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(3);
                }
                SetEditorSettingsActionGroup.this.myTextSettings.setBreadcrumbsPlacement(this.myOption);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorBreadcrumbsPlacementGroup$OptionAction";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorBreadcrumbsPlacementGroup$OptionAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static interface EditorSettingAction {
        public void applyDefaults(@NotNull List<? extends Editor> var1);
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware,
    EditorSettingAction {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(0);
            }
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
            this.getTemplatePresentation().setIcon(null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(2);
            }
            return this.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(3);
            }
            this.setSelected(state);
            for (Editor editor : SetEditorSettingsActionGroup.this.myEditors.get()) {
                this.apply(editor, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors) {
            if (editors == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(4);
            }
            for (Editor editor : editors) {
                this.apply(editor, this.isSelected());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorSettingToggleAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsActionGroup$EditorSettingToggleAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

