/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffChangeUi;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UnifiedDiffModel {
    @NotNull
    private final UnifiedDiffViewer myViewer;
    @Nullable
    private ChangedBlockData myData;
    @NotNull
    private ThreeState myIsContentsEqual;
    @NotNull
    private final List<UnifiedDiffChangeUi> myPresentations;
    @NotNull
    private final List<RangeMarker> myGuardedRangeBlocks;

    public UnifiedDiffModel(@NotNull UnifiedDiffViewer viewer) {
        if (viewer == null) {
            UnifiedDiffModel.$$$reportNull$$$0(0);
        }
        this.myData = null;
        this.myIsContentsEqual = ThreeState.UNSURE;
        this.myPresentations = new ArrayList<UnifiedDiffChangeUi>();
        this.myGuardedRangeBlocks = new ArrayList<RangeMarker>();
        this.myViewer = viewer;
    }

    public boolean isValid() {
        return this.myData != null;
    }

    @NotNull
    public ThreeState isContentsEqual() {
        ThreeState threeState = this.myIsContentsEqual;
        if (threeState == null) {
            UnifiedDiffModel.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    @Nullable
    public ChangedBlockData getData() {
        return this.myData;
    }

    @Nullable
    public List<UnifiedDiffChange> getDiffChanges() {
        ChangedBlockData data = this.myData;
        return data != null ? data.getDiffChanges() : null;
    }

    @Nullable
    public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
        ChangedBlockData data;
        if (side == null) {
            UnifiedDiffModel.$$$reportNull$$$0(2);
        }
        return (data = this.myData) != null ? data.getLineNumberConvertor(side) : null;
    }

    public void setChanges(@NotNull List<UnifiedDiffChange> changes, boolean isContentsEqual, @NotNull List<? extends RangeMarker> guardedBlocks, @NotNull LineNumberConvertor convertor1, @NotNull LineNumberConvertor convertor2, @NotNull List<HighlightRange> ranges) {
        if (changes == null) {
            UnifiedDiffModel.$$$reportNull$$$0(3);
        }
        if (guardedBlocks == null) {
            UnifiedDiffModel.$$$reportNull$$$0(4);
        }
        if (convertor1 == null) {
            UnifiedDiffModel.$$$reportNull$$$0(5);
        }
        if (convertor2 == null) {
            UnifiedDiffModel.$$$reportNull$$$0(6);
        }
        if (ranges == null) {
            UnifiedDiffModel.$$$reportNull$$$0(7);
        }
        assert (this.myPresentations.isEmpty() && this.myGuardedRangeBlocks.isEmpty() && this.myData == null);
        for (UnifiedDiffChange change : changes) {
            UnifiedDiffChangeUi changeUi = this.myViewer.createUi(change);
            changeUi.installHighlighter();
            this.myPresentations.add(changeUi);
        }
        this.myGuardedRangeBlocks.addAll(guardedBlocks);
        this.myData = new ChangedBlockData(changes, convertor1, convertor2, ranges);
        this.myIsContentsEqual = ThreeState.fromBoolean((boolean)isContentsEqual);
    }

    public void clear() {
        for (UnifiedDiffChangeUi changeUi : this.myPresentations) {
            changeUi.destroyHighlighter();
        }
        this.myPresentations.clear();
        DocumentEx document = this.myViewer.getEditor().getDocument();
        for (RangeMarker block : this.myGuardedRangeBlocks) {
            document.removeGuardedBlock(block);
        }
        this.myGuardedRangeBlocks.clear();
        this.myData = null;
        this.myIsContentsEqual = ThreeState.UNSURE;
    }

    public void updateGutterActions() {
        for (UnifiedDiffChangeUi changeUi : this.myPresentations) {
            changeUi.updateGutterActions();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guardedBlocks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "isContentsEqual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumberConvertor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class ChangedBlockData {
        @NotNull
        private final List<UnifiedDiffChange> myDiffChanges;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor1;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor2;
        @NotNull
        private final List<HighlightRange> myRanges;

        ChangedBlockData(@NotNull List<UnifiedDiffChange> diffChanges, @NotNull LineNumberConvertor lineNumberConvertor1, @NotNull LineNumberConvertor lineNumberConvertor2, @NotNull List<HighlightRange> ranges) {
            if (diffChanges == null) {
                ChangedBlockData.$$$reportNull$$$0(0);
            }
            if (lineNumberConvertor1 == null) {
                ChangedBlockData.$$$reportNull$$$0(1);
            }
            if (lineNumberConvertor2 == null) {
                ChangedBlockData.$$$reportNull$$$0(2);
            }
            if (ranges == null) {
                ChangedBlockData.$$$reportNull$$$0(3);
            }
            this.myDiffChanges = Collections.unmodifiableList(diffChanges);
            this.myLineNumberConvertor1 = lineNumberConvertor1;
            this.myLineNumberConvertor2 = lineNumberConvertor2;
            this.myRanges = Collections.unmodifiableList(ranges);
        }

        @NotNull
        public List<UnifiedDiffChange> getDiffChanges() {
            List<UnifiedDiffChange> list = this.myDiffChanges;
            if (list == null) {
                ChangedBlockData.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor(@NotNull Side side) {
            if (side == null) {
                ChangedBlockData.$$$reportNull$$$0(5);
            }
            LineNumberConvertor lineNumberConvertor = (LineNumberConvertor)side.select((Object)this.myLineNumberConvertor1, (Object)this.myLineNumberConvertor2);
            if (lineNumberConvertor == null) {
                ChangedBlockData.$$$reportNull$$$0(6);
            }
            return lineNumberConvertor;
        }

        @NotNull
        public List<HighlightRange> getRanges() {
            List<HighlightRange> list = this.myRanges;
            if (list == null) {
                ChangedBlockData.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffChanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineNumberConvertor1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lineNumberConvertor2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedDiffModel$ChangedBlockData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "side";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedDiffModel$ChangedBlockData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineNumberConvertor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineNumberConvertor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

