/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.vcs.ex.BlockI;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.Range;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u0000 '*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001'B\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bH$J\u0011\u0010\f\u001a\u00028\u0000*\u00028\u0001H$\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bJ\u0015\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0010\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001eJ\u0016\u0010$\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001eJ \u0010%\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "B", "Lcom/intellij/openapi/vcs/ex/BlockI;", "", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "<init>", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;)V", "getBlocks", "", "toRange", "(Lcom/intellij/openapi/vcs/ex/BlockI;)Lcom/intellij/openapi/vcs/ex/Range;", "getRanges", "findRange", "range", "(Lcom/intellij/openapi/vcs/ex/Range;)Lcom/intellij/openapi/vcs/ex/Range;", "findBlock", "(Lcom/intellij/openapi/vcs/ex/Range;)Lcom/intellij/openapi/vcs/ex/BlockI;", "getNextRange", "line", "", "(I)Lcom/intellij/openapi/vcs/ex/Range;", "getPrevRange", "getRangesForLines", "lines", "Ljava/util/BitSet;", "getRangeForLine", "isLineModified", "", "isRangeModified", "startLine", "endLine", "transferLineFromVcs", "approximate", "transferLineToVcs", "transferLine", "fromVcs", "Companion", "intellij.platform.diff.impl"})
@SourceDebugExtension(value={"SMAP\nLineStatusTrackerBlockOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerBlockOperations.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations\n+ 2 DocumentTracker.kt\ncom/intellij/openapi/vcs/ex/DocumentTracker$Lock\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n558#2:148\n558#2:156\n558#2:157\n558#2:158\n558#2:159\n558#2:160\n558#2:161\n558#2:162\n774#3:149\n865#3,2:150\n1563#3:152\n1634#3,3:153\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerBlockOperations.kt\ncom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations\n*L\n13#1:148\n22#1:156\n37#1:157\n49#1:158\n61#1:159\n74#1:160\n93#1:161\n107#1:162\n15#1:149\n15#1:150,2\n15#1:152\n15#1:153,3\n*E\n"})
public abstract class LineStatusTrackerBlockOperations<R extends Range, B extends BlockI> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocumentTracker.Lock LOCK;

    public LineStatusTrackerBlockOperations(@NotNull DocumentTracker.Lock LOCK) {
        Intrinsics.checkNotNullParameter((Object)LOCK, (String)"LOCK");
        this.LOCK = LOCK;
    }

    @Nullable
    protected abstract List<B> getBlocks();

    @NotNull
    protected abstract R toRange(@NotNull B var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final List<R> getRanges() {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BlockI it;
            void $this$filterTo$iv$iv;
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                List<R> list2 = null;
                return list2;
            }
            List<B> blocks = list;
            Iterable $this$filter$iv = blocks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BlockI)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BlockI)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(this.toRange(it));
            }
            List list3 = (List)destination$iv$iv;
            return list3;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public final R findRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        B b = this.findBlock(range);
        return b != null ? (R)this.toRange(b) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final B findBlock(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                B b = null;
                return b;
            }
            List<B> blocks = list;
            for (BlockI block : blocks) {
                if (block.getStart() != range.getLine1() || block.getEnd() != range.getLine2() || block.getVcsStart() != range.getVcsLine1() || block.getVcsEnd() != range.getVcsLine2()) continue;
                BlockI blockI = block;
                return (B)blockI;
            }
            B b = null;
            return b;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getNextRange(int line) {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                R r = null;
                return r;
            }
            List<B> blocks = list;
            for (BlockI block : blocks) {
                if (line >= block.getEnd() || Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getPrevRange(int line) {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                R r = null;
                return r;
            }
            List<B> blocks = list;
            for (BlockI block : CollectionsKt.reversed((Iterable)blocks)) {
                if (line <= block.getStart() || Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<R> getRangesForLines(@NotNull BitSet lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                List<R> list2 = null;
                return list2;
            }
            List<B> blocks = list;
            ArrayList<R> result = new ArrayList<R>();
            for (BlockI block : blocks) {
                if (!Companion.isSelectedByLine(block, lines)) continue;
                result.add(this.toRange(block));
            }
            List list3 = result;
            return list3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getRangeForLine(int line) {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl = false;
            if (this.getBlocks() == null) {
                R r = null;
                return r;
            }
            List<B> blocks = list;
            for (BlockI block : blocks) {
                if (!Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean isLineModified(int line) {
        return this.isRangeModified(line, line + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRangeModified(int startLine, int endLine) {
        boolean bl;
        if (startLine == endLine) {
            return false;
        }
        boolean bl2 = bl = startLine < endLine;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            List<B> list;
            boolean bl3 = false;
            if (this.getBlocks() == null) {
                boolean bl4 = false;
                return bl4;
            }
            List<B> blocks = list;
            for (BlockI block : blocks) {
                if (block.getStart() >= endLine) {
                    boolean bl5 = false;
                    return bl5;
                }
                if (block.getEnd() <= startLine) continue;
                boolean bl6 = true;
                return bl6;
            }
            boolean bl7 = false;
            return bl7;
        }
        finally {
            lock.unlock();
        }
    }

    public final int transferLineFromVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, true);
    }

    public final int transferLineToVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int transferLine(int line, boolean approximate, boolean fromVcs) {
        DocumentTracker.Lock this_$iv = this.LOCK;
        boolean $i$f$read = false;
        Lock lock = this_$iv.getMyLock();
        lock.lock();
        try {
            boolean bl = false;
            List<B> blocks = this.getBlocks();
            if (blocks == null) {
                int n = approximate ? line : -1;
                return n;
            }
            int result = line;
            for (BlockI block : blocks) {
                int endLine2;
                int startLine1 = fromVcs ? block.getVcsStart() : block.getStart();
                int endLine1 = fromVcs ? block.getVcsEnd() : block.getEnd();
                int startLine2 = fromVcs ? block.getStart() : block.getVcsStart();
                int n = endLine2 = fromVcs ? block.getEnd() : block.getVcsEnd();
                boolean bl2 = startLine1 <= line ? line < endLine1 : false;
                if (bl2) {
                    int n2 = approximate ? startLine2 : -1;
                    return n2;
                }
                if (endLine1 > line) {
                    int n3 = result;
                    return n3;
                }
                int length1 = endLine1 - startLine1;
                int length2 = endLine2 - startLine2;
                result += length2 - length1;
            }
            int n = result;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBlockOperations$Companion;", "", "<init>", "()V", "isSelectedByLine", "", "Lcom/intellij/openapi/vcs/ex/BlockI;", "line", "", "lines", "Ljava/util/BitSet;", "intellij.platform.diff.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSelectedByLine(@NotNull BlockI $this$isSelectedByLine, int line) {
            Intrinsics.checkNotNullParameter((Object)$this$isSelectedByLine, (String)"<this>");
            return DiffUtil.isSelectedByLine(line, $this$isSelectedByLine.getStart(), $this$isSelectedByLine.getEnd());
        }

        public final boolean isSelectedByLine(@NotNull BlockI $this$isSelectedByLine, @NotNull BitSet lines) {
            Intrinsics.checkNotNullParameter((Object)$this$isSelectedByLine, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
            return DiffUtil.isSelectedByLine(lines, $this$isSelectedByLine.getStart(), $this$isSelectedByLine.getEnd());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

