/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.idea.ApplicationStartArguments;
import com.intellij.idea.WellKnownCommand;
import com.intellij.idea.WellKnownCommands;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class AppMode {
    public static final String FORCE_PLUGIN_UPDATES = "idea.force.plugin.updates";
    public static final String HELP_OPTION = "--help";
    public static final String VERSION_OPTION = "--version";
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean isLightEdit;
    private static boolean disableNonBundledPlugins;
    private static boolean dontReopenProjects;
    private static boolean isRemoteDevHost;

    public static boolean isDisableNonBundledPlugins() {
        return disableNonBundledPlugins;
    }

    public static boolean isDontReopenProjects() {
        return dontReopenProjects;
    }

    @ApiStatus.Obsolete
    public static boolean isLightEdit() {
        return isLightEdit;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isRemoteDevHost() {
        return isRemoteDevHost;
    }

    public static boolean isRunningFromDevBuild() {
        return Boolean.getBoolean("idea.use.dev.build.server");
    }

    @Deprecated
    public static boolean isDevServer() {
        return AppMode.isRunningFromDevBuild();
    }

    public static void setFlags(@NotNull List<String> args) {
        if (args == null) {
            AppMode.$$$reportNull$$$0(0);
        }
        WellKnownCommand knownCommand = WellKnownCommands.getCommandFor(args);
        isHeadless = Boolean.getBoolean(AWT_HEADLESS) || knownCommand != null && knownCommand.isHeadless();
        boolean bl = isCommandLine = isHeadless || knownCommand != null && knownCommand.isCommandLine();
        if (isHeadless) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        }
        isRemoteDevHost = knownCommand != null && knownCommand.isRemoteDevHost();
        isLightEdit = Boolean.parseBoolean(System.getProperty("idea.force.light.edit.mode")) || knownCommand == null && !isHeadless && AppMode.mayHappenToBeAFile(args);
        for (String arg : args) {
            if (ApplicationStartArguments.DISABLE_NON_BUNDLED_PLUGINS.isSet(args)) {
                disableNonBundledPlugins = true;
                continue;
            }
            if (!ApplicationStartArguments.DONT_REOPEN_PROJECTS.isSet(args)) continue;
            dontReopenProjects = true;
        }
    }

    private static boolean mayHappenToBeAFile(@NotNull List<String> args) {
        if (args == null) {
            AppMode.$$$reportNull$$$0(1);
        }
        for (String arg : args) {
            if (!arg.startsWith("-")) {
                try {
                    Path path = Paths.get(arg, new String[0]);
                    return Files.isRegularFile(path, new LinkOption[0]) || !Files.exists(path, new LinkOption[0]);
                }
                catch (Throwable t) {
                    return false;
                }
            }
            if (!arg.equals("-l") && !arg.equals("--line") && !arg.equals("-c") && !arg.equals("--column")) continue;
            return true;
        }
        return false;
    }

    @TestOnly
    public static void setHeadlessInTestMode(boolean headless) {
        isHeadless = headless;
        isCommandLine = true;
        isLightEdit = false;
    }

    @Nullable
    public static String getDevIdeaProjectDir() {
        return System.getProperty("idea.dev.project.root");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "args";
        objectArray2[1] = "com/intellij/idea/AppMode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mayHappenToBeAFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

