/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.l10n;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.l10n.LocalizationStateService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0007J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0007J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020%0\u001eH\u0002J&\u0010+\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050-0,H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"Lcom/intellij/l10n/LocalizationUtil;", "", "<init>", "()V", "LOCALIZATION_FOLDER_NAME", "", "LOCALIZATION_KEY", "defaultLocale", "Ljava/util/Locale;", "getDefaultLocale", "()Ljava/util/Locale;", "getLocale", "ignoreRestartRequired", "", "getLocaleOrNullForDefault", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "defaultLoader", "locale", "convertToLocalizationFolderUsage", "p", "withRegion", "convertPathToLocaleSuffixUsage", "file", "getResourceAsStream", "Ljava/io/InputStream;", "classLoader", "path", "specialLocale", "getLocalizedPathsWithDefault", "", "getLocalizedPaths", "", "getLocalizationSuffixes", "getFolderLocalizedPaths", "getSuffixLocalizedPaths", "findLanguageBundle", "Lcom/intellij/DynamicBundle$LanguageBundleEP;", "isLocalizationPluginDescriptor", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "isCurrentLocalizationPluginDescriptor", "getAllLanguageBundleExtensions", "getAllAvailableLocales", "Lkotlin/Pair;", "", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1#2:239\n23#3:240\n13#3:252\n1563#4:241\n1634#4,3:242\n1563#4:245\n1634#4,3:246\n1761#4,3:249\n1056#4:253\n*S KotlinDebug\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n*L\n102#1:240\n213#1:252\n173#1:241\n173#1:242,3\n188#1:245\n188#1:246,3\n188#1:249,3\n235#1:253\n*E\n"})
public final class LocalizationUtil {
    @NotNull
    public static final LocalizationUtil INSTANCE = new LocalizationUtil();
    @NotNull
    private static final String LOCALIZATION_FOLDER_NAME = "localization";
    @ApiStatus.Internal
    @NotNull
    public static final String LOCALIZATION_KEY = "i18n.locale";
    @ApiStatus.Internal
    @NotNull
    private static final Locale defaultLocale;

    private LocalizationUtil() {
    }

    @NotNull
    public final Locale getDefaultLocale() {
        return defaultLocale;
    }

    @JvmOverloads
    @NotNull
    public final Locale getLocale(boolean ignoreRestartRequired) {
        LocalizationStateService localizationStateService = LocalizationStateService.getInstance();
        if (localizationStateService == null) {
            return defaultLocale;
        }
        String string = !ignoreRestartRequired && localizationStateService.isRestartRequired() != false ? localizationStateService.getLastSelectedLocale() : localizationStateService.getSelectedLocale();
        Intrinsics.checkNotNull((Object)string);
        String languageTag = string;
        Locale locale = Locale.forLanguageTag(languageTag);
        if (!Intrinsics.areEqual((Object)locale.getLanguage(), (Object)defaultLocale.getLanguage())) {
            Intrinsics.checkNotNull((Object)locale);
            if (this.findLanguageBundle(locale) == null) {
                return defaultLocale;
            }
        }
        Intrinsics.checkNotNull((Object)locale);
        return locale;
    }

    public static /* synthetic */ Locale getLocale$default(LocalizationUtil localizationUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return localizationUtil.getLocale(bl);
    }

    @Nullable
    public final Locale getLocaleOrNullForDefault() {
        Locale locale;
        Locale it = locale = LocalizationUtil.getLocale$default(this, false, 1, null);
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it.getLanguage(), (Object)defaultLocale.getLanguage()) ? locale : null;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader(@Nullable ClassLoader defaultLoader, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (Intrinsics.areEqual((Object)locale, (Object)defaultLocale) || Intrinsics.areEqual((Object)locale, (Object)Locale.ROOT)) {
            return null;
        }
        DynamicBundle.LanguageBundleEP languageBundleEP = this.findLanguageBundle(locale);
        if (languageBundleEP == null) {
            return null;
        }
        DynamicBundle.LanguageBundleEP langBundle = languageBundleEP;
        Object object = langBundle.pluginDescriptor;
        if (object == null || (object = object.getClassLoader()) == null) {
            object = defaultLoader;
        }
        return object;
    }

    public static /* synthetic */ ClassLoader getPluginClassLoader$default(LocalizationUtil localizationUtil, ClassLoader classLoader, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            classLoader = null;
        }
        if ((n & 2) != 0) {
            locale = LocalizationUtil.getLocale$default(localizationUtil, false, 1, null);
        }
        return localizationUtil.getPluginClassLoader(classLoader, locale);
    }

    private final String convertToLocalizationFolderUsage(String p, Locale locale, boolean withRegion) {
        StringBuilder result = new StringBuilder().append(LOCALIZATION_FOLDER_NAME).append('/').append(locale.getLanguage());
        if (withRegion) {
            String string = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCountry(...)");
            if (((CharSequence)string).length() > 0) {
                result.append('/').append(locale.getCountry());
            }
        }
        result.append('/').append(p);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String convertPathToLocaleSuffixUsage(String file, Locale locale, boolean withRegion) {
        if (locale == null) {
            return file;
        }
        String string = PathUtilRt.getFileName((String)file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String pathFileName = string;
        StringBuilder fileName = new StringBuilder().append(PathUtilRt.getParentPath((String)file)).append('/').append(FileUtilRt.getNameWithoutExtension((String)pathFileName));
        String string2 = FileUtilRt.getExtension((String)pathFileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
        String extension = string2;
        String language = locale.getLanguage();
        Intrinsics.checkNotNull((Object)language);
        if (!(((CharSequence)language).length() == 0)) {
            fileName.append('_').append(language);
            String country = locale.getCountry();
            Intrinsics.checkNotNull((Object)country);
            if (((CharSequence)country).length() > 0 && withRegion) {
                fileName.append('_').append(country);
            }
        }
        if (((CharSequence)extension).length() > 0) {
            fileName.append('.').append(extension);
        }
        String string3 = fileName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @ApiStatus.Internal
    @Nullable
    public final InputStream getResourceAsStream(@Nullable ClassLoader classLoader, @NotNull String path, @Nullable Locale specialLocale) {
        Object object;
        block9: {
            block8: {
                Locale locale;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Locale locale2 = specialLocale;
                if (locale2 == null) {
                    locale2 = locale = this.getLocaleOrNullForDefault();
                }
                if (classLoader != null && locale != null) {
                    try {
                        for (String localizedPath : this.getLocalizedPaths(path, locale)) {
                            InputStream inputStream = classLoader.getResourceAsStream(localizedPath);
                            if (inputStream == null) continue;
                            InputStream it = inputStream;
                            boolean bl = false;
                            return it;
                        }
                    }
                    catch (IOException e) {
                        LocalizationUtil $this$thisLogger$iv = this;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(LocalizationUtil.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Cannot find localized resource: " + path, (Throwable)e);
                    }
                }
                if ((object = locale) == null) break block8;
                Locale it = object;
                boolean bl = false;
                ClassLoader classLoader2 = INSTANCE.getPluginClassLoader(null, it);
                InputStream inputStream = classLoader2 != null ? classLoader2.getResourceAsStream(path) : null;
                object = inputStream;
                if (inputStream != null) break block9;
            }
            ClassLoader classLoader3 = classLoader;
            object = classLoader3 != null ? classLoader3.getResourceAsStream(path) : null;
        }
        return object;
    }

    public static /* synthetic */ InputStream getResourceAsStream$default(LocalizationUtil localizationUtil, ClassLoader classLoader, String string, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            locale = null;
        }
        return localizationUtil.getResourceAsStream(classLoader, string, locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getLocalizedPathsWithDefault(@NotNull String path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.toMutableList(this.getLocalizedPaths(path, specialLocale)), (Object)path));
    }

    public static /* synthetic */ List getLocalizedPathsWithDefault$default(LocalizationUtil localizationUtil, String string, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizedPathsWithDefault(string, locale);
    }

    @ApiStatus.Internal
    @NotNull
    public final Collection<String> getLocalizedPaths(@NotNull String path, @Nullable Locale specialLocale) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale2 = specialLocale;
        if (locale2 == null) {
            locale2 = this.getLocaleOrNullForDefault();
        }
        if ((locale = locale2) == null || Intrinsics.areEqual((Object)locale, (Object)Locale.ROOT)) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new String[]{this.convertToLocalizationFolderUsage(path, locale, true), this.convertPathToLocaleSuffixUsage(path, locale, true), this.convertToLocalizationFolderUsage(path, locale, false), this.convertPathToLocaleSuffixUsage(path, locale, false)};
        return SetsKt.linkedSetOf((Object[])objectArray);
    }

    public static /* synthetic */ Collection getLocalizedPaths$default(LocalizationUtil localizationUtil, String string, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizedPaths(string, locale);
    }

    @ApiStatus.Internal
    @NotNull
    public final List<String> getLocalizationSuffixes(@Nullable Locale specialLocale) {
        Locale locale = specialLocale;
        if (locale == null && (locale = this.getLocaleOrNullForDefault()) == null) {
            return CollectionsKt.emptyList();
        }
        Locale locale2 = locale;
        List result = new ArrayList();
        String string = locale2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        if (((CharSequence)string).length() > 0) {
            String string2 = locale2.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
            if (((CharSequence)string2).length() > 0) {
                result.add('_' + locale2.getLanguage() + '_' + locale2.getCountry());
            }
            result.add('_' + locale2.getLanguage());
        }
        return result;
    }

    public static /* synthetic */ List getLocalizationSuffixes$default(LocalizationUtil localizationUtil, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            locale = null;
        }
        return localizationUtil.getLocalizationSuffixes(locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getFolderLocalizedPaths(@NotNull String path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null && (locale = this.getLocaleOrNullForDefault()) == null) {
            return CollectionsKt.emptyList();
        }
        Locale locale2 = locale;
        Object[] objectArray = new String[]{this.convertToLocalizationFolderUsage(path, locale2, true), this.convertToLocalizationFolderUsage(path, locale2, false)};
        return CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ List getFolderLocalizedPaths$default(LocalizationUtil localizationUtil, String string, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getFolderLocalizedPaths(string, locale);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getSuffixLocalizedPaths(@NotNull String path, @Nullable Locale specialLocale) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null) {
            locale = this.getLocaleOrNullForDefault();
        }
        Locale locale2 = locale;
        Object object = new String[]{this.convertPathToLocaleSuffixUsage(path, locale2, true), this.convertPathToLocaleSuffixUsage(path, locale2, false)};
        object = SetsKt.setOf((Object[])object);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtil.toSystemIndependentName((String)it.toString()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getSuffixLocalizedPaths$default(LocalizationUtil localizationUtil, String string, Locale locale, int n, Object object) {
        if ((n & 2) != 0) {
            locale = null;
        }
        return localizationUtil.getSuffixLocalizedPaths(string, locale);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final DynamicBundle.LanguageBundleEP findLanguageBundle(@NotNull Locale locale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Iterable iterable = this.getAllLanguageBundleExtensions();
            for (Object t : iterable) {
                DynamicBundle.LanguageBundleEP it = (DynamicBundle.LanguageBundleEP)t;
                boolean bl = false;
                Locale extensionLocale = Locale.forLanguageTag(it.locale);
                if (!Intrinsics.areEqual((Object)extensionLocale, (Object)locale)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ DynamicBundle.LanguageBundleEP findLanguageBundle$default(LocalizationUtil localizationUtil, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            locale = LocalizationUtil.getLocale$default(localizationUtil, false, 1, null);
        }
        return localizationUtil.findLanguageBundle(locale);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public final boolean isLocalizationPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            Iterable $this$map$iv = this.getAllLanguageBundleExtensions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DynamicBundle.LanguageBundleEP languageBundleEP = (DynamicBundle.LanguageBundleEP)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.pluginDescriptor);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PluginDescriptor it = (PluginDescriptor)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)pluginDescriptor)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @ApiStatus.Internal
    public final boolean isCurrentLocalizationPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        Locale locale;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                locale = this.getLocaleOrNullForDefault();
                if (locale == null) break block3;
                Locale it = locale;
                boolean bl = false;
                DynamicBundle.LanguageBundleEP languageBundleEP = INSTANCE.findLanguageBundle(it);
                Object object = languageBundleEP != null ? languageBundleEP.pluginDescriptor : null;
                locale = object;
                if (object != null) break block4;
            }
            return false;
        }
        Locale currentDescriptor = locale;
        return Intrinsics.areEqual((Object)currentDescriptor, (Object)pluginDescriptor);
    }

    private final List<DynamicBundle.LanguageBundleEP> getAllLanguageBundleExtensions() {
        try {
            block8: {
                block7: {
                    if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                        return CollectionsKt.emptyList();
                    }
                    Application app = ApplicationManager.getApplication();
                    if (app == null) break block7;
                    ExtensionsArea extensionsArea = app.getExtensionArea();
                    ExtensionPointName<DynamicBundle.LanguageBundleEP> extensionPointName = DynamicBundle.LanguageBundleEP.EP_NAME;
                    Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
                    if (extensionsArea.hasExtensionPoint(extensionPointName)) break block8;
                }
                return CollectionsKt.emptyList();
            }
            return DynamicBundle.LanguageBundleEP.EP_NAME.getExtensionList();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LocalizationUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public final Pair<List<Locale>, Map<Locale, String>> getAllAvailableLocales() {
        HashSet<Locale> list = new HashSet<Locale>();
        HashMap map2 = new HashMap();
        Object object = this.getAllLanguageBundleExtensions().iterator();
        while (object.hasNext()) {
            DynamicBundle.LanguageBundleEP bundleEP = object.next();
            Locale locale = Locale.forLanguageTag(bundleEP.locale);
            list.add(locale);
            String displayName = bundleEP.displayName;
            CharSequence charSequence = displayName;
            if (charSequence == null || charSequence.length() == 0) continue;
            ((Map)map2).put(locale, displayName);
        }
        Object $this$getAllAvailableLocales_u24lambda_u240 = object = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getAllAvailableLocales_u24lambda_u240.add(defaultLocale);
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        $this$getAllAvailableLocales_u24lambda_u240.addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(map2){
            final /* synthetic */ HashMap $map$inlined;
            {
                this.$map$inlined = hashMap;
            }

            public final int compare(T a, T b) {
                Locale it = (Locale)a;
                boolean bl = false;
                String string = (String)this.$map$inlined.get(it);
                if (string == null) {
                    string = it.getDisplayLanguage(LocalizationUtil.INSTANCE.getDefaultLocale());
                }
                it = (Locale)b;
                Comparable comparable = (Comparable)((Object)string);
                bl = false;
                String string2 = (String)this.$map$inlined.get(it);
                if (string2 == null) {
                    string2 = it.getDisplayLanguage(LocalizationUtil.INSTANCE.getDefaultLocale());
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        }));
        return TuplesKt.to((Object)CollectionsKt.build((List)object), map2);
    }

    @JvmOverloads
    @NotNull
    public final Locale getLocale() {
        return LocalizationUtil.getLocale$default(this, false, 1, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader(@Nullable ClassLoader defaultLoader) {
        return LocalizationUtil.getPluginClassLoader$default(this, defaultLoader, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader() {
        return LocalizationUtil.getPluginClassLoader$default(this, null, null, 3, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getLocalizedPathsWithDefault(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getLocalizedPathsWithDefault$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getFolderLocalizedPaths(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getFolderLocalizedPaths$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getSuffixLocalizedPaths(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalizationUtil.getSuffixLocalizedPaths$default(this, path, null, 2, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final DynamicBundle.LanguageBundleEP findLanguageBundle() {
        return LocalizationUtil.findLanguageBundle$default(this, null, 1, null);
    }

    static {
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        defaultLocale = locale;
    }
}

