/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/util/FilesModificationTrackerBase;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isFileSupported", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "handleChange", "", "dispose", "intellij.platform.core"})
public abstract class FilesModificationTrackerBase
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    private final Project project;

    public FilesModificationTrackerBase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager.getInstance(this.project).addPsiTreeChangeListener(new PsiTreeAnyChangeAbstractAdapter(){

            @Override
            protected void onChange(PsiFile file) {
                Object object = file;
                if (object == null || (object = object.getVirtualFile()) == null) {
                    return;
                }
                Object virtualFile = object;
                this.handleChange((VirtualFile)((Object)virtualFile));
            }
        }, this);
        MessageBusConnection messageBus = this.project.getMessageBus().connect((Disposable)this);
        Topic<BulkFileListener> topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"VFS_CHANGES");
        messageBus.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            @Override
            public void propertyChanged(VirtualFilePropertyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            @Override
            public void contentsChanged(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            @Override
            public void fileCreated(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            @Override
            public void beforeFileDeletion(VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            @Override
            public void fileMoved(VirtualFileMoveEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }

            @Override
            public void fileCopied(VirtualFileCopyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)virtualFile), (String)"getFile(...)");
                this.handleChange(virtualFile);
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public abstract boolean isFileSupported(@NotNull VirtualFile var1);

    private final void handleChange(VirtualFile virtualFile) {
        if (this.isFileSupported(virtualFile)) {
            this.incModificationCount();
        }
    }

    public void dispose() {
    }
}

