/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadonlyStatusHandlerBase
extends ReadonlyStatusHandler {
    private static final Logger LOG = Logger.getInstance(ReadonlyStatusHandlerBase.class);
    private final Project myProject;

    public ReadonlyStatusHandlerBase(Project project) {
        this.myProject = project;
    }

    private static void checkThreading() {
        ThreadingAssertions.assertEventDispatchThread();
        Application app = ApplicationManager.getApplication();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is((String)"tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    protected static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> originalFiles, @NotNull Collection<? extends VirtualFile> files) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(0);
        }
        if (files == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        assert (!readOnlyFiles.isEmpty() || ContainerUtil.and(originalFiles, file -> file == null || file.isWritable())) : "Original files: " + originalFiles + ", files: " + files;
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles), "", null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @RequiresEdt
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles) {
        OperationStatusImpl status;
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (originalFiles.isEmpty()) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY, "", null);
        }
        ReadonlyStatusHandlerBase.checkThreading();
        HashSet<void> realFiles = new HashSet<void>(originalFiles.size());
        for (VirtualFile virtualFile : originalFiles) {
            void var4_4;
            void var4_8;
            @Nullable VirtualFile virtualFile2 = (VirtualFile)((Object)ObjectUtils.doIfNotNull((Object)((Object)virtualFile), f -> VirtualFileUtil.originalFileOrSelf(f)));
            if (virtualFile2 instanceof VirtualFileWindow) {
                @Nullable VirtualFile virtualFile3 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
            }
            if (var4_8 instanceof BackedVirtualFile) {
                @Nullable VirtualFile virtualFile4 = ((BackedVirtualFile)var4_8).getOriginFile();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        AccessToken ignore = SlowOperations.knownIssue("EA-1051315, IJPL-149483");
        ArrayList arrayList = new ArrayList(realFiles);
        OperationStatusImpl operationStatusImpl = status = this.myProject.isDefault() ? null : (OperationStatusImpl)WritingAccessProvider.EP.computeSafeIfAny((AreaInstance)this.myProject, provider -> {
            Collection<Object> denied = ContainerUtil.filter((Collection)arrayList, virtualFile -> !provider.isPotentiallyWritable((VirtualFile)((Object)((Object)virtualFile))));
            if (denied.isEmpty()) {
                denied = provider.requestWriting(arrayList);
            }
            return denied.isEmpty() ? null : new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(denied), provider.getReadOnlyMessage(), provider.getHyperlinkListener());
        });
        if (status != null) {
            OperationStatusImpl operationStatusImpl2 = status;
            OperationStatusImpl operationStatusImpl3 = operationStatusImpl2;
            if (operationStatusImpl3 == null) {
                ReadonlyStatusHandlerBase.$$$reportNull$$$0(3);
            }
            return operationStatusImpl3;
        }
        ReadonlyStatusHandler.OperationStatus operationStatus = this.ensureFilesWritable(originalFiles, arrayList);
        ReadonlyStatusHandler.OperationStatus operationStatus2 = operationStatus;
        if (operationStatus2 == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(4);
        }
        return operationStatus2;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    protected ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles, Collection<? extends VirtualFile> files) {
        if (originalFiles == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(5);
        }
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerBase.createResultStatus(originalFiles, files);
        if (operationStatus == null) {
            ReadonlyStatusHandlerBase.$$$reportNull$$$0(6);
        }
        return operationStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultStatus";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        private final @NlsContexts.DialogMessage @NotNull String myReadOnlyReason;
        @Nullable
        private final HyperlinkListener myHyperlinkListener;

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NlsContexts.DialogMessage @NotNull String readOnlyReason, @Nullable HyperlinkListener hyperlinkListener) {
            if (readOnlyReason == null) {
                OperationStatusImpl.$$$reportNull$$$0(0);
            }
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
            this.myHyperlinkListener = hyperlinkListener;
        }

        @Override
        public VirtualFile @NotNull [] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(1);
            }
            return this.myReadonlyFiles;
        }

        @Override
        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @Override
        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!Strings.isEmpty((String)this.myReadOnlyReason)) {
                    String string = this.myReadOnlyReason;
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(2);
                    }
                    return string;
                }
                if (this.myReadonlyFiles.length > 1) {
                    StringBuilder buf = new StringBuilder();
                    for (VirtualFile file : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file.getPresentableUrl());
                    }
                    String string = CoreBundle.message("failed.to.make.the.following.files.writable.error.message", buf.toString());
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                String string = CoreBundle.message("failed.to.make.file.writable.error.message", this.myReadonlyFiles[0].getPresentableUrl());
                if (string == null) {
                    OperationStatusImpl.$$$reportNull$$$0(4);
                }
                return string;
            }
            throw new RuntimeException("No readonly files");
        }

        @Override
        @Nullable
        public HyperlinkListener getHyperlinkListener() {
            return this.myHyperlinkListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyReason";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase$OperationStatusImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/ReadonlyStatusHandlerBase$OperationStatusImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFiles";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFilesMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

