/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.coroutines.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0015\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\t\u0010\u0011\u001a\u00020\fH\u0096\u0010J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream;", "Ljava/io/InputStream;", "channel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "<init>", "(Lkotlinx/coroutines/channels/ReceiveChannel;)V", "myBuffer", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "close", "", "read", "", "b", "", "off", "len", "available", "getAvailableBuffer", "Ljava/nio/ByteBuffer;", "Companion", "Content", "intellij.platform.util.coroutines"})
@ApiStatus.Experimental
public final class ChannelInputStream
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReceiveChannel<?> channel;
    @NotNull
    private final LinkedBlockingDeque<Content> myBuffer;

    private ChannelInputStream(ReceiveChannel<?> channel) {
        this.channel = channel;
        this.myBuffer = new LinkedBlockingDeque();
    }

    @Override
    public void close() {
        this.channel.cancel(new CancellationException("ChannelInputStream was closed"));
    }

    @Override
    public int read() {
        ByteBuffer byteBuffer = this.getAvailableBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        ByteBuffer available = byteBuffer;
        return available.get();
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ByteBuffer byteBuffer = this.getAvailableBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        ByteBuffer available = byteBuffer;
        int resultSize = Math.min(len, available.remaining());
        available.get(b, off, resultSize);
        return resultSize;
    }

    @Override
    public int available() {
        int n;
        block5: {
            Content current;
            ChannelInputStream channelInputStream = this;
            while (true) {
                if ((current = channelInputStream.myBuffer.pollFirst()) == null) {
                    n = 0;
                } else {
                    if (!(current instanceof Content.Data)) break;
                    int availableInCurrent = ((Content.Data)current).getBuffer().remaining();
                    if (availableInCurrent <= 0) continue;
                    channelInputStream.myBuffer.putFirst(current);
                    n = availableInCurrent;
                }
                break block5;
            }
            if (Intrinsics.areEqual((Object)current, (Object)Content.End.INSTANCE) || current instanceof Content.Error) {
                channelInputStream.myBuffer.putFirst(current);
                n = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final ByteBuffer getAvailableBuffer() {
        block5: {
            Content current;
            do {
                Content content;
                try {
                    content = this.myBuffer.takeFirst();
                }
                catch (InterruptedException ignored) {
                    return null;
                }
                content = current = content;
                if (content instanceof Content.End) {
                    this.myBuffer.putFirst(current);
                    return null;
                }
                if (content instanceof Content.Error) {
                    this.myBuffer.putFirst(current);
                    throw new IOException(((Content.Error)current).getCause());
                }
                if (!(content instanceof Content.Data)) break block5;
            } while (!((Content.Data)current).getBuffer().hasRemaining());
            this.myBuffer.putFirst(current);
            return ((Content.Data)current).getBuffer();
        }
        throw new NoWhenBranchMatchedException();
    }

    public /* synthetic */ ChannelInputStream(ReceiveChannel channel, DefaultConstructorMarker $constructor_marker) {
        this(channel);
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getMyBuffer$p(ChannelInputStream $this) {
        return $this.myBuffer;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001c\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\tJF\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u000f0\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0014\b\u0004\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\f0\u0014H\u0082H\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Companion;", "", "<init>", "()V", "forArrays", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream;", "parentCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "", "forByteBuffers", "Ljava/nio/ByteBuffer;", "consumeChannel", "", "T", "myBuffer", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "transform", "Lkotlin/Function1;", "(Lkotlinx/coroutines/channels/ReceiveChannel;Ljava/util/concurrent/LinkedBlockingDeque;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.util.coroutines"})
    @SourceDebugExtension(value={"SMAP\nChannelUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelUtil.kt\ncom/intellij/platform/util/coroutines/channel/ChannelInputStream$Companion\n+ 2 Channels.common.kt\nkotlinx/coroutines/channels/ChannelsKt__Channels_commonKt\n*L\n1#1,193:1\n160#2:194\n94#2,3:195\n161#2,2:198\n101#2:200\n97#2,3:201\n*S KotlinDebug\n*F\n+ 1 ChannelUtil.kt\ncom/intellij/platform/util/coroutines/channel/ChannelInputStream$Companion\n*L\n44#1:194\n44#1:195,3\n44#1:198,2\n44#1:200\n44#1:201,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChannelInputStream forArrays(@NotNull CoroutineScope parentCoroutineScope, @NotNull ReceiveChannel<byte[]> channel) {
            Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            ChannelInputStream result = new ChannelInputStream(channel, null);
            BuildersKt.launch$default((CoroutineScope)parentCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(channel, result, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int label;
                final /* synthetic */ ReceiveChannel<byte[]> $channel;
                final /* synthetic */ ChannelInputStream $result;
                {
                    this.$channel = $channel;
                    this.$result = $result;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object $result) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return result;
        }

        @NotNull
        public final ChannelInputStream forByteBuffers(@NotNull CoroutineScope parentCoroutineScope, @NotNull ReceiveChannel<? extends ByteBuffer> channel) {
            Intrinsics.checkNotNullParameter((Object)parentCoroutineScope, (String)"parentCoroutineScope");
            Intrinsics.checkNotNullParameter(channel, (String)"channel");
            ChannelInputStream result = new ChannelInputStream(channel, null);
            BuildersKt.launch$default((CoroutineScope)parentCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(channel, result, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int label;
                final /* synthetic */ ReceiveChannel<ByteBuffer> $channel;
                final /* synthetic */ ChannelInputStream $result;
                {
                    this.$channel = $channel;
                    this.$result = $result;
                    super(2, $completion);
                }

                /*
                 * Exception decompiling
                 */
                public final Object invokeSuspend(Object $result) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final <T> Object consumeChannel(ReceiveChannel<? extends T> channel, LinkedBlockingDeque<Content> myBuffer, Function1<? super T, ? extends ByteBuffer> transform, Continuation<? super Unit> $completion) {
            boolean $i$f$consumeChannel = false;
            try {
                void $this$consume$iv$iv;
                void $this$consumeEach$iv;
                ReceiveChannel<? extends T> receiveChannel = channel;
                boolean $i$f$consumeEach = false;
                void var8_11 = $this$consumeEach$iv;
                boolean $i$f$consume = false;
                Throwable cause$iv$iv = null;
                try {
                    ReceiveChannel $this$consumeEach_u24lambda_u240$iv = (ReceiveChannel)$this$consume$iv$iv;
                    boolean bl = false;
                    ChannelIterator channelIterator = $this$consumeEach_u24lambda_u240$iv.iterator();
                    while (true) {
                        Object e$iv;
                        InlineMarker.mark((int)3);
                        InlineMarker.mark((int)0);
                        Object object = channelIterator.hasNext(null);
                        InlineMarker.mark((int)1);
                        if (!((Boolean)object).booleanValue()) break;
                        Object obj = e$iv = channelIterator.next();
                        boolean bl2 = false;
                        ByteBuffer bytes = (ByteBuffer)transform.invoke(obj);
                        if (bytes.hasRemaining()) {
                            myBuffer.offerLast(new Content.Data(bytes));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable e$iv$iv) {
                    cause$iv$iv = e$iv$iv;
                    throw e$iv$iv;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    ChannelsKt.cancelConsumed((ReceiveChannel)$this$consume$iv$iv, (Throwable)cause$iv$iv);
                    InlineMarker.finallyEnd((int)1);
                }
                boolean bl = myBuffer.offerLast(Content.End.INSTANCE);
            }
            catch (Throwable e) {
                boolean bl = e instanceof CancellationException ? myBuffer.offerLast(Content.End.INSTANCE) : myBuffer.offerLast(new Content.Error(e));
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "", "<init>", "()V", "Data", "Error", "End", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$Data;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$End;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$Error;", "intellij.platform.util.coroutines"})
    private static abstract class Content {
        private Content() {
        }

        public /* synthetic */ Content(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$Data;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "getBuffer", "()Ljava/nio/ByteBuffer;", "intellij.platform.util.coroutines"})
        public static final class Data
        extends Content {
            @NotNull
            private final ByteBuffer buffer;

            public Data(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                super(null);
                this.buffer = buffer;
            }

            @NotNull
            public final ByteBuffer getBuffer() {
                return this.buffer;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$End;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "<init>", "()V", "intellij.platform.util.coroutines"})
        public static final class End
        extends Content {
            @NotNull
            public static final End INSTANCE = new End();

            private End() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content$Error;", "Lcom/intellij/platform/util/coroutines/channel/ChannelInputStream$Content;", "cause", "", "<init>", "(Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "intellij.platform.util.coroutines"})
        public static final class Error
        extends Content {
            @NotNull
            private final Throwable cause;

            public Error(@NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                super(null);
                this.cause = cause;
            }

            @NotNull
            public final Throwable getCause() {
                return this.cause;
            }
        }
    }
}

