/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.coroutines.sync;

import com.intellij.platform.util.coroutines.sync.DropLatestSemaphore;
import com.intellij.platform.util.coroutines.sync.DropOldestSemaphore;
import com.intellij.platform.util.coroutines.sync.DropOldestSemaphoreBase;
import com.intellij.platform.util.coroutines.sync.DropOldestSingleSemaphore;
import com.intellij.platform.util.coroutines.sync.OverflowSemaphore;
import com.intellij.platform.util.coroutines.sync.SuspendSemaphore;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"OverflowSemaphore", "Lcom/intellij/platform/util/coroutines/sync/OverflowSemaphore;", "permits", "", "overflow", "Lkotlinx/coroutines/channels/BufferOverflow;", "intellij.platform.util.coroutines"})
public final class OverflowSemaphoreKt {
    @ApiStatus.Experimental
    @NotNull
    public static final OverflowSemaphore OverflowSemaphore(int permits, @NotNull BufferOverflow overflow) {
        OverflowSemaphore overflowSemaphore;
        Intrinsics.checkNotNullParameter((Object)overflow, (String)"overflow");
        if (!(permits > 0)) {
            boolean bl = false;
            String string = "Permits cannot be less than 1: " + permits;
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[overflow.ordinal()]) {
            case 1: {
                overflowSemaphore = new SuspendSemaphore(permits);
                break;
            }
            case 2: {
                overflowSemaphore = permits == 1 ? (DropOldestSemaphoreBase)new DropOldestSingleSemaphore() : (DropOldestSemaphoreBase)new DropOldestSemaphore(permits);
                break;
            }
            case 3: {
                overflowSemaphore = new DropLatestSemaphore(permits);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return overflowSemaphore;
    }

    public static /* synthetic */ OverflowSemaphore OverflowSemaphore$default(int n, BufferOverflow bufferOverflow, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            bufferOverflow = BufferOverflow.SUSPEND;
        }
        return OverflowSemaphoreKt.OverflowSemaphore(n, bufferOverflow);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BufferOverflow.values().length];
            try {
                nArray[BufferOverflow.SUSPEND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferOverflow.DROP_OLDEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BufferOverflow.DROP_LATEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

