/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.Field;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubElementTypeHolderEP {
    private static final Logger LOG = Logger.getInstance(StubElementTypeHolderEP.class);
    public static final ExtensionPointName<StubElementTypeHolderEP> EP_NAME = new ExtensionPointName("com.intellij.stubElementTypeHolder");
    @Attribute(value="class")
    @RequiredElement
    public String holderClass;
    @Attribute(value="externalIdPrefix")
    @Nullable
    public String externalIdPrefix;

    int initializeOptimized(@NotNull PluginDescriptor pluginDescriptor, @NotNull List<? super StubFieldAccessor> result) {
        if (pluginDescriptor == null) {
            StubElementTypeHolderEP.$$$reportNull$$$0(0);
        }
        if (result == null) {
            StubElementTypeHolderEP.$$$reportNull$$$0(1);
        }
        int resultSizeBefore = result.size();
        try {
            Class aClass = ApplicationManager.getApplication().loadClass(this.holderClass, pluginDescriptor);
            if (this.externalIdPrefix == null) {
                Class<?> initializedClass = Class.forName(aClass.getName(), true, aClass.getClassLoader());
                assert (initializedClass == aClass);
            } else {
                assert (aClass.isInterface());
                for (Field field : aClass.getDeclaredFields()) {
                    if (field.isSynthetic()) continue;
                    result.add(new StubFieldAccessor(this.externalIdPrefix + field.getName(), field));
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (result.size() > resultSizeBefore) {
                result.subList(resultSizeBefore, result.size()).clear();
            }
            LOG.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
        }
        catch (PluginException e) {
            if (result.size() > resultSizeBefore) {
                result.subList(resultSizeBefore, result.size()).clear();
            }
            LOG.error((Throwable)e);
        }
        return result.size() - resultSizeBefore;
    }

    public String toString() {
        return this.holderClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pluginDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/stubs/StubElementTypeHolderEP";
        objectArray[2] = "initializeOptimized";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

