/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithAssignedFileType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightVirtualFileBase
extends VirtualFile
implements VirtualFileWithAssignedFileType {
    @Nullable
    private FileType myFileType;
    @NlsSafe
    @NotNull
    private String myName;
    private long myModStamp;
    private boolean myIsWritable;
    private boolean myValid;
    private VirtualFile myOriginalFile;
    private static final MyVirtualFileSystem ourFileSystem = new MyVirtualFileSystem();
    @NotNull
    static final Object DEFAULT_CREATION_TRACE = ObjectUtils.sentinel((String)"default creation trace");

    public LightVirtualFileBase(@NlsSafe @NotNull String name, @Nullable FileType fileType, long modificationStamp) {
        if (name == null) {
            LightVirtualFileBase.$$$reportNull$$$0(0);
        }
        this(name, fileType, modificationStamp, DEFAULT_CREATION_TRACE);
    }

    /*
     * WARNING - void declaration
     */
    public LightVirtualFileBase(@NlsSafe @NotNull String name, @Nullable FileType fileType, long modificationStamp, @Nullable Object object) {
        void creationTrace;
        if (name == null) {
            LightVirtualFileBase.$$$reportNull$$$0(1);
        }
        this.myIsWritable = true;
        this.myValid = true;
        this.myName = name;
        this.myFileType = fileType;
        this.myModStamp = modificationStamp;
        this.registerCreationTrace(creationTrace);
    }

    public void setFileType(FileType fileType) {
        this.myFileType = fileType;
    }

    public VirtualFile getOriginalFile() {
        return this.myOriginalFile;
    }

    public void setOriginalFile(VirtualFile originalFile) {
        this.myOriginalFile = originalFile;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        MyVirtualFileSystem myVirtualFileSystem = ourFileSystem;
        if (myVirtualFileSystem == null) {
            LightVirtualFileBase.$$$reportNull$$$0(2);
        }
        return myVirtualFileSystem;
    }

    @Override
    @Nullable
    public FileType getAssignedFileType() {
        return this.myFileType;
    }

    @Override
    @NotNull
    public String getPath() {
        VirtualFile parent = this.getParent();
        String string = (parent == null ? "" : parent.getPath()) + "/" + this.getName();
        if (string == null) {
            LightVirtualFileBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LightVirtualFileBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return this.myIsWritable;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Override
    public VirtualFile getParent() {
        return null;
    }

    @Override
    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public long getModificationStamp() {
        return this.myModStamp;
    }

    protected void setModificationStamp(long stamp) {
        this.myModStamp = stamp;
    }

    @Override
    public long getTimeStamp() {
        return 0L;
    }

    @Override
    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            e.printStackTrace();
            assert (false);
            return 0L;
        }
    }

    @Override
    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @Override
    public void setWritable(boolean writable) {
        this.myIsWritable = writable;
    }

    @Override
    public void rename(Object requestor, @NotNull String newName) throws IOException {
        if (newName == null) {
            LightVirtualFileBase.$$$reportNull$$$0(5);
        }
        this.assertWritable();
        this.myName = newName;
    }

    void assertWritable() {
        if (!this.isWritable()) {
            throw new IncorrectOperationException("File is not writable: " + this);
        }
    }

    @Override
    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            LightVirtualFileBase.$$$reportNull$$$0(6);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildDirectory(requestor, name);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) throws IOException {
        if (name == null) {
            LightVirtualFileBase.$$$reportNull$$$0(8);
        }
        this.assertWritable();
        VirtualFile virtualFile = super.createChildData(requestor, name);
        if (virtualFile == null) {
            LightVirtualFileBase.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    @Override
    public void delete(Object requestor) throws IOException {
        this.assertWritable();
        super.delete(requestor);
    }

    @Override
    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            LightVirtualFileBase.$$$reportNull$$$0(10);
        }
        this.assertWritable();
        super.move(requestor, newParent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long l) throws IOException {
        void newTimeStamp;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(11);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, (long)newTimeStamp);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content == null) {
            LightVirtualFileBase.$$$reportNull$$$0(12);
        }
        this.assertWritable();
        super.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
    }

    private void registerCreationTrace(@Nullable Object creationTrace) {
        if (creationTrace == DEFAULT_CREATION_TRACE) {
            creationTrace = LightVirtualFileBase.getDefaultCreationTrace();
        }
        if (creationTrace != null) {
            PsiInvalidElementAccessException.setCreationTrace(this, creationTrace);
        }
    }

    @Nullable
    private static Object getDefaultCreationTrace() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return null;
        }
        return new Throwable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightVirtualFileBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyVirtualFileSystem
    extends DeprecatedVirtualFileSystem
    implements NonPhysicalFileSystem {
        @NonNls
        private static final String PROTOCOL = "mock";

        private MyVirtualFileSystem() {
            this.startEventPropagation();
        }

        @Override
        @NotNull
        public String getProtocol() {
            return PROTOCOL;
        }

        @Override
        @Nullable
        public VirtualFile findFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void refresh(boolean asynchronous) {
        }

        @Override
        @Nullable
        public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
            if (path == null) {
                MyVirtualFileSystem.$$$reportNull$$$0(1);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "com/intellij/testFramework/LightVirtualFileBase$MyVirtualFileSystem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFileByPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshAndFindFileByPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

