/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ForcefulReparseModificationTracker;
import com.intellij.util.concurrency.TransferredWriteActionService;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class FileContentUtilCore {
    public static final String FORCE_RELOAD_REQUESTOR = "FileContentUtilCore.saveOrReload";

    public static void reparseFiles(VirtualFile ... files) {
        if (files == null) {
            FileContentUtilCore.$$$reportNull$$$0(0);
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files));
    }

    public static void reparseFiles(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            FileContentUtilCore.$$$reportNull$$$0(1);
        }
        Application application = ApplicationManager.getApplication();
        application.runWriteAction(() -> {
            HashSet<VFilePropertyChangeEvent> events = new HashSet<VFilePropertyChangeEvent>();
            for (VirtualFile file : files) {
                if (file == null || file.isDirectory() || !file.isValid()) continue;
                events.add(new VFilePropertyChangeEvent(FORCE_RELOAD_REQUESTOR, file, "name", file.getName(), file.getName()));
            }
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            BulkFileListenerBackgroundable publisherBackgroundable = (BulkFileListenerBackgroundable)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES_BG);
            List eventList = Collections.unmodifiableList(new ArrayList(events));
            if (EDT.isCurrentThreadEdt()) {
                publisher.before(eventList);
            } else {
                ((TransferredWriteActionService)application.getService(TransferredWriteActionService.class)).runOnEdtWithTransferredWriteActionAndWait(() -> publisher.before(eventList));
            }
            publisherBackgroundable.before(eventList);
            if (EDT.isCurrentThreadEdt()) {
                publisher.after(eventList);
            } else {
                ((TransferredWriteActionService)application.getService(TransferredWriteActionService.class)).runOnEdtWithTransferredWriteActionAndWait(() -> publisher.after(eventList));
            }
            publisherBackgroundable.after(eventList);
            ForcefulReparseModificationTracker.increment();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
    }
}

