/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileIconKey {
    public final VirtualFile file;
    public final Project project;
    @Iconable.IconFlags
    public final int flags;
    @Nullable
    private final Language initialLanguage;
    private final long stamp;

    public FileIconKey(@NotNull VirtualFile file, @Nullable Project project, @Iconable.IconFlags int flags) {
        if (file == null) {
            FileIconKey.$$$reportNull$$$0(0);
        }
        this.file = file;
        this.project = project;
        this.flags = flags;
        this.initialLanguage = this.file instanceof LightVirtualFile ? ((LightVirtualFile)this.file).getLanguage() : null;
        this.stamp = project == null ? 0L : PsiManager.getInstance(project).getModificationTracker().getModificationCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileIconKey)) {
            return false;
        }
        FileIconKey that = (FileIconKey)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.stamp != that.stamp) {
            return false;
        }
        if (!((Object)((Object)this.file)).equals((Object)that.file)) {
            return false;
        }
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        return Objects.equals((Object)this.initialLanguage, (Object)that.initialLanguage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.project, this.flags, this.stamp});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/FileIconKey", "<init>"));
    }
}

