/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ThrowableRunnable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\u001a+\u0010\u0000\u001a\u00020\u00012\u001e\u0010\u0002\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00010\u00040\u0003\"\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u001a+\u0010\u0000\u001a\u00020\u00012\u001e\u0010\u0006\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0003\"\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\t\u001a'\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\b2\b\u0010\f\u001a\u0004\u0018\u0001H\u000b2\u0006\u0010\r\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"runSuppressing", "", "blocks", "", "Lkotlin/Function0;", "([Lkotlin/jvm/functions/Function0;)V", "runnables", "Lcom/intellij/util/ThrowableRunnable;", "", "([Lcom/intellij/util/ThrowableRunnable;)V", "addSuppressed", "T", "first", "next", "(Ljava/lang/Throwable;Ljava/lang/Throwable;)Ljava/lang/Throwable;", "intellij.platform.core"})
@JvmName(name="Suppressions")
public final class Suppressions {
    public static final void runSuppressing(Function0<Unit> ... blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Throwable first = null;
        for (Function0<Unit> block : blocks) {
            try {
                block.invoke();
            }
            catch (Throwable t) {
                first = Suppressions.addSuppressed(first, t);
            }
        }
        if (first != null) {
            throw first;
        }
    }

    public static final void runSuppressing(ThrowableRunnable<Throwable> ... runnables) {
        Intrinsics.checkNotNullParameter(runnables, (String)"runnables");
        Throwable first = null;
        for (ThrowableRunnable<Throwable> runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                first = Suppressions.addSuppressed(first, t);
            }
        }
        if (first != null) {
            throw first;
        }
    }

    @NotNull
    public static final <T extends Throwable> T addSuppressed(@Nullable T first, @NotNull T next) {
        Intrinsics.checkNotNullParameter(next, (String)"next");
        if (first != null) {
            ExceptionsKt.addSuppressed(first, next);
            return first;
        }
        return next;
    }
}

