/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemTelemetryUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.workspaceModel.ide.ProjectRootEntityKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DetachExternalProjectAction
extends ExternalSystemNodeAction<ProjectData> {
    public DetachExternalProjectAction() {
        super(ProjectData.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.detach.external.project.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.detach.external.project.description", (Object[])new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.General.Remove);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        if (((Object)((Object)this)).getClass() != DetachExternalProjectAction.class) {
            return;
        }
        ProjectSystemId systemId = this.getSystemId(e);
        String systemIdName = systemId != null ? systemId.getReadableName() : "External";
        Presentation presentation = e.getPresentation();
        presentation.setText(ExternalSystemBundle.messagePointer((String)"action.detach.external.project.text", (Object[])new Object[]{systemIdName}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(1);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        return e.getData(ExternalSystemDataKeys.SELECTED_PROJECT_NODE) != null;
    }

    @Override
    public void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ProjectData projectData, @NotNull AnActionEvent e) {
        if (project == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(2);
        }
        if (projectSystemId == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(3);
        }
        if (projectData == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(5);
        }
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.detach.external.project.text", (Object[])new Object[]{projectSystemId.getReadableName()}));
        ProjectNode projectNode = (ProjectNode)e.getData(ExternalSystemDataKeys.SELECTED_PROJECT_NODE);
        assert (projectNode != null);
        DetachExternalProjectAction.detachProject(project, projectSystemId, projectData, projectNode);
    }

    public static void detachProject(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ProjectData projectData, @Nullable ProjectNode projectNode) {
        if (project == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(6);
        }
        if (projectSystemId == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(7);
        }
        if (projectData == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(8);
        }
        String externalProjectPath = projectData.getLinkedExternalProjectPath();
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove project from local settings", __ -> {
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectSystemId);
            localSettings.forgetExternalProjects(Collections.singleton(externalProjectPath));
        });
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove project from system settings", __ -> {
            AbstractExternalSystemSettings settings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId);
            settings.unlinkExternalProject(externalProjectPath);
        });
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove project from data storage", __ -> {
            ExternalProjectsManagerImpl externalProjectsManager = ExternalProjectsManagerImpl.getInstance(project);
            externalProjectsManager.forgetExternalProjectData(projectSystemId, externalProjectPath);
        });
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove project from tool window", __ -> {
            ExternalSystemNode group;
            if (projectNode != null && (group = projectNode.getGroup()) != null) {
                group.remove(projectNode);
            }
        });
        ExternalSystemTelemetryUtil.runWithSpan(projectSystemId, "Remove project from workspace model", __ -> {
            List<Module> orphanModules = DetachExternalProjectAction.collectExternalSystemModules(project, projectSystemId, externalProjectPath);
            if (!orphanModules.isEmpty()) {
                ProjectDataManagerImpl projectDataManager = ProjectDataManagerImpl.getInstance();
                projectDataManager.removeData(ProjectKeys.MODULE, orphanModules, Collections.emptyList(), projectData, project, false);
            }
            VirtualFileUrlManager vfuManager = WorkspaceModel.getInstance((Project)project).getVirtualFileUrlManager();
            VirtualFileUrl externalProjectVfu = VirtualFileUrlImplKt.toVirtualFileUrl((Path)Path.of(externalProjectPath, new String[0]), (VirtualFileUrlManager)vfuManager);
            ProjectRootEntityKt.unregisterProjectRootBlocking((Project)project, (VirtualFileUrl)externalProjectVfu);
        });
    }

    @NotNull
    private static List<Module> collectExternalSystemModules(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath) {
        if (project == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(9);
        }
        if (externalSystemId == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(10);
        }
        if (externalProjectPath == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(11);
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String path;
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)externalSystemId, (Module)module) || !externalProjectPath.equals(path = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module))) continue;
            result.add(module);
        }
        ArrayList<Module> arrayList = result;
        if (arrayList == null) {
            DetachExternalProjectAction.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/DetachExternalProjectAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExternalSystemModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detachProject";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectExternalSystemModules";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

