/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.trusted.ExternalSystemTrustedProjectDialog;
import com.intellij.openapi.externalSystem.ui.ExternalSystemIconProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0003J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0003J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectRefreshAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getNotificationText", "", "systemIds", "", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getNotificationDescription", "getNotificationIcon", "Ljavax/swing/Icon;", "Manager", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ProjectRefreshAction
extends DumbAwareAction {
    public ProjectRefreshAction() {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.getTemplatePresentation().setIcon(AllIcons.Actions.BuildLoadChanges);
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.text.empty", (Object[])new Object[0]));
        Object[] objectArray = new Object[]{productName};
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.description.empty", (Object[])objectArray));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Manager.INSTANCE.refreshProject(project2);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ExternalSystemProjectNotificationAware notificationAware = ExternalSystemProjectNotificationAware.Companion.getInstance(project);
        Set systemIds = notificationAware.getSystemIds();
        if (!((Collection)systemIds).isEmpty()) {
            e.getPresentation().setText(this.getNotificationText(systemIds));
            e.getPresentation().setDescription(this.getNotificationDescription(systemIds));
            e.getPresentation().setIcon(this.getNotificationIcon(systemIds));
        }
        e.getPresentation().setEnabled(notificationAware.isNotificationVisible());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @NlsActions.ActionText
    private final String getNotificationText(Set<ProjectSystemId> systemIds) {
        String string = ExternalSystemUtil.naturalJoinSystemIds((Collection<ProjectSystemId>)systemIds);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"naturalJoinSystemIds(...)");
        String systemsPresentation = string;
        Object[] objectArray = new Object[]{systemsPresentation};
        String string2 = ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NlsActions.ActionDescription
    private final String getNotificationDescription(Set<ProjectSystemId> systemIds) {
        String string = ExternalSystemUtil.naturalJoinSystemIds((Collection<ProjectSystemId>)systemIds);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"naturalJoinSystemIds(...)");
        String systemsPresentation = string;
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        Object[] objectArray = new Object[]{systemsPresentation, productName};
        String string2 = ExternalSystemBundle.message((String)"external.system.reload.notification.action.reload.description", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final Icon getNotificationIcon(Set<ProjectSystemId> systemIds) {
        ProjectSystemId projectSystemId = (ProjectSystemId)CollectionsKt.singleOrNull((Iterable)systemIds);
        if (projectSystemId == null) {
            Icon icon = AllIcons.Actions.BuildLoadChanges;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BuildLoadChanges");
            return icon;
        }
        ProjectSystemId systemId = projectSystemId;
        ExternalSystemIconProvider iconProvider = ExternalSystemIconProvider.Companion.getExtension(systemId);
        return iconProvider.getReloadIcon();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectRefreshAction$Manager;", "", "<init>", "()V", "refreshProject", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        public final void refreshProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ExternalSystemProjectNotificationAware projectNotificationAware = ExternalSystemProjectNotificationAware.Companion.getInstance(project);
            Set systemIds = projectNotificationAware.getSystemIds();
            ExternalSystemTrustedProjectDialog.confirmLoadingUntrustedProject(project, systemIds);
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            projectTracker.scheduleProjectRefresh();
        }
    }
}

