/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.autoimport.AutoImportProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesModificationContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker;
import com.intellij.openapi.externalSystem.autoimport.ProjectSettingsTracker$State$;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFileChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.NewFilesListener;
import com.intellij.openapi.externalSystem.autoimport.settings.AsyncSupplier;
import com.intellij.openapi.externalSystem.autoimport.settings.BackgroundAsyncSupplier;
import com.intellij.openapi.externalSystem.service.ui.completion.cache.AsyncLocalCache;
import com.intellij.openapi.externalSystem.util.CrcUtils;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTraceUtil;
import com.intellij.openapi.observable.operation.core.OperationUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.LongSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 O2\u00020\u0001:\tGHIJKLMNOB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020&J,\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u001a2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010,\u001a\u00020\u0012*\u00020\u00122\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020.J\u0006\u00102\u001a\u000200J2\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\"2\u0018\u00106\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001d\u0012\u0004\u0012\u00020007H\u0002J)\u00108\u001a\u0002002\u0006\u0010(\u001a\u00020\u001a2\u0017\u00109\u001a\u0013\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020007\u00a2\u0006\u0002\b;H\u0002J\u0018\u00108\u001a\u0002002\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020:H\u0002JD\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020?2\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020A\u0018\u0001072\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020A\u0018\u0001072\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J\u001c\u0010C\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002000EJ\u001c\u0010F\u001a\u0002002\u0006\u0010\n\u001a\u00020\u000b2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002000ER\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTracker", "Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autoimport/AutoImportProjectTracker;Ljava/util/concurrent/Executor;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;Lcom/intellij/openapi/Disposable;)V", "projectStatus", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus;", "settingsFilesStatus", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus;", "kotlin.jvm.PlatformType", "applyChangesOperation", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "settingsAsyncSupplier", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesAsyncSupplier;", "calculateSettingsFilesCRC", "", "", "", "settingsFiles", "", "calculateCrc", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUpToDate", "", "getModificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "getSettingsContext", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "updateSettingsFilesStatus", "operationName", "newCRC", "reloadStatus", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;", "adjustCrc", "getState", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "loadState", "", "state", "refreshChanges", "submitSettingsFilesCollection", "isRefreshVfs", "isInvalidateCache", "callback", "Lkotlin/Function1;", "submitSettingsFilesStatusUpdate", "configureContext", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatusUpdateContext;", "Lkotlin/ExtensionFunctionType;", "context", "updateProjectStatus", "operationStamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "syncEvent", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "changeEvent", "beforeApplyChanges", "listener", "Lkotlin/Function0;", "afterApplyChanges", "State", "SettingsFilesStatusUpdateContext", "SettingsFilesStatus", "SettingsFilesReloadContext", "SettingsFilesModificationContext", "ProjectListener", "ProjectSettingsListener", "SettingsFilesAsyncSupplier", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectSettingsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1617#2,9:388\n1869#2:397\n1870#2:399\n1626#2:400\n1617#2,9:401\n1869#2:410\n1870#2:412\n1626#2:413\n1617#2,9:414\n1869#2:423\n1870#2:425\n1626#2:426\n1#3:398\n1#3:411\n1#3:424\n*S KotlinDebug\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker\n*L\n60#1:388,9\n60#1:397\n60#1:399\n60#1:400\n61#1:401,9\n61#1:410\n61#1:412\n61#1:413\n174#1:414,9\n174#1:423\n174#1:425\n174#1:426\n60#1:398\n61#1:411\n174#1:424\n*E\n"})
public final class ProjectSettingsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AutoImportProjectTracker projectTracker;
    @NotNull
    private final Executor backgroundExecutor;
    @NotNull
    private final ExternalSystemProjectAware projectAware;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final ProjectStatus projectStatus;
    @NotNull
    private final AtomicReference<SettingsFilesStatus> settingsFilesStatus;
    @NotNull
    private final AtomicOperationTrace applyChangesOperation;
    @NotNull
    private final SettingsFilesAsyncSupplier settingsAsyncSupplier;
    @NotNull
    private static final Logger LOG;

    public ProjectSettingsTracker(@NotNull Project project, @NotNull AutoImportProjectTracker projectTracker, @NotNull Executor backgroundExecutor, @NotNull ExternalSystemProjectAware projectAware, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTracker, (String)"projectTracker");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.projectTracker = projectTracker;
        this.backgroundExecutor = backgroundExecutor;
        this.projectAware = projectAware;
        this.parentDisposable = parentDisposable;
        this.projectStatus = new ProjectStatus("Settings " + this.projectAware.getProjectId());
        this.settingsFilesStatus = new AtomicReference<SettingsFilesStatus>(new SettingsFilesStatus(null, 1, null));
        this.applyChangesOperation = new AtomicOperationTrace("Apply changes operation");
        this.settingsAsyncSupplier = new SettingsFilesAsyncSupplier();
        this.projectAware.subscribe((ExternalSystemProjectListener)new ProjectListener(), this.parentDisposable);
        NewFilesListener.Companion.whenNewFilesCreated((Function0<Unit>)((Function0)new Function0<Unit>((Object)this.settingsAsyncSupplier){

            public final void invoke() {
                ((SettingsFilesAsyncSupplier)this.receiver).invalidate();
            }
        }), this.parentDisposable);
        AsyncFileChangesListener.Companion.subscribeOnDocumentsAndVirtualFilesChanges(this.settingsAsyncSupplier, new ProjectSettingsListener(), this.parentDisposable);
    }

    private final Map<String, Long> calculateSettingsFilesCRC(Set<String> settingsFiles) {
        String it;
        boolean bl;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        Iterable $this$mapNotNull$iv = settingsFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it = (String)element$iv$iv;
            boolean bl2 = false;
            if (localFileSystem2.findFileByPath(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl = false;
            it = (VirtualFile)element$iv$iv;
            boolean bl4 = false;
            long crc = this.calculateCrc((VirtualFile)it);
            if ((crc != 0L ? TuplesKt.to((Object)it.getPath(), (Object)crc) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final long calculateCrc(VirtualFile file) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document = fileDocumentManager2.getCachedDocument(file);
        if (document != null) {
            return CrcUtils.calculateCrc(document, this.project, this.projectAware.getProjectId().getSystemId(), file);
        }
        return CrcUtils.calculateCrc(file, this.project, this.projectAware.getProjectId().getSystemId());
    }

    public final boolean isUpToDate() {
        return this.projectStatus.isUpToDate();
    }

    @NotNull
    public final ExternalSystemModificationType getModificationType() {
        return this.projectStatus.getModificationType();
    }

    @NotNull
    public final ExternalSystemSettingsFilesReloadContext getSettingsContext() {
        SettingsFilesStatus status = this.settingsFilesStatus.get();
        return new SettingsFilesReloadContext(status.getUpdated(), status.getCreated(), status.getDeleted());
    }

    private final SettingsFilesStatus updateSettingsFilesStatus(String operationName, Map<String, Long> newCRC, ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus) {
        SettingsFilesStatus settingsFilesStatus = this.settingsFilesStatus.updateAndGet(arg_0 -> ProjectSettingsTracker.updateSettingsFilesStatus$lambda$0(this, newCRC, operationName, reloadStatus, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)settingsFilesStatus, (String)"updateAndGet(...)");
        return settingsFilesStatus;
    }

    private final SettingsFilesStatus adjustCrc(SettingsFilesStatus $this$adjustCrc, String operationName, ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus) {
        SettingsFilesModificationContext context;
        ExternalSystemModificationType modificationType = this.getModificationType();
        Map oldCRC = MapsKt.toMutableMap($this$adjustCrc.getOldCRC());
        for (String path : $this$adjustCrc.getUpdated()) {
            if (!this.projectAware.isIgnoredSettingsFileEvent(path, (ExternalSystemSettingsFilesModificationContext)(context = new SettingsFilesModificationContext(ExternalSystemSettingsFilesModificationContext.Event.UPDATE, modificationType, reloadStatus)))) continue;
            Long l = $this$adjustCrc.getNewCRC().get(path);
            Intrinsics.checkNotNull((Object)l);
            oldCRC.put(path, l);
        }
        for (String path : $this$adjustCrc.getCreated()) {
            if (!this.projectAware.isIgnoredSettingsFileEvent(path, (ExternalSystemSettingsFilesModificationContext)(context = new SettingsFilesModificationContext(ExternalSystemSettingsFilesModificationContext.Event.CREATE, modificationType, reloadStatus)))) continue;
            Long l = $this$adjustCrc.getNewCRC().get(path);
            Intrinsics.checkNotNull((Object)l);
            oldCRC.put(path, l);
        }
        for (String path : $this$adjustCrc.getDeleted()) {
            if (!this.projectAware.isIgnoredSettingsFileEvent(path, (ExternalSystemSettingsFilesModificationContext)(context = new SettingsFilesModificationContext(ExternalSystemSettingsFilesModificationContext.Event.DELETE, modificationType, reloadStatus)))) continue;
            oldCRC.remove(path);
        }
        SettingsFilesStatus status = new SettingsFilesStatus(oldCRC, $this$adjustCrc.getNewCRC());
        LOG.debug("[" + operationName + "] ReloadStatus=" + reloadStatus + ", ModificationType=" + modificationType + ", Updated=" + status.getUpdated() + ", Created=" + status.getCreated() + ", Deleted=" + status.getDeleted());
        return status;
    }

    @NotNull
    public final State getState() {
        return new State(this.projectStatus.isDirty(), MapsKt.toMap(this.settingsFilesStatus.get().getOldCRC()));
    }

    public final void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ProjectStatus.Stamp operationStamp = ProjectStatus.Stamp.Companion.nextStamp();
        this.settingsFilesStatus.set(new SettingsFilesStatus(MapsKt.toMap(state.settingsFiles)));
        ProjectStatus.ProjectState projectState = state.isDirty ? this.projectStatus.markDirty(operationStamp, ExternalSystemModificationType.EXTERNAL) : this.projectStatus.markSynchronized(operationStamp);
    }

    public final void refreshChanges() {
        this.submitSettingsFilesStatusUpdate("refreshChanges", (Function1<? super SettingsFilesStatusUpdateContext, Unit>)((Function1)arg_0 -> ProjectSettingsTracker.refreshChanges$lambda$0(this, arg_0)));
    }

    private final void submitSettingsFilesCollection(boolean isRefreshVfs, boolean isInvalidateCache, Function1<? super Set<String>, Unit> callback) {
        if (isInvalidateCache || isRefreshVfs) {
            this.settingsAsyncSupplier.invalidate();
        }
        this.settingsAsyncSupplier.supply(this.parentDisposable, (Function1<? super Set<String>, Unit>)((Function1)arg_0 -> ProjectSettingsTracker.submitSettingsFilesCollection$lambda$0(isRefreshVfs, callback, arg_0)));
    }

    private final void submitSettingsFilesStatusUpdate(String operationName, Function1<? super SettingsFilesStatusUpdateContext, Unit> configureContext) {
        ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus = OperationUtilKt.isOperationInProgress((ObservableOperationTrace)((ObservableOperationTrace)this.applyChangesOperation)) ? ExternalSystemSettingsFilesModificationContext.ReloadStatus.IN_PROGRESS : ExternalSystemSettingsFilesModificationContext.ReloadStatus.IDLE;
        SettingsFilesStatusUpdateContext context = new SettingsFilesStatusUpdateContext(reloadStatus, false, false, null, null, null, 62, null);
        configureContext.invoke((Object)context);
        this.submitSettingsFilesStatusUpdate(operationName, context);
    }

    private final void submitSettingsFilesStatusUpdate(String operationName, SettingsFilesStatusUpdateContext context) {
        this.submitSettingsFilesCollection(context.isRefreshVfs(), context.isInvalidateCache(), (Function1<? super Set<String>, Unit>)((Function1)arg_0 -> ProjectSettingsTracker.submitSettingsFilesStatusUpdate$lambda$0(this, operationName, context, arg_0)));
    }

    private final void updateProjectStatus(ProjectStatus.Stamp operationStamp, Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> syncEvent, Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> changeEvent, SettingsFilesStatus settingsFilesStatus) {
        Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> event;
        Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> function1 = event = settingsFilesStatus.hasChanges() ? changeEvent : syncEvent;
        if (event != null) {
            this.projectStatus.update((ProjectStatus.ProjectEvent)event.invoke((Object)operationStamp));
        }
    }

    public final void beforeApplyChanges(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ObservableOperationTraceUtil.whenOperationStarted((ObservableOperationTrace)((ObservableOperationTrace)this.applyChangesOperation), (Disposable)parentDisposable, listener2);
    }

    public final void afterApplyChanges(@NotNull Disposable parentDisposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        ObservableOperationTraceUtil.whenOperationFinished((ObservableOperationTrace)((ObservableOperationTrace)this.applyChangesOperation), (Disposable)parentDisposable, listener2);
    }

    private static final SettingsFilesStatus updateSettingsFilesStatus$lambda$0(ProjectSettingsTracker this$0, Map $newCRC, String $operationName, ExternalSystemSettingsFilesModificationContext.ReloadStatus $reloadStatus, SettingsFilesStatus it) {
        return this$0.adjustCrc(new SettingsFilesStatus(it.getOldCRC(), $newCRC), $operationName, $reloadStatus);
    }

    private static final Unit refreshChanges$lambda$0(ProjectSettingsTracker this$0, SettingsFilesStatusUpdateContext $this$submitSettingsFilesStatusUpdate) {
        Intrinsics.checkNotNullParameter((Object)$this$submitSettingsFilesStatusUpdate, (String)"$this$submitSettingsFilesStatusUpdate");
        $this$submitSettingsFilesStatusUpdate.setRefreshVfs(true);
        $this$submitSettingsFilesStatusUpdate.setSyncEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)refreshChanges.1.1.INSTANCE));
        $this$submitSettingsFilesStatusUpdate.setChangeEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)new Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent.Invalidate>((Object)ProjectStatus.ProjectEvent.Companion){

            public final ProjectStatus.ProjectEvent.Invalidate invoke(ProjectStatus.Stamp p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ProjectStatus.ProjectEvent.Companion)this.receiver).externalInvalidate(p0);
            }
        }));
        $this$submitSettingsFilesStatusUpdate.setCallback((Function0<Unit>)((Function0)() -> ProjectSettingsTracker.refreshChanges$lambda$0$0(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit refreshChanges$lambda$0$0(ProjectSettingsTracker this$0) {
        this$0.projectTracker.scheduleChangeProcessing();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit submitSettingsFilesCollection$lambda$0(boolean $isRefreshVfs, Function1 $callback, Set settingsPaths) {
        Intrinsics.checkNotNullParameter((Object)settingsPaths, (String)"settingsPaths");
        if ($isRefreshVfs) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = settingsPaths;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (Path.of(it, new String[0]) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List settingsFiles = (List)destination$iv$iv;
            if (!((Collection)settingsFiles).isEmpty()) {
                LocalFileSystem.getInstance().refreshNioFiles((Iterable)settingsFiles);
            }
        }
        $callback.invoke((Object)settingsPaths);
        return Unit.INSTANCE;
    }

    private static final Unit submitSettingsFilesStatusUpdate$lambda$0(ProjectSettingsTracker this$0, String $operationName, SettingsFilesStatusUpdateContext $context, Set settingsPaths) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)settingsPaths, (String)"settingsPaths");
            ProjectStatus.Stamp operationStamp = ProjectStatus.Stamp.Companion.nextStamp();
            Map newSettingsFilesCRC = (Map)ActionsKt.runReadAction(() -> ProjectSettingsTracker.submitSettingsFilesStatusUpdate$lambda$0$0(this$0, settingsPaths));
            SettingsFilesStatus settingsFilesStatus = this$0.updateSettingsFilesStatus($operationName, newSettingsFilesCRC, $context.getReloadStatus());
            this$0.updateProjectStatus(operationStamp, $context.getSyncEvent(), $context.getChangeEvent(), settingsFilesStatus);
            Function0<Unit> function0 = $context.getCallback();
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Map submitSettingsFilesStatusUpdate$lambda$0$0(ProjectSettingsTracker this$0, Set $settingsPaths) {
        return this$0.calculateSettingsFilesCRC($settingsPaths);
    }

    public static final /* synthetic */ Project access$getProject$p(ProjectSettingsTracker $this) {
        return $this.project;
    }

    public static final /* synthetic */ Executor access$getBackgroundExecutor$p(ProjectSettingsTracker $this) {
        return $this.backgroundExecutor;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectListener;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "onProjectReloadStart", "", "onProjectReloadFinish", "status", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemRefreshStatus;", "onSettingsFilesListChange", "intellij.platform.externalSystem.impl"})
    private final class ProjectListener
    implements ExternalSystemProjectListener {
        public void onProjectReloadStart() {
            MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)ProjectSettingsTracker.this.applyChangesOperation), null, (int)1, null);
            ProjectSettingsTracker.this.submitSettingsFilesStatusUpdate("onProjectReloadStart", (Function1<? super SettingsFilesStatusUpdateContext, Unit>)ProjectListener::onProjectReloadStart$lambda$0);
        }

        public void onProjectReloadFinish(@NotNull ExternalSystemRefreshStatus status) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            ProjectSettingsTracker.this.submitSettingsFilesStatusUpdate("onProjectReloadFinish", (Function1<? super SettingsFilesStatusUpdateContext, Unit>)arg_0 -> ProjectListener.onProjectReloadFinish$lambda$0(ProjectSettingsTracker.this, arg_0));
        }

        public void onSettingsFilesListChange() {
            ProjectSettingsTracker.this.submitSettingsFilesStatusUpdate("onSettingsFilesListChange", (Function1<? super SettingsFilesStatusUpdateContext, Unit>)arg_0 -> ProjectListener.onSettingsFilesListChange$lambda$0(ProjectSettingsTracker.this, arg_0));
        }

        private static final Unit onProjectReloadStart$lambda$0(SettingsFilesStatusUpdateContext $this$submitSettingsFilesStatusUpdate) {
            Intrinsics.checkNotNullParameter((Object)$this$submitSettingsFilesStatusUpdate, (String)"$this$submitSettingsFilesStatusUpdate");
            $this$submitSettingsFilesStatusUpdate.setRefreshVfs(true);
            $this$submitSettingsFilesStatusUpdate.setReloadStatus(ExternalSystemSettingsFilesModificationContext.ReloadStatus.JUST_STARTED);
            $this$submitSettingsFilesStatusUpdate.setSyncEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)onProjectReloadStart.1.1.INSTANCE));
            $this$submitSettingsFilesStatusUpdate.setChangeEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)new Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent.Invalidate>((Object)ProjectStatus.ProjectEvent.Companion){

                public final ProjectStatus.ProjectEvent.Invalidate invoke(ProjectStatus.Stamp p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ProjectStatus.ProjectEvent.Companion)this.receiver).externalInvalidate(p0);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit onProjectReloadFinish$lambda$0(ProjectSettingsTracker this$0, SettingsFilesStatusUpdateContext $this$submitSettingsFilesStatusUpdate) {
            Intrinsics.checkNotNullParameter((Object)$this$submitSettingsFilesStatusUpdate, (String)"$this$submitSettingsFilesStatusUpdate");
            $this$submitSettingsFilesStatusUpdate.setRefreshVfs(true);
            $this$submitSettingsFilesStatusUpdate.setReloadStatus(ExternalSystemSettingsFilesModificationContext.ReloadStatus.JUST_FINISHED);
            $this$submitSettingsFilesStatusUpdate.setSyncEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)onProjectReloadFinish.1.1.INSTANCE));
            $this$submitSettingsFilesStatusUpdate.setChangeEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)new Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent.Invalidate>((Object)ProjectStatus.ProjectEvent.Companion){

                public final ProjectStatus.ProjectEvent.Invalidate invoke(ProjectStatus.Stamp p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ProjectStatus.ProjectEvent.Companion)this.receiver).externalInvalidate(p0);
                }
            }));
            $this$submitSettingsFilesStatusUpdate.setCallback((Function0<Unit>)((Function0)() -> ProjectListener.onProjectReloadFinish$lambda$0$0(this$0)));
            return Unit.INSTANCE;
        }

        private static final Unit onProjectReloadFinish$lambda$0$0(ProjectSettingsTracker this$0) {
            MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)this$0.applyChangesOperation), null, null, (int)3, null);
            return Unit.INSTANCE;
        }

        private static final Unit onSettingsFilesListChange$lambda$0(ProjectSettingsTracker this$0, SettingsFilesStatusUpdateContext $this$submitSettingsFilesStatusUpdate) {
            Intrinsics.checkNotNullParameter((Object)$this$submitSettingsFilesStatusUpdate, (String)"$this$submitSettingsFilesStatusUpdate");
            $this$submitSettingsFilesStatusUpdate.setInvalidateCache(true);
            $this$submitSettingsFilesStatusUpdate.setSyncEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)onSettingsFilesListChange.1.1.INSTANCE));
            $this$submitSettingsFilesStatusUpdate.setChangeEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)new Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent.Modify>((Object)ProjectStatus.ProjectEvent.Companion){

                public final ProjectStatus.ProjectEvent.Modify invoke(ProjectStatus.Stamp p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((ProjectStatus.ProjectEvent.Companion)this.receiver).externalModify(p0);
                }
            }));
            $this$submitSettingsFilesStatusUpdate.setCallback((Function0<Unit>)((Function0)() -> ProjectListener.onSettingsFilesListChange$lambda$0$0(this$0)));
            return Unit.INSTANCE;
        }

        private static final Unit onSettingsFilesListChange$lambda$0$0(ProjectSettingsTracker this$0) {
            this$0.projectTracker.scheduleChangeProcessing();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$ProjectSettingsListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "onFileChange", "", "stamp", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "path", "", "modificationStamp", "", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "apply", "logModificationAsDebug", "type", "adjustedType", "intellij.platform.externalSystem.impl"})
    private final class ProjectSettingsListener
    implements FilesChangesListener {
        @Override
        public void onFileChange(@NotNull ProjectStatus.Stamp stamp, @NotNull String path, long modificationStamp, @NotNull ExternalSystemModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)stamp, (String)"stamp");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
            ExternalSystemModificationType adjustedModificationType = ProjectSettingsTracker.this.projectAware.adjustModificationType(path, modificationType);
            this.logModificationAsDebug(path, modificationStamp, modificationType, adjustedModificationType);
            ProjectSettingsTracker.this.projectStatus.markModified(stamp, adjustedModificationType);
        }

        @Override
        public void apply() {
            ProjectSettingsTracker.this.submitSettingsFilesStatusUpdate("ProjectSettingsListener.apply", (Function1<? super SettingsFilesStatusUpdateContext, Unit>)arg_0 -> ProjectSettingsListener.apply$lambda$0(ProjectSettingsTracker.this, arg_0));
        }

        private final void logModificationAsDebug(String path, long modificationStamp, ExternalSystemModificationType type, ExternalSystemModificationType adjustedType) {
            if (LOG.isDebugEnabled()) {
                String projectPath = ProjectSettingsTracker.this.projectAware.getProjectId().getExternalProjectPath();
                String string = FileUtil.getRelativePath((String)projectPath, (String)path, (char)'/');
                if (string == null) {
                    string = path;
                }
                String relativePath = string;
                LOG.debug("File " + relativePath + " is modified at " + modificationStamp + " as " + type + " (adjusted to " + adjustedType + ")");
            }
        }

        private static final Unit apply$lambda$0(ProjectSettingsTracker this$0, SettingsFilesStatusUpdateContext $this$submitSettingsFilesStatusUpdate) {
            Intrinsics.checkNotNullParameter((Object)$this$submitSettingsFilesStatusUpdate, (String)"$this$submitSettingsFilesStatusUpdate");
            $this$submitSettingsFilesStatusUpdate.setSyncEvent((Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)((Function1)apply.1.1.INSTANCE));
            $this$submitSettingsFilesStatusUpdate.setCallback((Function0<Unit>)((Function0)() -> ProjectSettingsListener.apply$lambda$0$0(this$0)));
            return Unit.INSTANCE;
        }

        private static final Unit apply$lambda$0$0(ProjectSettingsTracker this$0) {
            this$0.projectTracker.scheduleChangeProcessing();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesAsyncSupplier;", "Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;", "", "", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker;)V", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "settingsFilesCache", "Lcom/intellij/openapi/externalSystem/service/ui/completion/cache/AsyncLocalCache;", "getOrCollectSettingsFiles", "supplier", "Lcom/intellij/openapi/externalSystem/autoimport/settings/BackgroundAsyncSupplier;", "supply", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "consumer", "Lkotlin/Function1;", "invalidate", "intellij.platform.externalSystem.impl"})
    @SourceDebugExtension(value={"SMAP\nProjectSettingsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesAsyncSupplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n1563#2:388\n1634#2,3:389\n*S KotlinDebug\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesAsyncSupplier\n*L\n362#1:388\n362#1:389,3\n*E\n"})
    private final class SettingsFilesAsyncSupplier
    implements AsyncSupplier<Set<? extends String>> {
        @NotNull
        private final SimpleModificationTracker modificationTracker = new SimpleModificationTracker();
        @NotNull
        private final AsyncLocalCache<Set<String>> settingsFilesCache = new AsyncLocalCache();
        @NotNull
        private final BackgroundAsyncSupplier<Set<String>> supplier = new BackgroundAsyncSupplier(ProjectSettingsTracker.access$getProject$p(ProjectSettingsTracker.this), AsyncSupplier.Companion.blocking((Function0)new Function0<Set<? extends String>>((Object)this){

            public final Set<String> invoke() {
                return SettingsFilesAsyncSupplier.access$getOrCollectSettingsFiles((SettingsFilesAsyncSupplier)this.receiver);
            }
        }), (Function0<Boolean>)((Function0)new PropertyReference0Impl(AutoImportProjectTracker.Companion){

            public Object get() {
                return ((AutoImportProjectTracker.Companion)this.receiver).isAsyncChangesProcessing();
            }
        }), ProjectSettingsTracker.access$getBackgroundExecutor$p(ProjectSettingsTracker.this));

        private final Set<String> getOrCollectSettingsFiles() {
            return this.settingsFilesCache.getOrCreateValueBlocking(this.modificationTracker.getModificationCount(), (Function0<Set<String>>)((Function0)() -> SettingsFilesAsyncSupplier.getOrCollectSettingsFiles$lambda$0(ProjectSettingsTracker.this)));
        }

        @Override
        public void supply(@NotNull Disposable parentDisposable, @NotNull Function1<? super Set<String>, Unit> consumer) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.supplier.supply(parentDisposable, (Function1<Set<String>, Unit>)((Function1)arg_0 -> SettingsFilesAsyncSupplier.supply$lambda$0(consumer, ProjectSettingsTracker.this, arg_0)));
        }

        public final void invalidate() {
            this.modificationTracker.incModificationCount();
        }

        /*
         * WARNING - void declaration
         */
        private static final Set getOrCollectSettingsFiles$lambda$0(ProjectSettingsTracker this$0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this$0.projectAware.getSettingsFiles();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtilRt.toSystemIndependentName((String)it));
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private static final Unit supply$lambda$0(Function1 $consumer, ProjectSettingsTracker this$0, Set it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $consumer.invoke((Object)SetsKt.plus((Set)it, (Iterable)((SettingsFilesStatus)this$0.settingsFilesStatus.get()).getOldCRC().keySet()));
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Set access$getOrCollectSettingsFiles(SettingsFilesAsyncSupplier $this) {
            return $this.getOrCollectSettingsFiles();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesModificationContext;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext;", "event", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$Event;", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "reloadStatus", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$Event;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;)V", "getEvent", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$Event;", "getModificationType", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemModificationType;", "getReloadStatus", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;", "intellij.platform.externalSystem.impl"})
    private static final class SettingsFilesModificationContext
    implements ExternalSystemSettingsFilesModificationContext {
        @NotNull
        private final ExternalSystemSettingsFilesModificationContext.Event event;
        @NotNull
        private final ExternalSystemModificationType modificationType;
        @NotNull
        private final ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus;

        public SettingsFilesModificationContext(@NotNull ExternalSystemSettingsFilesModificationContext.Event event, @NotNull ExternalSystemModificationType modificationType, @NotNull ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)modificationType, (String)"modificationType");
            Intrinsics.checkNotNullParameter((Object)reloadStatus, (String)"reloadStatus");
            this.event = event;
            this.modificationType = modificationType;
            this.reloadStatus = reloadStatus;
        }

        @NotNull
        public ExternalSystemSettingsFilesModificationContext.Event getEvent() {
            return this.event;
        }

        @NotNull
        public ExternalSystemModificationType getModificationType() {
            return this.modificationType;
        }

        @NotNull
        public ExternalSystemSettingsFilesModificationContext.ReloadStatus getReloadStatus() {
            return this.reloadStatus;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesReloadContext;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "updated", "", "", "created", "deleted", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getUpdated", "()Ljava/util/Set;", "getCreated", "getDeleted", "intellij.platform.externalSystem.impl"})
    private static final class SettingsFilesReloadContext
    implements ExternalSystemSettingsFilesReloadContext {
        @NotNull
        private final Set<String> updated;
        @NotNull
        private final Set<String> created;
        @NotNull
        private final Set<String> deleted;

        public SettingsFilesReloadContext(@NotNull Set<String> updated, @NotNull Set<String> created, @NotNull Set<String> deleted) {
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(created, (String)"created");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            this.updated = updated;
            this.created = created;
            this.deleted = deleted;
        }

        @NotNull
        public Set<String> getUpdated() {
            return this.updated;
        }

        @NotNull
        public Set<String> getCreated() {
            return this.created;
        }

        @NotNull
        public Set<String> getDeleted() {
            return this.deleted;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0006\u0010\u001a\u001a\u00020\u001bR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus;", "", "oldCRC", "", "", "", "newCRC", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "CRC", "(Ljava/util/Map;)V", "getOldCRC", "()Ljava/util/Map;", "getNewCRC", "updated", "", "getUpdated", "()Ljava/util/Set;", "updated$delegate", "Lkotlin/Lazy;", "created", "getCreated", "created$delegate", "deleted", "getDeleted", "deleted$delegate", "hasChanges", "", "intellij.platform.externalSystem.impl"})
    @SourceDebugExtension(value={"SMAP\nProjectSettingsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,387:1\n865#2,2:388\n*S KotlinDebug\n*F\n+ 1 ProjectSettingsTracker.kt\ncom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatus\n*L\n269#1:388,2\n*E\n"})
    private static final class SettingsFilesStatus {
        @NotNull
        private final Map<String, Long> oldCRC;
        @NotNull
        private final Map<String, Long> newCRC;
        @NotNull
        private final Lazy updated$delegate;
        @NotNull
        private final Lazy created$delegate;
        @NotNull
        private final Lazy deleted$delegate;

        public SettingsFilesStatus(@NotNull Map<String, Long> oldCRC, @NotNull Map<String, Long> newCRC) {
            Intrinsics.checkNotNullParameter(oldCRC, (String)"oldCRC");
            Intrinsics.checkNotNullParameter(newCRC, (String)"newCRC");
            this.oldCRC = oldCRC;
            this.newCRC = newCRC;
            this.updated$delegate = LazyKt.lazy(() -> SettingsFilesStatus.updated_delegate$lambda$0(this));
            this.created$delegate = LazyKt.lazy(() -> SettingsFilesStatus.created_delegate$lambda$0(this));
            this.deleted$delegate = LazyKt.lazy(() -> SettingsFilesStatus.deleted_delegate$lambda$0(this));
        }

        @NotNull
        public final Map<String, Long> getOldCRC() {
            return this.oldCRC;
        }

        @NotNull
        public final Map<String, Long> getNewCRC() {
            return this.newCRC;
        }

        public SettingsFilesStatus(@NotNull Map<String, Long> CRC) {
            Intrinsics.checkNotNullParameter(CRC, (String)"CRC");
            this(CRC, CRC);
        }

        public /* synthetic */ SettingsFilesStatus(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = MapsKt.emptyMap();
            }
            this(map);
        }

        @NotNull
        public final Set<String> getUpdated() {
            Lazy lazy = this.updated$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Set<String> getCreated() {
            Lazy lazy = this.created$delegate;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final Set<String> getDeleted() {
            Lazy lazy = this.deleted$delegate;
            return (Set)lazy.getValue();
        }

        public final boolean hasChanges() {
            return !((Collection)this.getUpdated()).isEmpty() || !((Collection)this.getCreated()).isEmpty() || !((Collection)this.getDeleted()).isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private static final HashSet updated_delegate$lambda$0(SettingsFilesStatus this$0) {
            void var2_2;
            void $this$filterTo$iv;
            Iterable iterable = CollectionsKt.intersect((Iterable)this$0.oldCRC.keySet(), (Iterable)this$0.newCRC.keySet());
            Collection destination$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)this$0.oldCRC.get(it), (Object)this$0.newCRC.get(it)))) continue;
                destination$iv.add(element$iv);
            }
            return (HashSet)var2_2;
        }

        private static final Set created_delegate$lambda$0(SettingsFilesStatus this$0) {
            return SetsKt.minus(this$0.newCRC.keySet(), (Iterable)this$0.oldCRC.keySet());
        }

        private static final Set deleted_delegate$lambda$0(SettingsFilesStatus this$0) {
            return SetsKt.minus(this$0.oldCRC.keySet(), (Iterable)this$0.newCRC.keySet());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\b\u0002\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0015\"\u0004\b\u0018\u0010\u0017R(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR(\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u0004\b\u001e\u0010\u001cR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$SettingsFilesStatusUpdateContext;", "", "reloadStatus", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;", "isRefreshVfs", "", "isInvalidateCache", "syncEvent", "Lkotlin/Function1;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$Stamp;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ProjectEvent;", "changeEvent", "callback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;ZZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getReloadStatus", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;", "setReloadStatus", "(Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesModificationContext$ReloadStatus;)V", "()Z", "setRefreshVfs", "(Z)V", "setInvalidateCache", "getSyncEvent", "()Lkotlin/jvm/functions/Function1;", "setSyncEvent", "(Lkotlin/jvm/functions/Function1;)V", "getChangeEvent", "setChangeEvent", "getCallback", "()Lkotlin/jvm/functions/Function0;", "setCallback", "(Lkotlin/jvm/functions/Function0;)V", "intellij.platform.externalSystem.impl"})
    private static final class SettingsFilesStatusUpdateContext {
        @NotNull
        private ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus;
        private boolean isRefreshVfs;
        private boolean isInvalidateCache;
        @Nullable
        private Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> syncEvent;
        @Nullable
        private Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> changeEvent;
        @Nullable
        private Function0<Unit> callback;

        public SettingsFilesStatusUpdateContext(@NotNull ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus, boolean isRefreshVfs, boolean isInvalidateCache, @Nullable Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> syncEvent, @Nullable Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> changeEvent, @Nullable Function0<Unit> callback) {
            Intrinsics.checkNotNullParameter((Object)reloadStatus, (String)"reloadStatus");
            this.reloadStatus = reloadStatus;
            this.isRefreshVfs = isRefreshVfs;
            this.isInvalidateCache = isInvalidateCache;
            this.syncEvent = syncEvent;
            this.changeEvent = changeEvent;
            this.callback = callback;
        }

        public /* synthetic */ SettingsFilesStatusUpdateContext(ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus, boolean bl, boolean bl2, Function1 function1, Function1 function12, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                function1 = null;
            }
            if ((n & 0x10) != 0) {
                function12 = null;
            }
            if ((n & 0x20) != 0) {
                function0 = null;
            }
            this(reloadStatus, bl, bl2, (Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)function1, (Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent>)function12, (Function0<Unit>)function0);
        }

        @NotNull
        public final ExternalSystemSettingsFilesModificationContext.ReloadStatus getReloadStatus() {
            return this.reloadStatus;
        }

        public final void setReloadStatus(@NotNull ExternalSystemSettingsFilesModificationContext.ReloadStatus reloadStatus) {
            Intrinsics.checkNotNullParameter((Object)reloadStatus, (String)"<set-?>");
            this.reloadStatus = reloadStatus;
        }

        public final boolean isRefreshVfs() {
            return this.isRefreshVfs;
        }

        public final void setRefreshVfs(boolean bl) {
            this.isRefreshVfs = bl;
        }

        public final boolean isInvalidateCache() {
            return this.isInvalidateCache;
        }

        public final void setInvalidateCache(boolean bl) {
            this.isInvalidateCache = bl;
        }

        @Nullable
        public final Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent> getSyncEvent() {
            return this.syncEvent;
        }

        public final void setSyncEvent(@Nullable Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> function1) {
            this.syncEvent = function1;
        }

        @Nullable
        public final Function1<ProjectStatus.Stamp, ProjectStatus.ProjectEvent> getChangeEvent() {
            return this.changeEvent;
        }

        public final void setChangeEvent(@Nullable Function1<? super ProjectStatus.Stamp, ? extends ProjectStatus.ProjectEvent> function1) {
            this.changeEvent = function1;
        }

        @Nullable
        public final Function0<Unit> getCallback() {
            return this.callback;
        }

        public final void setCallback(@Nullable Function0<Unit> function0) {
            this.callback = function0;
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB9\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J%\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001dR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "", "isDirty", "", "settingsFiles", "", "", "", "<init>", "(ZLjava/util/Map;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IZLjava/util/Map;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_platform_externalSystem_impl", "$serializer", "Companion", "intellij.platform.externalSystem.impl"})
    public static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final boolean isDirty;
        @JvmField
        @NotNull
        public final Map<String, Long> settingsFiles;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public State(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkNotNullParameter(settingsFiles, (String)"settingsFiles");
            this.isDirty = isDirty;
            this.settingsFiles = settingsFiles;
        }

        public /* synthetic */ State(boolean bl, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            this(bl, map);
        }

        public final boolean component1() {
            return this.isDirty;
        }

        @NotNull
        public final Map<String, Long> component2() {
            return this.settingsFiles;
        }

        @NotNull
        public final State copy(boolean isDirty, @NotNull Map<String, Long> settingsFiles) {
            Intrinsics.checkNotNullParameter(settingsFiles, (String)"settingsFiles");
            return new State(isDirty, settingsFiles);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isDirty;
            }
            if ((n & 2) != 0) {
                map = state.settingsFiles;
            }
            return state.copy(bl, map);
        }

        @NotNull
        public String toString() {
            return "State(isDirty=" + this.isDirty + ", settingsFiles=" + this.settingsFiles + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isDirty);
            result = result * 31 + ((Object)this.settingsFiles).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isDirty != state.isDirty) {
                return false;
            }
            return Intrinsics.areEqual(this.settingsFiles, state.settingsFiles);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_platform_externalSystem_impl(State self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !self.isDirty) {
                output.encodeBooleanElement(serialDesc, 0, self.isDirty);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : !Intrinsics.areEqual(self.settingsFiles, (Object)MapsKt.emptyMap())) {
                output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.settingsFiles);
            }
        }

        public /* synthetic */ State(int seen0, boolean isDirty, Map settingsFiles, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)State$$serializer.INSTANCE.getDescriptor());
            }
            this.isDirty = (seen0 & 1) == 0 ? true : isDirty;
            this.settingsFiles = (seen0 & 2) == 0 ? MapsKt.emptyMap() : settingsFiles;
        }

        public State() {
            this(false, null, 3, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)LongSerializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectSettingsTracker$State;", "intellij.platform.externalSystem.impl"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<State> serializer() {
                return (KSerializer)State$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

