/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemModificationType;
import com.intellij.openapi.externalSystem.autoimport.changes.AsyncFileChangesListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.operation.core.AtomicOperationTrace;
import com.intellij.openapi.observable.operation.core.MutableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTrace;
import com.intellij.openapi.observable.operation.core.ObservableOperationTraceUtil;
import com.intellij.openapi.observable.operation.core.OperationUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternalChangeActionUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncDocumentChangesListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "isIgnoreExternalChanges", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener;", "<init>", "(ZLcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFileChangesListener;)V", "bulkUpdateOperation", "Lcom/intellij/openapi/observable/operation/core/AtomicOperationTrace;", "isExternalModification", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "bulkUpdateStarting", "document", "Lcom/intellij/openapi/editor/Document;", "bulkUpdateFinished", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class AsyncDocumentChangesListener
implements DocumentListener {
    private final boolean isIgnoreExternalChanges;
    @NotNull
    private final AsyncFileChangesListener listener;
    @NotNull
    private final AtomicOperationTrace bulkUpdateOperation;

    public AsyncDocumentChangesListener(boolean isIgnoreExternalChanges, @NotNull AsyncFileChangesListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.isIgnoreExternalChanges = isIgnoreExternalChanges;
        this.listener = listener2;
        this.bulkUpdateOperation = new AtomicOperationTrace("Bulk document update operation");
        ObservableOperationTraceUtil.whenOperationStarted((ObservableOperationTrace)((ObservableOperationTrace)this.bulkUpdateOperation), () -> AsyncDocumentChangesListener._init_$lambda$0(this));
        ObservableOperationTraceUtil.whenOperationFinished((ObservableOperationTrace)((ObservableOperationTrace)this.bulkUpdateOperation), () -> AsyncDocumentChangesListener._init_$lambda$1(this));
    }

    private final boolean isExternalModification() {
        return ExternalChangeActionUtil.isExternalChangeInProgress();
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isIgnoreExternalChanges && this.isExternalModification()) {
            return;
        }
        Document document = event.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        VirtualFile virtualFile = fileDocumentManager2.getFile(document2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (OperationUtilKt.isOperationInProgress((ObservableOperationTrace)((ObservableOperationTrace)this.bulkUpdateOperation))) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.listener.onFileChange(string, document2.getModificationStamp(), ExternalSystemModificationType.INTERNAL);
        } else {
            this.listener.init();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.listener.onFileChange(string, document2.getModificationStamp(), ExternalSystemModificationType.INTERNAL);
            this.listener.apply();
        }
    }

    public void bulkUpdateStarting(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        MutableOperationTrace.traceStart$default((MutableOperationTrace)((MutableOperationTrace)this.bulkUpdateOperation), null, (int)1, null);
    }

    public void bulkUpdateFinished(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        MutableOperationTrace.traceFinish$default((MutableOperationTrace)((MutableOperationTrace)this.bulkUpdateOperation), null, null, (int)3, null);
    }

    private static final Unit _init_$lambda$0(AsyncDocumentChangesListener this$0) {
        this$0.listener.init();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(AsyncDocumentChangesListener this$0) {
        this$0.listener.apply();
        return Unit.INSTANCE;
    }
}

