/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesSeparator;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bg\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "", "isProcessRecursively", "", "init", "", "apply", "isRelevant", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "updateFile", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public interface VirtualFileChangesListener {
    @NotNull
    public static final Companion Companion = com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener$Companion.$$INSTANCE;

    default public boolean isProcessRecursively() {
        return false;
    }

    default public void init() {
    }

    default public void apply() {
    }

    default public boolean isRelevant(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }

    default public void updateFile(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener$Companion;", "", "<init>", "()V", "installBulkVirtualFileListener", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "installAsyncVirtualFileListener", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        public final void installBulkVirtualFileListener(@NotNull VirtualFileChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            BulkFileListener bulkListener2 = new BulkFileListener(listener2){
                final /* synthetic */ VirtualFileChangesListener $listener;
                {
                    this.$listener = $listener;
                }

                public void before(List<? extends VFileEvent> events) {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    VirtualFileChangesSeparator separator = new VirtualFileChangesSeparator(this.$listener, events);
                    this.$listener.init();
                    separator.processBeforeEvents();
                    this.$listener.apply();
                }

                public void after(List<? extends VFileEvent> events) {
                    Intrinsics.checkNotNullParameter(events, (String)"events");
                    VirtualFileChangesSeparator separator = new VirtualFileChangesSeparator(this.$listener, events);
                    this.$listener.init();
                    separator.processAfterEvents();
                    this.$listener.apply();
                }
            };
            Application application = ApplicationManager.getApplication();
            MessageBusConnection messageBusConnection = application.getMessageBus().connect(parentDisposable);
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            messageBusConnection.subscribe(topic, (Object)bulkListener2);
        }

        public final void installAsyncVirtualFileListener(@NotNull VirtualFileChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            AsyncFileListener asyncListener2 = arg_0 -> Companion.installAsyncVirtualFileListener$lambda$0(listener2, arg_0);
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
            VirtualFileManager virtualFileManager2 = virtualFileManager;
            virtualFileManager2.addAsyncFileListener(asyncListener2, parentDisposable);
        }

        private static final AsyncFileListener.ChangeApplier installAsyncVirtualFileListener$lambda$0(VirtualFileChangesListener $listener, List events) {
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            VirtualFileChangesSeparator separator = new VirtualFileChangesSeparator($listener, events);
            return new AsyncFileListener.ChangeApplier($listener, separator){
                final /* synthetic */ VirtualFileChangesListener $listener;
                final /* synthetic */ VirtualFileChangesSeparator $separator;
                {
                    this.$listener = $listener;
                    this.$separator = $separator;
                }

                public void beforeVfsChange() {
                    this.$listener.init();
                    this.$separator.processBeforeEvents();
                }

                public void afterVfsChange() {
                    this.$separator.processAfterEvents();
                    this.$listener.apply();
                }
            };
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

