/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes.vfs;

import com.intellij.openapi.externalSystem.autoimport.changes.vfs.VirtualFileChangesListener;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u001c\u0010\u0015\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001c\u0010\u0019\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001c\u0010\u001a\u001a\u00020\f*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R*\u0010\t\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesSeparator;", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "<init>", "(Lcom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesListener;Ljava/util/List;)V", "beforeAppliers", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "afterAppliers", "before", "", "action", "after", "processBeforeEvents", "processAfterEvents", "process", "f", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "processFile", "processRecursively", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVirtualFileChangesSeparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileChangesSeparator.kt\ncom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesSeparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n1869#2,2:97\n*S KotlinDebug\n*F\n+ 1 VirtualFileChangesSeparator.kt\ncom/intellij/openapi/externalSystem/autoimport/changes/vfs/VirtualFileChangesSeparator\n*L\n22#1:95,2\n24#1:97,2\n*E\n"})
public final class VirtualFileChangesSeparator {
    @NotNull
    private final ArrayList<Function0<Unit>> beforeAppliers;
    @NotNull
    private final ArrayList<Function0<Unit>> afterAppliers;

    public VirtualFileChangesSeparator(@NotNull VirtualFileChangesListener listener2, @NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.beforeAppliers = new ArrayList();
        this.afterAppliers = new ArrayList();
        for (VFileEvent vFileEvent : events) {
            ProgressManager.checkCanceled();
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                this.before((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$0(this, listener2, vFileEvent)));
                this.after((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$1(this, listener2, vFileEvent)));
                continue;
            }
            if (vFileEvent2 instanceof VFileMoveEvent) {
                this.before((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$2(this, listener2, vFileEvent)));
                this.after((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$3(this, listener2, vFileEvent)));
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                this.after((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$4(vFileEvent, this, listener2)));
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                this.after((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$5(vFileEvent, this, listener2)));
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent) && !(vFileEvent2 instanceof VFileContentChangeEvent)) continue;
            this.before((Function0<Unit>)((Function0)() -> VirtualFileChangesSeparator._init_$lambda$6(vFileEvent, this, listener2)));
        }
    }

    private final boolean before(Function0<Unit> action2) {
        return this.beforeAppliers.add(action2);
    }

    private final boolean after(Function0<Unit> action2) {
        return this.afterAppliers.add(action2);
    }

    public final void processBeforeEvents() {
        Iterable $this$forEach$iv = this.beforeAppliers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final void processAfterEvents() {
        Iterable $this$forEach$iv = this.afterAppliers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private final void process(VirtualFileChangesListener $this$process, VirtualFile f, VFileEvent event) {
        if ($this$process.isProcessRecursively()) {
            this.processRecursively($this$process, f, event);
        } else {
            this.processFile($this$process, f, event);
        }
    }

    private final void processFile(VirtualFileChangesListener $this$processFile, VirtualFile f, VFileEvent event) {
        if ($this$processFile.isRelevant(f, event)) {
            $this$processFile.updateFile(f, event);
        }
    }

    private final void processRecursively(VirtualFileChangesListener $this$processRecursively, VirtualFile f, VFileEvent event) {
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>(this, $this$processRecursively, event, optionArray){
            final /* synthetic */ VirtualFileChangesSeparator this$0;
            final /* synthetic */ VirtualFileChangesListener $this_processRecursively;
            final /* synthetic */ VFileEvent $event;
            {
                this.this$0 = $receiver;
                this.$this_processRecursively = $receiver2;
                this.$event = $event;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                VirtualFileChangesSeparator.access$processFile(this.this$0, this.$this_processRecursively, f, this.$event);
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(VirtualFile f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                return f.isDirectory() && f instanceof NewVirtualFile ? ((NewVirtualFile)f).iterInDbChildren() : null;
            }
        }));
    }

    private static final Unit _init_$lambda$0(VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener, VFileEvent $each) {
        VirtualFile virtualFile = ((VFilePropertyChangeEvent)$each).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this$0.process($listener, virtualFile, $each);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener, VFileEvent $each) {
        VirtualFile virtualFile = ((VFilePropertyChangeEvent)$each).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this$0.process($listener, virtualFile, $each);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener, VFileEvent $each) {
        VirtualFile virtualFile = ((VFileMoveEvent)$each).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this$0.process($listener, virtualFile, $each);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener, VFileEvent $each) {
        VirtualFile virtualFile = ((VFileMoveEvent)$each).getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this$0.process($listener, virtualFile, $each);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(VFileEvent $each, VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener) {
        VirtualFile newFile = ((VFileCopyEvent)$each).getNewParent().findChild(((VFileCopyEvent)$each).getNewChildName());
        if (newFile != null) {
            this$0.process($listener, newFile, $each);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(VFileEvent $each, VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener) {
        VirtualFile file = ((VFileCreateEvent)$each).getFile();
        if (file != null) {
            this$0.process($listener, file, $each);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(VFileEvent $each, VirtualFileChangesSeparator this$0, VirtualFileChangesListener $listener) {
        VirtualFile file = $each.getFile();
        if (file != null) {
            this$0.process($listener, file, $each);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$processFile(VirtualFileChangesSeparator $this, VirtualFileChangesListener $receiver, VirtualFile f, VFileEvent event) {
        $this.processFile($receiver, f, event);
    }
}

