/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autolink;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.environment.EnvironmentKey;
import com.intellij.ide.environment.EnvironmentKeyKt;
import com.intellij.ide.environment.EnvironmentService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.importing.ExternalSystemKeyProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.ui.ExternalSystemTextProvider;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="UnlinkedProjectNotification", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0007\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0007J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b \r*\u0017\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b0\f\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "disabledNotifications", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "notifiedNotifications", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "Lcom/intellij/notification/Notification;", "notificationNotify", "", "projectId", "callback", "Lkotlin/Function0;", "checkEnvironment", "", "disableNotification", "notificationExpire", "getProjectsWithNotification", "getState", "loadState", "state", "State", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUnlinkedProjectNotificationAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnlinkedProjectNotificationAware.kt\ncom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n42#2,3:159\n1#3:162\n*S KotlinDebug\n*F\n+ 1 UnlinkedProjectNotificationAware.kt\ncom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware\n*L\n76#1:159,3\n*E\n"})
public final class UnlinkedProjectNotificationAware
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> disabledNotifications;
    @NotNull
    private final ConcurrentHashMap<ExternalSystemProjectId, Notification> notifiedNotifications;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "External System Auto-Link Notification Group";
    @NotNull
    private static final String UNLINKED_NOTIFICATION_ID = "external.system.autolink.unlinked.project.notification";

    public UnlinkedProjectNotificationAware(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.disabledNotifications = set;
        this.notifiedNotifications = new ConcurrentHashMap();
    }

    public final void notificationNotify(@NotNull ExternalSystemProjectId projectId, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.disabledNotifications.contains(projectId.getSystemId().getId())) {
            LOG.debug(projectId + ": notification has been disabled");
            return;
        }
        if (((ConcurrentHashMap.KeySetView)this.notifiedNotifications.keySet()).contains(projectId)) {
            LOG.debug(projectId + ": notification has been already notified");
            return;
        }
        ExternalSystemTextProvider textProvider = ExternalSystemTextProvider.Companion.getExtension(projectId.getSystemId());
        NotificationGroupManager notificationManager = NotificationGroupManager.getInstance();
        NotificationGroup notificationGroup = notificationManager.getNotificationGroup(NOTIFICATION_GROUP_ID);
        String notificationContent = textProvider.getUPNText(projectId.getProjectName());
        if (this.checkEnvironment(projectId, callback)) {
            return;
        }
        this.notifiedNotifications.computeIfAbsent(projectId, arg_0 -> UnlinkedProjectNotificationAware.notificationNotify$lambda$1(arg_0 -> UnlinkedProjectNotificationAware.notificationNotify$lambda$0(notificationGroup, notificationContent, textProvider, callback, this, projectId, arg_0), arg_0));
    }

    private final boolean checkEnvironment(ExternalSystemProjectId projectId, Function0<Unit> callback) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Unlinked project notification is shown; Consider specifying '" + ExternalSystemKeyProvider.Keys.INSTANCE.getLINK_UNLINKED_PROJECT().getId() + "' to import the necessary build scripts.");
        }
        boolean $i$f$service = false;
        Class<EnvironmentService> serviceClass$iv = EnvironmentService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        EnvironmentService environmentService = (EnvironmentService)object;
        String linkChoice2 = (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(environmentService, null){
            int label;
            final /* synthetic */ EnvironmentService $environmentService;
            {
                this.$environmentService = $environmentService;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$environmentService.getEnvironmentValue(ExternalSystemKeyProvider.Keys.INSTANCE.getLINK_UNLINKED_PROJECT(), "", (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (!Intrinsics.areEqual((Object)linkChoice2, (Object)"")) {
            String choiceForThisBuildSystem;
            Object v2;
            block8: {
                if (Intrinsics.areEqual((Object)linkChoice2, (Object)"all")) {
                    callback.invoke();
                    return true;
                }
                String[] stringArray = new String[]{","};
                List allChoices = StringsKt.split$default((CharSequence)linkChoice2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable iterable = allChoices;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    String string = projectId.getSystemId().getReadableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReadableName(...)");
                    if (!StringsKt.startsWith$default((String)it, (String)string, (boolean)false, (int)2, null)) continue;
                    v2 = t;
                    break block8;
                }
                v2 = null;
            }
            String string = v2;
            String string2 = choiceForThisBuildSystem = string != null ? StringsKt.substringAfter$default((String)string, (String)":", null, (int)2, null) : null;
            if (Intrinsics.areEqual((Object)string2, (Object)"import")) {
                callback.invoke();
                return true;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"skip")) {
                this.disableNotification(projectId);
                return true;
            }
            if (string2 != null) {
                LOG.error("Invalid value for the key " + ExternalSystemKeyProvider.Keys.INSTANCE.getLINK_UNLINKED_PROJECT() + ". \nThe correct usage:\n " + EnvironmentKeyKt.getDescription((EnvironmentKey)ExternalSystemKeyProvider.Keys.INSTANCE.getLINK_UNLINKED_PROJECT()));
            }
        }
        return false;
    }

    private final void disableNotification(ExternalSystemProjectId projectId) {
        String string = projectId.getSystemId().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.disabledNotifications.add(string);
        LOG.debug(projectId + ": notification is disabled");
    }

    public final void notificationExpire(@NotNull ExternalSystemProjectId projectId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Notification notification = this.notifiedNotifications.remove(projectId);
            if (notification == null) break block0;
            notification.expire();
        }
    }

    @TestOnly
    @NotNull
    public final Set<ExternalSystemProjectId> getProjectsWithNotification() {
        Set set = this.notifiedNotifications.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        return set;
    }

    @NotNull
    public State getState() {
        return new State(this.disabledNotifications);
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.disabledNotifications.clear();
        this.disabledNotifications.addAll((Collection<String>)state.getDisabledNotifications());
    }

    private static final Notification notificationNotify$lambda$0(NotificationGroup $notificationGroup, String $notificationContent, ExternalSystemTextProvider $textProvider, Function0 $callback, UnlinkedProjectNotificationAware this$0, ExternalSystemProjectId $projectId, ExternalSystemProjectId it) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Notification notification2 = $notificationGroup.createNotification($notificationContent, NotificationType.INFORMATION).setDisplayId(UNLINKED_NOTIFICATION_ID).setSuggestionType(true);
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setSuggestionType(...)");
        Notification $this$notificationNotify_u24lambda_u240_u243 = notification = UnlinkedProjectNotificationAware.Companion.setNotificationHelp(notification2, $textProvider.getUPNHelpText()).addAction((AnAction)NotificationAction.createSimpleExpiring((String)$textProvider.getUPNLinkActionText(), () -> UnlinkedProjectNotificationAware.notificationNotify$lambda$0$0($callback))).addAction((AnAction)NotificationAction.createSimpleExpiring((String)$textProvider.getUPNSkipActionText(), () -> UnlinkedProjectNotificationAware.notificationNotify$lambda$0$1(this$0, $projectId))).whenExpired(() -> UnlinkedProjectNotificationAware.notificationNotify$lambda$0$2(this$0, $projectId));
        boolean bl = false;
        $this$notificationNotify_u24lambda_u240_u243.notify(this$0.project);
        LOG.debug($projectId + ": notification is notified");
        return notification;
    }

    private static final void notificationNotify$lambda$0$0(Function0 $callback) {
        $callback.invoke();
    }

    private static final void notificationNotify$lambda$0$1(UnlinkedProjectNotificationAware this$0, ExternalSystemProjectId $projectId) {
        this$0.disableNotification($projectId);
    }

    private static final void notificationNotify$lambda$0$2(UnlinkedProjectNotificationAware this$0, ExternalSystemProjectId $projectId) {
        this$0.notifiedNotifications.remove($projectId);
        LOG.debug($projectId + ": notification is expired");
    }

    private static final Notification notificationNotify$lambda$1(Function1 $tmp0, Object p0) {
        return (Notification)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final UnlinkedProjectNotificationAware getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void enableNotifications(@NotNull Project project, @NotNull ProjectSystemId systemId) {
        Companion.enableNotifications(project, systemId);
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autolink");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0019\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\u000b\u0010\u0014\u001a\u00070\b\u00a2\u0006\u0002\b\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NOTIFICATION_GROUP_ID", "", "UNLINKED_NOTIFICATION_ID", "getInstance", "Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware;", "project", "Lcom/intellij/openapi/project/Project;", "enableNotifications", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "setNotificationHelp", "Lcom/intellij/notification/Notification;", "help", "Lcom/intellij/openapi/util/NlsActions$ActionDescription;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UnlinkedProjectNotificationAware getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(UnlinkedProjectNotificationAware.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (UnlinkedProjectNotificationAware)object;
        }

        @JvmStatic
        public final void enableNotifications(@NotNull Project project, @NotNull ProjectSystemId systemId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
            this.getInstance(project).disabledNotifications.remove(systemId.getId());
        }

        private final Notification setNotificationHelp(Notification $this$setNotificationHelp, String help) {
            Notification notification;
            Notification $this$setNotificationHelp_u24lambda_u240 = notification = $this$setNotificationHelp;
            boolean bl = false;
            String string = CommonBundle.getHelpButtonText();
            $this$setNotificationHelp_u24lambda_u240.setContextHelpAction((AnAction)new DumbAwareAction(help, string){

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
            return notification;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autolink/UnlinkedProjectNotificationAware$State;", "", "disabledNotifications", "", "", "<init>", "(Ljava/util/Set;)V", "getDisabledNotifications", "()Ljava/util/Set;", "setDisabledNotifications", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.externalSystem.impl"})
    public static final class State {
        @NotNull
        private Set<String> disabledNotifications;

        public State(@NotNull Set<String> disabledNotifications) {
            Intrinsics.checkNotNullParameter(disabledNotifications, (String)"disabledNotifications");
            this.disabledNotifications = disabledNotifications;
        }

        public /* synthetic */ State(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        public final Set<String> getDisabledNotifications() {
            return this.disabledNotifications;
        }

        public final void setDisabledNotifications(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.disabledNotifications = set;
        }

        @NotNull
        public final Set<String> component1() {
            return this.disabledNotifications;
        }

        @NotNull
        public final State copy(@NotNull Set<String> disabledNotifications) {
            Intrinsics.checkNotNullParameter(disabledNotifications, (String)"disabledNotifications");
            return new State(disabledNotifications);
        }

        public static /* synthetic */ State copy$default(State state, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = state.disabledNotifications;
            }
            return state.copy(set);
        }

        @NotNull
        public String toString() {
            return "State(disabledNotifications=" + this.disabledNotifications + ")";
        }

        public int hashCode() {
            return ((Object)this.disabledNotifications).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            return Intrinsics.areEqual(this.disabledNotifications, state.disabledNotifications);
        }

        public State() {
            this(null, 1, null);
        }
    }
}

