/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSaveSessionProducer;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStorageKt;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStreamProviderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.platform.settings.SettingsController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalProjectStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "fileSpec", "", "project", "Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "rootElementName", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/configurationStore/StateStorageManager;Ljava/lang/String;)V", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "manager", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "getManager$intellij_platform_externalSystem_impl", "()Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "loadLocalData", "Lorg/jdom/Element;", "createSaveSession", "Lcom/intellij/configurationStore/SaveSessionProducer;", "states", "Lcom/intellij/configurationStore/StateMap;", "toString", "intellij.platform.externalSystem.impl"})
public class ExternalProjectStorage
extends XmlElementStorage {
    @NotNull
    private final ExternalSystemStreamProviderFactory manager;

    public ExternalProjectStorage(@NotNull String fileSpec, @NotNull Project project, @NotNull StateStorageManager storageManager, @Nullable String rootElementName) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        super(fileSpec, rootElementName, storageManager.getMacroSubstitutor(), RoamingType.DISABLED, null, null, 48, null);
        this.manager = ExternalSystemStorageKt.access$findExternalSystemStreamProviderFactory(project);
    }

    @Nullable
    public SettingsController getController() {
        return null;
    }

    @NotNull
    public final ExternalSystemStreamProviderFactory getManager$intellij_platform_externalSystem_impl() {
        return this.manager;
    }

    @Nullable
    protected Element loadLocalData() {
        return this.manager.getFileStorage().read(this.fileSpec);
    }

    @NotNull
    protected SaveSessionProducer createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        return (SaveSessionProducer)new ExternalStorageSaveSessionProducer(states, this, this.manager.getFileStorage(), this.fileSpec, null, 16, null);
    }

    @NotNull
    public String toString() {
        return "ExternalProjectStorage(fileSpec=" + this.fileSpec + ")";
    }
}

