/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StorageCreator;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalModuleStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectFilteringStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ExternalStorageSpec
extends FileStorageAnnotation
implements StorageCreator {
    private final State inProjectStateSpec;

    public ExternalStorageSpec(@NotNull String path, @Nullable State inProjectStateSpec) {
        if (path == null) {
            ExternalStorageSpec.$$$reportNull$$$0(0);
        }
        super(path, false);
        this.inProjectStateSpec = inProjectStateSpec;
    }

    @NotNull
    public StateStorage create(@NotNull StateStorageManager storageManager) {
        if (storageManager == null) {
            ExternalStorageSpec.$$$reportNull$$$0(1);
        }
        ComponentManager componentManager = storageManager.getComponentManager();
        assert (componentManager != null);
        if (this.path.equals("$MODULE_FILE$")) {
            return new ExternalModuleStorage((Module)componentManager, storageManager);
        }
        Project project = (Project)componentManager;
        if (this.inProjectStateSpec == null) {
            return new ExternalProjectStorage(this.path, project, storageManager, "project");
        }
        DirectoryBasedStorage storage = (DirectoryBasedStorage)storageManager.getStateStorage(this.inProjectStateSpec.storages()[0]);
        return new ExternalProjectFilteringStorage(this.path, project, storageManager, this.inProjectStateSpec.name(), storage);
    }

    @NotNull
    public String getKey() {
        String string = "external//" + this.path;
        if (string == null) {
            ExternalStorageSpec.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/configurationStore/ExternalStorageSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/configurationStore/ExternalStorageSpec";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

