/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerExtension;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerView;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerVirtualFile;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "files", "Ljava/util/HashMap;", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerVirtualFile;", "Lkotlin/collections/HashMap;", "getOrCreate", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerView;", "systemId", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDependencyAnalyzerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyAnalyzerManager.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,40:1\n382#2,7:41\n*S KotlinDebug\n*F\n+ 1 DependencyAnalyzerManager.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager\n*L\n20#1:41,7\n*E\n"})
public final class DependencyAnalyzerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<ProjectSystemId, DependencyAnalyzerVirtualFile> files;

    public DependencyAnalyzerManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.files = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DependencyAnalyzerView getOrCreate(@NotNull ProjectSystemId systemId) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Map map = this.files;
        ProjectSystemId key$iv = systemId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Disposable disposable;
            DependencyAnalyzerVirtualFile dependencyAnalyzerVirtualFile;
            boolean bl = false;
            DependencyAnalyzerVirtualFile file = dependencyAnalyzerVirtualFile = new DependencyAnalyzerVirtualFile(this.project, systemId);
            boolean bl2 = false;
            Disposable extensionDisposable = disposable = DependencyAnalyzerExtension.Companion.createExtensionDisposable(systemId, (Disposable)this.project);
            boolean bl3 = false;
            DisposerUtilKt.whenDisposed((Disposable)extensionDisposable, () -> DependencyAnalyzerManager.getOrCreate$lambda$0$0$0$0(fileEditorManager, file, this, systemId));
            DependencyAnalyzerVirtualFile answer$iv = dependencyAnalyzerVirtualFile;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        DependencyAnalyzerVirtualFile file = (DependencyAnalyzerVirtualFile)((Object)object);
        fileEditorManager.openFile((VirtualFile)file, true, true);
        Object object2 = CollectionsKt.firstOrNull(file.getViews());
        if (object2 == null) {
            boolean bl = false;
            String string = "DependencyAnalyzerView should be created during file open";
            throw new IllegalArgumentException(string.toString());
        }
        return (DependencyAnalyzerView)object2;
    }

    private static final Unit getOrCreate$lambda$0$0$0$0(FileEditorManager $fileEditorManager, DependencyAnalyzerVirtualFile $file, DependencyAnalyzerManager this$0, ProjectSystemId $systemId) {
        $fileEditorManager.closeFile((VirtualFile)$file);
        this$0.files.remove($systemId);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final DependencyAnalyzerManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    @SourceDebugExtension(value={"SMAP\nDependencyAnalyzerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyAnalyzerManager.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,40:1\n30#2,2:41\n*S KotlinDebug\n*F\n+ 1 DependencyAnalyzerManager.kt\ncom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerManager$Companion\n*L\n38#1:41,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DependencyAnalyzerManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DependencyAnalyzerManager> serviceClass$iv = DependencyAnalyzerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DependencyAnalyzerManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

