/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.dependency.analyzer;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerOpenConfigAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/dependency/analyzer/ExternalSystemDependencyAnalyzerOpenConfigAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerOpenConfigAction;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "<init>", "(Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)V", "getExternalProjectPath", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.externalSystem.impl"})
public abstract class ExternalSystemDependencyAnalyzerOpenConfigAction
extends DependencyAnalyzerOpenConfigAction {
    public ExternalSystemDependencyAnalyzerOpenConfigAction(@NotNull ProjectSystemId systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        super(systemId);
    }

    @Nullable
    public abstract String getExternalProjectPath(@NotNull AnActionEvent var1);

    @Override
    @Nullable
    public VirtualFile getConfigFile(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = this.getExternalProjectPath(e);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fileSystem = localFileSystem;
        VirtualFile virtualFile = fileSystem.refreshAndFindFileByPath(externalProjectPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile externalProjectDirectory = virtualFile;
        ExternalSystemConfigLocator externalSystemConfigLocator = (ExternalSystemConfigLocator)ExternalSystemConfigLocator.EP_NAME.findFirstSafe(arg_0 -> ExternalSystemDependencyAnalyzerOpenConfigAction.getConfigFile$lambda$1(arg_0 -> ExternalSystemDependencyAnalyzerOpenConfigAction.getConfigFile$lambda$0(this, arg_0), arg_0));
        if (externalSystemConfigLocator == null) {
            return null;
        }
        ExternalSystemConfigLocator locator = externalSystemConfigLocator;
        VirtualFile virtualFile2 = locator.adjust(externalProjectDirectory);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile externalSystemConfigPath = virtualFile2;
        return externalSystemConfigPath.isDirectory() ? null : externalSystemConfigPath;
    }

    private static final boolean getConfigFile$lambda$0(ExternalSystemDependencyAnalyzerOpenConfigAction this$0, ExternalSystemConfigLocator it) {
        return Intrinsics.areEqual((Object)it.getTargetExternalSystemId(), (Object)this$0.getSystemId());
    }

    private static final boolean getConfigFile$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

