/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.remote.CustomClassDeserializingResolver;
import com.intellij.openapi.externalSystem.service.remote.RawExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016J\u001d\u0010\u000b\u001a\u00020\f2\u0012\b\u0001\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0096\u0001J'\u0010\u0011\u001a\u00020\f2\u0014\b\u0001\u0010\u0012\u001a\u000e\b\u00028\u0000\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0096\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0012\b\u0001\u0010\u0016\u001a\f0\u0017\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0096\u0001J!\u0010\u0018\u001a\u001a\u0012\f\u0012\n \u001a*\u0004\u0018\u00018\u00008\u00000\u0019\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0097\u0001J!\u0010\u001b\u001a\u001a\u0012\f\u0012\n \u001a*\u0004\u0018\u00018\u00008\u00000\u001c\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u0094\u0001\u0010\u001d\u001a\u008c\u0001\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001f0\u001f\u0012(\u0012&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00170\u0017 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00170\u0017\u0018\u00010!0  \u001a*D\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001f0\u001f\u0012(\u0012&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00170\u0017 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00170\u0017\u0018\u00010!0 0\"\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u00100\u001e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0097\u0001J\u001d\u0010#\u001a\u00020\u00152\u0012\b\u0001\u0010\u0016\u001a\f0\u0017\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0096\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/externalSystem/service/ResolverDeserializationWrapper;", "S", "Lcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;", "Lcom/intellij/openapi/externalSystem/service/RemoteExternalSystemFacade;", "delegate", "<init>", "(Lcom/intellij/openapi/externalSystem/service/RemoteExternalSystemFacade;)V", "getDelegate", "()Lcom/intellij/openapi/externalSystem/service/RemoteExternalSystemFacade;", "getResolver", "Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProjectResolver;", "applyProgressManager", "", "progressManager", "Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemProgressNotificationManager;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "applySettings", "settings", "(Lcom/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings;)V", "cancelTask", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getRawProjectResolver", "Lcom/intellij/openapi/externalSystem/service/remote/RawExternalSystemProjectResolver;", "kotlin.jvm.PlatformType", "getTaskManager", "Lcom/intellij/openapi/externalSystem/service/remote/RemoteExternalSystemTaskManager;", "getTasksInProgress", "", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskType;", "", "", "", "isTaskInProgress", "intellij.platform.externalSystem.impl"})
@ApiStatus.Internal
public final class ResolverDeserializationWrapper<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemFacade<S> {
    @NotNull
    private final RemoteExternalSystemFacade<S> delegate;

    public ResolverDeserializationWrapper(@NotNull RemoteExternalSystemFacade<S> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @NotNull
    public final RemoteExternalSystemFacade<S> getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() {
        RawExternalSystemProjectResolver<S> rawExternalSystemProjectResolver = this.delegate.getRawProjectResolver();
        Intrinsics.checkNotNullExpressionValue(rawExternalSystemProjectResolver, (String)"getRawProjectResolver(...)");
        RemoteExternalSystemProjectResolver<S> remoteExternalSystemProjectResolver = this.delegate.getResolver();
        Intrinsics.checkNotNullExpressionValue(remoteExternalSystemProjectResolver, (String)"getResolver(...)");
        return new CustomClassDeserializingResolver<S>(rawExternalSystemProjectResolver, remoteExternalSystemProjectResolver);
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() {
        RemoteExternalSystemTaskManager<S> remoteExternalSystemTaskManager = this.delegate.getTaskManager();
        Intrinsics.checkNotNullExpressionValue(remoteExternalSystemTaskManager, (String)"getTaskManager(...)");
        return remoteExternalSystemTaskManager;
    }

    @Override
    public void applySettings(@NotNull S settings) {
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        this.delegate.applySettings(settings);
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        this.delegate.applyProgressManager(progressManager);
    }

    @Override
    @NotNull
    public RawExternalSystemProjectResolver<S> getRawProjectResolver() {
        RawExternalSystemProjectResolver<S> rawExternalSystemProjectResolver = this.delegate.getRawProjectResolver();
        Intrinsics.checkNotNullExpressionValue(rawExternalSystemProjectResolver, (String)"getRawProjectResolver(...)");
        return rawExternalSystemProjectResolver;
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.delegate.isTaskInProgress(id);
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.delegate.cancelTask(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map = this.delegate.getTasksInProgress();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getTasksInProgress(...)");
        return map;
    }
}

