/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputMessageDispatcher;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000f2\u0010\u0010\u0015\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t0\bH\u0016J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H$J\u0006\u0010\u0018\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0006\u001a)\u0012 \u0012\u001e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t \n*\u000e\u0012\b\b\u0000\u0012\u0004\u0018\u00010\t\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher;", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemOutputMessageDispatcher;", "buildProgressListener", "Lcom/intellij/build/BuildProgressListener;", "<init>", "(Lcom/intellij/build/BuildProgressListener;)V", "onCompletionHandlers", "Lcom/intellij/util/containers/ConcurrentList;", "Ljava/util/function/Consumer;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isClosed", "", "onEvent", "", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "invokeOnCompletion", "handler", "closeAndGetFuture", "Ljava/util/concurrent/CompletableFuture;", "close", "Companion", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nAbstractOutputMessageDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractOutputMessageDispatcher.kt\ncom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n13#2:50\n*S KotlinDebug\n*F\n+ 1 AbstractOutputMessageDispatcher.kt\ncom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher\n*L\n47#1:50\n*E\n"})
public abstract class AbstractOutputMessageDispatcher
implements ExternalSystemOutputMessageDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BuildProgressListener buildProgressListener;
    @NotNull
    private final ConcurrentList<Consumer<? super Throwable>> onCompletionHandlers;
    private volatile boolean isClosed;
    @NotNull
    private static final Logger LOG;

    public AbstractOutputMessageDispatcher(@NotNull BuildProgressListener buildProgressListener) {
        Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
        this.buildProgressListener = buildProgressListener;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.onCompletionHandlers = concurrentList;
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof FinishBuildEvent) {
            this.invokeOnCompletion(arg_0 -> AbstractOutputMessageDispatcher.onEvent$lambda$0(this, buildId, event, arg_0));
        } else {
            this.buildProgressListener.onEvent(buildId, event);
        }
    }

    public void invokeOnCompletion(@NotNull Consumer<? super Throwable> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.isClosed) {
            LOG.warn("Attempt to add completion handler for closed output dispatcher, the handler will be ignored", LOG.isDebugEnabled() ? new Throwable() : null);
        } else {
            this.onCompletionHandlers.add(handler);
        }
    }

    @NotNull
    protected abstract CompletableFuture<?> closeAndGetFuture();

    public final void close() {
        CompletableFuture<?> future = this.closeAndGetFuture();
        this.isClosed = true;
        for (Consumer handler : CollectionsKt.asReversedMutable((List)((List)this.onCompletionHandlers))) {
            future.whenComplete((arg_0, arg_1) -> AbstractOutputMessageDispatcher.close$lambda$1((arg_0, arg_1) -> AbstractOutputMessageDispatcher.close$lambda$0(handler, arg_0, arg_1), arg_0, arg_1));
        }
        this.onCompletionHandlers.clear();
    }

    private static final void onEvent$lambda$0(AbstractOutputMessageDispatcher this$0, Object $buildId, BuildEvent $event, Throwable it) {
        this$0.buildProgressListener.onEvent($buildId, $event);
    }

    private static final Unit close$lambda$0(Consumer $handler, Object object, Throwable u) {
        $handler.accept(u);
        return Unit.INSTANCE;
    }

    private static final void close$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractOutputMessageDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

