/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemBeforeRunTask
extends BeforeRunTask<ExternalSystemBeforeRunTask> {
    @NotNull
    private final ExternalSystemTaskExecutionSettings myTaskExecutionSettings;

    public ExternalSystemBeforeRunTask(@NotNull Key<ExternalSystemBeforeRunTask> providerId, @NotNull ProjectSystemId systemId) {
        if (providerId == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(0);
        }
        if (systemId == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(1);
        }
        super(providerId);
        this.myTaskExecutionSettings = new ExternalSystemTaskExecutionSettings();
        this.myTaskExecutionSettings.setExternalSystemIdString(systemId.getId());
    }

    private ExternalSystemBeforeRunTask(@NotNull ExternalSystemBeforeRunTask source) {
        if (source == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(2);
        }
        super(source.myProviderId);
        this.myTaskExecutionSettings = source.myTaskExecutionSettings.clone();
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getTaskExecutionSettings() {
        ExternalSystemTaskExecutionSettings externalSystemTaskExecutionSettings = this.myTaskExecutionSettings;
        if (externalSystemTaskExecutionSettings == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(3);
        }
        return externalSystemTaskExecutionSettings;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        element.setAttribute("tasks", StringUtil.join((Collection)this.myTaskExecutionSettings.getTaskNames(), (String)" "));
        if (this.myTaskExecutionSettings.getExternalProjectPath() != null) {
            element.setAttribute("externalProjectPath", this.myTaskExecutionSettings.getExternalProjectPath());
        }
        if (this.myTaskExecutionSettings.getVmOptions() != null) {
            element.setAttribute("vmOptions", this.myTaskExecutionSettings.getVmOptions());
        }
        if (this.myTaskExecutionSettings.getScriptParameters() != null) {
            element.setAttribute("scriptParameters", this.myTaskExecutionSettings.getScriptParameters());
        }
        if (!this.myTaskExecutionSettings.getEnv().isEmpty()) {
            EnvironmentVariablesComponent.writeExternal((Element)element, (Map)this.myTaskExecutionSettings.getEnv());
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ExternalSystemBeforeRunTask.$$$reportNull$$$0(5);
        }
        super.readExternal(element);
        this.myTaskExecutionSettings.setTaskNames(StringUtil.split((String)StringUtil.notNullize((String)element.getAttributeValue("tasks")), (String)" "));
        this.myTaskExecutionSettings.setExternalProjectPath(element.getAttributeValue("externalProjectPath"));
        this.myTaskExecutionSettings.setVmOptions(element.getAttributeValue("vmOptions"));
        this.myTaskExecutionSettings.setScriptParameters(element.getAttributeValue("scriptParameters"));
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)this.myTaskExecutionSettings.getEnv());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalSystemBeforeRunTask)) {
            return false;
        }
        ExternalSystemBeforeRunTask task = (ExternalSystemBeforeRunTask)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return this.myTaskExecutionSettings.equals((Object)task.myTaskExecutionSettings);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myTaskExecutionSettings.hashCode();
        return result;
    }

    public BeforeRunTask clone() {
        return new ExternalSystemBeforeRunTask(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemBeforeRunTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskExecutionSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

