/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.execution.AbstractOutputMessageDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputDispatcherFactory;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputMessageDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001#B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u000f2\u0010\u0010\u0017\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00190\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000fH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher;", "Lcom/intellij/build/BuildEventDispatcher;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "progressListener", "Lcom/intellij/build/BuildProgressListener;", "appendOutputToMainConsole", "", "<init>", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/build/BuildProgressListener;Z)V", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/build/BuildProgressListener;)V", "outputMessageDispatcher", "Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemOutputMessageDispatcher;", "isStdOut", "setStdOut", "", "stdOut", "onEvent", "buildId", "", "event", "Lcom/intellij/build/events/BuildEvent;", "invokeOnCompletion", "consumer", "Ljava/util/function/Consumer;", "", "append", "csq", "", "start", "", "end", "c", "", "close", "DefaultOutputMessageDispatcher", "intellij.platform.externalSystem.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nExternalSystemEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemEventDispatcher.kt\ncom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,92:1\n13805#2,2:93\n13805#2,2:95\n*S KotlinDebug\n*F\n+ 1 ExternalSystemEventDispatcher.kt\ncom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher\n*L\n33#1:93,2\n40#1:95,2\n*E\n"})
public final class ExternalSystemEventDispatcher
implements BuildEventDispatcher {
    private ExternalSystemOutputMessageDispatcher outputMessageDispatcher;
    private boolean isStdOut;

    public ExternalSystemEventDispatcher(@NotNull ExternalSystemTaskId taskId, @Nullable BuildProgressListener progressListener, boolean appendOutputToMainConsole) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this.isStdOut = true;
        SmartList buildOutputParsers = new SmartList();
        if (progressListener != null) {
            Object[] $this$forEach$iv = ExternalSystemOutputParserProvider.EP_NAME.getExtensions();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Object element$iv = $this$forEach$iv[j];
                ExternalSystemOutputParserProvider it = (ExternalSystemOutputParserProvider)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)taskId.getProjectSystemId(), (Object)it.getExternalSystemId())) continue;
                buildOutputParsers.addAll((Collection)it.getBuildOutputParsers(taskId));
            }
            ExternalSystemOutputMessageDispatcher foundFactory = null;
            Object[] $this$forEach$iv2 = ExternalSystemOutputDispatcherFactory.Companion.getEP_NAME().getExtensions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                ExternalSystemOutputDispatcherFactory it = (ExternalSystemOutputDispatcherFactory)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)taskId.getProjectSystemId(), (Object)it.getExternalSystemId())) continue;
                if (foundFactory != null) {
                    throw new RuntimeException("'" + ExternalSystemOutputDispatcherFactory.Companion.getEP_NAME().getName() + "' extension should be one per external system");
                }
                foundFactory = it;
            }
            ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = foundFactory;
            if (externalSystemOutputMessageDispatcher == null || (externalSystemOutputMessageDispatcher = externalSystemOutputMessageDispatcher.create((Object)taskId, progressListener, appendOutputToMainConsole, (List)buildOutputParsers)) == null) {
                externalSystemOutputMessageDispatcher = new DefaultOutputMessageDispatcher(taskId, progressListener, (List)buildOutputParsers);
            }
            this.outputMessageDispatcher = externalSystemOutputMessageDispatcher;
        }
    }

    public ExternalSystemEventDispatcher(@NotNull ExternalSystemTaskId taskId, @Nullable BuildProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        this(taskId, progressListener, true);
    }

    public void setStdOut(boolean stdOut) {
        this.isStdOut = stdOut;
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.setStdOut(stdOut);
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.onEvent(buildId, event);
    }

    public void invokeOnCompletion(@NotNull Consumer<? super Throwable> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.invokeOnCompletion(consumer);
    }

    @NotNull
    public ExternalSystemEventDispatcher append(@NotNull CharSequence csq) {
        ExternalSystemEventDispatcher externalSystemEventDispatcher;
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        ExternalSystemEventDispatcher $this$append_u24lambda_u240 = externalSystemEventDispatcher = this;
        boolean bl = false;
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = $this$append_u24lambda_u240.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.append(csq);
        return externalSystemEventDispatcher;
    }

    @NotNull
    public ExternalSystemEventDispatcher append(@NotNull CharSequence csq, int start, int end) {
        ExternalSystemEventDispatcher externalSystemEventDispatcher;
        Intrinsics.checkNotNullParameter((Object)csq, (String)"csq");
        ExternalSystemEventDispatcher $this$append_u24lambda_u241 = externalSystemEventDispatcher = this;
        boolean bl = false;
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = $this$append_u24lambda_u241.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.append(csq, start, end);
        return externalSystemEventDispatcher;
    }

    @NotNull
    public ExternalSystemEventDispatcher append(char c) {
        ExternalSystemEventDispatcher externalSystemEventDispatcher;
        ExternalSystemEventDispatcher $this$append_u24lambda_u242 = externalSystemEventDispatcher = this;
        boolean bl = false;
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = $this$append_u24lambda_u242.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.append(c);
        return externalSystemEventDispatcher;
    }

    public void close() {
        ExternalSystemOutputMessageDispatcher externalSystemOutputMessageDispatcher = this.outputMessageDispatcher;
        if (externalSystemOutputMessageDispatcher == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputMessageDispatcher");
            externalSystemOutputMessageDispatcher = null;
        }
        externalSystemOutputMessageDispatcher.close();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\b\u0010\u000fJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J!\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00020\u00022\u000e\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001e0\u001eH\u0096\u0001J\u0019\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001fH\u0096\u0001J1\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\u00020\u00022\u000e\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001e0\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0096\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/externalSystem/service/execution/ExternalSystemEventDispatcher$DefaultOutputMessageDispatcher;", "Lcom/intellij/openapi/externalSystem/service/execution/AbstractOutputMessageDispatcher;", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "buildProgressListener", "Lcom/intellij/build/BuildProgressListener;", "outputReader", "Lcom/intellij/build/output/BuildOutputInstantReaderImpl;", "<init>", "(Lcom/intellij/build/BuildProgressListener;Lcom/intellij/build/output/BuildOutputInstantReaderImpl;)V", "buildId", "", "parsers", "", "Lcom/intellij/build/output/BuildOutputParser;", "(Ljava/lang/Object;Lcom/intellij/build/BuildProgressListener;Ljava/util/List;)V", "getOutputReader", "()Lcom/intellij/build/output/BuildOutputInstantReaderImpl;", "stdOut", "", "getStdOut", "()Z", "setStdOut", "(Z)V", "closeAndGetFuture", "Ljava/util/concurrent/CompletableFuture;", "", "append", "kotlin.jvm.PlatformType", "p0", "", "", "p1", "", "p2", "intellij.platform.externalSystem.impl"})
    private static final class DefaultOutputMessageDispatcher
    extends AbstractOutputMessageDispatcher
    implements Appendable {
        @NotNull
        private final BuildOutputInstantReaderImpl outputReader;
        private boolean stdOut;

        public DefaultOutputMessageDispatcher(@NotNull BuildProgressListener buildProgressListener, @NotNull BuildOutputInstantReaderImpl outputReader) {
            Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
            Intrinsics.checkNotNullParameter((Object)outputReader, (String)"outputReader");
            super(buildProgressListener);
            this.outputReader = outputReader;
            this.stdOut = true;
        }

        @NotNull
        public final BuildOutputInstantReaderImpl getOutputReader() {
            return this.outputReader;
        }

        public DefaultOutputMessageDispatcher(@NotNull Object buildId, @NotNull BuildProgressListener buildProgressListener, @NotNull List<? extends BuildOutputParser> parsers) {
            Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
            Intrinsics.checkNotNullParameter((Object)buildProgressListener, (String)"buildProgressListener");
            Intrinsics.checkNotNullParameter(parsers, (String)"parsers");
            this(buildProgressListener, new BuildOutputInstantReaderImpl(buildId, buildId, buildProgressListener, parsers, 0, 0, 48, null));
        }

        public boolean getStdOut() {
            return this.stdOut;
        }

        public void setStdOut(boolean bl) {
            this.stdOut = bl;
        }

        @NotNull
        protected CompletableFuture<Unit> closeAndGetFuture() {
            return this.outputReader.closeAndGetFuture();
        }

        @Override
        public Appendable append(CharSequence p0) {
            return (Appendable)this.outputReader.append(p0);
        }

        @Override
        public Appendable append(CharSequence p0, int p1, int p2) {
            return (Appendable)this.outputReader.append(p0, p1, p2);
        }

        @Override
        public Appendable append(char p0) {
            return (Appendable)this.outputReader.append(p0);
        }
    }
}

