/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkException;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.InvalidJavaHomeException;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.externalSystem.service.execution.ProjectJdkNotFoundException;
import com.intellij.openapi.externalSystem.service.execution.UndefinedJavaHomeException;
import com.intellij.openapi.externalSystem.util.environment.Environment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.DependentSdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkLookupDecision;
import com.intellij.openapi.roots.ui.configuration.SdkLookupUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.SdkDownloadTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public final class ExternalSystemJdkUtil {
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String USE_INTERNAL_JAVA = "#JAVA_INTERNAL";
    public static final String USE_PROJECT_JDK = "#USE_PROJECT_JDK";
    public static final String USE_JAVA_HOME = "#JAVA_HOME";

    @Contract(value="_, null -> null")
    @Nullable
    public static Sdk getJdk(@Nullable Project project, @Nullable String jdkName) throws ExternalSystemJdkException {
        return ExternalSystemJdkUtil.resolveJdkName(ExternalSystemJdkUtil.getProjectJdk(project), jdkName);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static Sdk resolveJdkName(@Nullable Sdk projectSdk, @Nullable String jdkName) throws ExternalSystemJdkException {
        String string = jdkName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{USE_INTERNAL_JAVA, USE_PROJECT_JDK, USE_JAVA_HOME}, (Object)string, n)) {
            case -1 -> null;
            case 0 -> ExternalSystemJdkUtil.getInternalJdk();
            case 1 -> {
                if (projectSdk == null) {
                    throw new ProjectJdkNotFoundException();
                }
                yield ExternalSystemJdkUtil.resolveDependentJdk(projectSdk);
            }
            case 2 -> ExternalSystemJdkUtil.getJavaHomeJdk();
            default -> ExternalSystemJdkUtil.getJdk(jdkName);
        };
    }

    @NotNull
    private static Sdk getProjectJdk(@Nullable Project project) {
        if (project != null) {
            Module[] modules;
            Sdk res = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (res != null) {
                Sdk sdk = res;
                if (sdk == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(0);
                }
                return sdk;
            }
            for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) continue;
                Sdk sdk2 = sdk;
                if (sdk2 == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(1);
                }
                return sdk2;
            }
        }
        SdkType jdkType = ExternalSystemJdkUtil.getJavaSdkType();
        Sdk sdk = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)jdkType).stream().filter(it -> ExternalSystemJdkUtil.isValidJdk(it)).max(jdkType.versionComparator()).orElseGet(ExternalSystemJdkUtil::getInternalJdk);
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(2);
        }
        return sdk;
    }

    @NotNull
    private static Sdk getJavaHomeJdk() {
        String javaHome = ExternalSystemJdkUtil.getJavaHome();
        if (StringUtil.isEmptyOrSpaces((String)javaHome)) {
            throw new UndefinedJavaHomeException();
        }
        if (!ExternalSystemJdkUtil.isValidJdk(javaHome)) {
            throw new InvalidJavaHomeException(javaHome);
        }
        Sdk sdk = ExternalSystemJdkProvider.getInstance().createJdk(null, javaHome);
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    @Nullable
    public static String getJavaHome() {
        return Environment.getVariable(JAVA_HOME);
    }

    @Nullable
    private static Sdk getJdk(@NotNull String jdkName) {
        Sdk jdk;
        if (jdkName == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(4);
        }
        if ((jdk = ProjectJdkTable.getInstance().findJdk(jdkName)) == null) {
            return null;
        }
        String homePath = jdk.getHomePath();
        if (!ExternalSystemJdkUtil.isValidJdk(jdk)) {
            throw new InvalidSdkException(homePath);
        }
        return jdk;
    }

    @NotNull
    public static Pair<String, Sdk> getAvailableJdk(@Nullable Project project) throws ExternalSystemJdkException {
        String javaHome;
        List allJdks;
        Sdk mostRecentSdk;
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        if (project != null) {
            Sdk projectJdk = ExternalSystemJdkUtil.findProjectJDK(project, javaSdkType);
            if (projectJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)projectJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(5);
                }
                return pair;
            }
            Sdk referencedJdk = ExternalSystemJdkUtil.findReferencedJdk(project);
            if (referencedJdk != null) {
                Pair pair = Pair.pair((Object)USE_PROJECT_JDK, (Object)referencedJdk);
                if (pair == null) {
                    ExternalSystemJdkUtil.$$$reportNull$$$0(6);
                }
                return pair;
            }
        }
        if ((mostRecentSdk = (Sdk)(allJdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdkType)).stream().filter(sdk -> ExternalSystemJdkUtil.isValidJdk(sdk)).max(javaSdkType.versionComparator()).orElse(null)) != null) {
            Pair pair = Pair.pair((Object)mostRecentSdk.getName(), (Object)mostRecentSdk);
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(7);
            }
            return pair;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && ExternalSystemJdkUtil.isValidJdk(javaHome = ExternalSystemJdkUtil.getJavaHome())) {
            SimpleJavaSdkType simpleJavaSdkType = SimpleJavaSdkType.getInstance();
            String sdkName = simpleJavaSdkType.suggestSdkName(null, javaHome);
            Pair pair = Pair.pair((Object)USE_JAVA_HOME, (Object)simpleJavaSdkType.createJdk(sdkName, javaHome));
            if (pair == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(8);
            }
            return pair;
        }
        Pair pair = Pair.pair((Object)USE_INTERNAL_JAVA, (Object)ExternalSystemJdkUtil.getInternalJdk());
        if (pair == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(9);
        }
        return pair;
    }

    private static Sdk findProjectJDK(@NotNull Project project, SdkType javaSdkType) {
        if (project == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(10);
        }
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        Stream<Sdk> projectSdks = Stream.concat(Stream.of(projectSdk), Stream.of(ModuleManager.getInstance((Project)project).getModules()).map(module -> ModuleRootManager.getInstance((Module)module).getSdk()));
        return projectSdks.filter(sdk -> sdk != null && sdk.getSdkType() == javaSdkType && ExternalSystemJdkUtil.isValidJdk(sdk) && JdkUtil.isCompatible((Sdk)sdk, (Project)project)).findFirst().orElse(null);
    }

    @Contract(value="null -> null")
    @Nullable
    private static Sdk findReferencedJdk(Sdk projectSdk) {
        SdkTypeId sdkTypeId;
        if (projectSdk != null && projectSdk.getSdkType() instanceof DependentSdkType && (sdkTypeId = projectSdk.getSdkType()) instanceof JavaSdkType) {
            JavaSdkType sdkType = (JavaSdkType)sdkTypeId;
            String sdkBinPath = sdkType.getBinPath(projectSdk);
            if (sdkBinPath == null) {
                return null;
            }
            String jdkPath = FileUtil.toSystemIndependentName((String)new File(sdkBinPath).getParent());
            return (Sdk)ContainerUtil.find((Object[])ProjectJdkTable.getInstance().getAllJdks(), sdk -> {
                String homePath = sdk.getHomePath();
                return homePath != null && FileUtil.toSystemIndependentName((String)homePath).equals(jdkPath);
            });
        }
        return null;
    }

    @Nullable
    private static Sdk findReferencedJdk(Project project) {
        Sdk projectSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return ExternalSystemJdkUtil.findReferencedJdk(projectSdk);
    }

    @NotNull
    public static Sdk resolveDependentJdk(@NotNull Sdk sdk) {
        Sdk parentSdk;
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(11);
        }
        if ((parentSdk = ExternalSystemJdkUtil.findReferencedJdk(sdk)) == null) {
            Sdk sdk2 = sdk;
            if (sdk2 == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(12);
            }
            return sdk2;
        }
        Sdk sdk3 = parentSdk;
        if (sdk3 == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(13);
        }
        return sdk3;
    }

    @Deprecated
    @NotNull
    public static Collection<String> suggestJdkHomePaths() {
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths();
        if (collection == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> suggestJdkHomePaths(@NotNull Project project) {
        if (project == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(15);
        }
        Collection collection = ExternalSystemJdkUtil.getJavaSdkType().suggestHomePaths(project);
        if (collection == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static SdkType getJavaSdkType() {
        SdkType sdkType = ExternalSystemJdkProvider.getInstance().getJavaSdkType();
        if (sdkType == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(17);
        }
        return sdkType;
    }

    @Nullable
    public static JavaVersion getJavaVersion(@NotNull String javaHome) {
        if (javaHome == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(18);
        }
        SdkType javaSdkType = ExternalSystemJdkUtil.getJavaSdkType();
        String javaVersionString = javaSdkType.getVersionString(javaHome);
        return JavaVersion.tryParse((String)javaVersionString);
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdkType)) {
            return false;
        }
        if (SdkDownloadTracker.getInstance().isDownloading(jdk)) {
            return true;
        }
        return ExternalSystemJdkUtil.isValidJdk(jdk.getHomePath());
    }

    @Contract(value="null -> false")
    public static boolean isValidJdk(@Nullable String homePath) {
        if (StringUtil.isEmptyOrSpaces((String)homePath)) {
            return false;
        }
        try {
            Path path = Path.of(homePath, new String[0]);
            return JdkUtil.checkForJdk((Path)path) && JdkUtil.checkForJre((String)homePath);
        }
        catch (InvalidPathException exception) {
            return false;
        }
    }

    @NotNull
    public static Sdk addJdk(@NotNull String homePath) {
        if (homePath == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(19);
        }
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        List<Sdk> sdks = Arrays.asList(ProjectJdkTable.getInstance().getAllJdks());
        String name = SdkConfigurationUtil.createUniqueSdkName((SdkType)jdkProvider.getJavaSdkType(), (String)homePath, sdks);
        Sdk jdk = jdkProvider.createJdk(name, homePath);
        SdkConfigurationUtil.addSdk((Sdk)jdk);
        Sdk sdk = jdk;
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(20);
        }
        return sdk;
    }

    @NotNull
    private static Sdk getInternalJdk() {
        Sdk sdk = ExternalSystemJdkProvider.getInstance().getInternalJdk();
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(21);
        }
        return sdk;
    }

    @Contract(value="null -> false")
    public static boolean isJdk9orLater(@Nullable String javaHome) {
        JdkVersionDetector.JdkVersionInfo jdkVersionInfo = javaHome == null ? null : JdkVersionDetector.getInstance().detectJdkVersionInfo(javaHome);
        return jdkVersionInfo != null && jdkVersionInfo.version.isAtLeast(9);
    }

    @ApiStatus.Internal
    @Nullable
    public static Sdk lookupJdkByName(@NotNull String sdkName, @Nullable EelDescriptor eel) {
        if (sdkName == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(22);
        }
        return SdkLookupUtil.lookupSdkBlocking(builder -> {
            if (eel != null) {
                builder = builder.withEel(eel);
            }
            return builder.withSdkName(sdkName).withSdkType(ExternalSystemJdkUtil.getJavaSdkType()).onDownloadableSdkSuggested(__ -> SdkLookupDecision.STOP);
        });
    }

    @ApiStatus.Internal
    @Nullable
    public static Sdk lookupJdkByVersion(@NotNull JavaVersion javaVersion, @Nullable EelDescriptor eel) {
        if (javaVersion == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(23);
        }
        return SdkLookupUtil.lookupSdkBlocking(builder -> {
            if (eel != null) {
                builder = builder.withEel(eel);
            }
            return builder.withVersionFilter(it -> ExternalSystemJdkUtil.matchJavaVersion(javaVersion, it)).withSdkType(ExternalSystemJdkUtil.getJavaSdkType()).onDownloadableSdkSuggested(__ -> SdkLookupDecision.STOP);
        });
    }

    @ApiStatus.Internal
    @NotNull
    public static Sdk lookupJdkByPath(@NotNull String sdkHome) {
        Sdk jdk;
        if (sdkHome == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(24);
        }
        if ((jdk = ExternalSystemJdkUtil.findJdkInSdkTableByPath(sdkHome)) != null) {
            Sdk sdk = jdk;
            if (sdk == null) {
                ExternalSystemJdkUtil.$$$reportNull$$$0(25);
            }
            return sdk;
        }
        Sdk sdk = (Sdk)WriteAction.computeAndWait(() -> {
            Sdk effectiveJdk = ExternalSystemJdkUtil.findJdkInSdkTableByPath(sdkHome);
            if (effectiveJdk != null) {
                return effectiveJdk;
            }
            return ExternalSystemJdkUtil.createJdk(sdkHome);
        });
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(26);
        }
        return sdk;
    }

    @ApiStatus.Internal
    public static boolean matchJavaVersion(@NotNull JavaVersion versionRequirement, @Nullable String versionString) {
        JavaVersion version;
        if (versionRequirement == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(27);
        }
        return (version = JavaVersion.tryParse((String)versionString)) != null && version.compareTo(versionRequirement) >= 0 && version.feature == versionRequirement.feature;
    }

    @RequiresWriteLock
    @NotNull
    private static Sdk createJdk(@NotNull String sdkHome) {
        if (sdkHome == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.assertWriteAccess();
        ProjectJdkTable sdkTable = ProjectJdkTable.getInstance();
        ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
        SdkType jdkType = jdkProvider.getJavaSdkType();
        String jdkName = jdkType.suggestSdkName(null, sdkHome);
        List allJdks = sdkTable.getSdksOfType((SdkTypeId)ExternalSystemJdkUtil.getJavaSdkType());
        String uniqueJdkName = SdkConfigurationUtil.createUniqueSdkName((String)jdkName, (Collection)allJdks);
        Sdk jdk = jdkProvider.createJdk(uniqueJdkName, sdkHome);
        sdkTable.addJdk(jdk);
        Sdk sdk = jdk;
        if (sdk == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(29);
        }
        return sdk;
    }

    @ApiStatus.Internal
    @Nullable
    public static Sdk findJdkInSdkTableByPath(@NotNull String jdkHome) {
        if (jdkHome == null) {
            ExternalSystemJdkUtil.$$$reportNull$$$0(30);
        }
        ProjectJdkTable sdkTable = ProjectJdkTable.getInstance();
        List allJdks = sdkTable.getSdksOfType((SdkTypeId)ExternalSystemJdkUtil.getJavaSdkType());
        return (Sdk)ContainerUtil.find((Iterable)allJdks, it -> FileUtil.pathsEqual((String)jdkHome, (String)it.getHomePath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 10, 11, 15, 18, 19, 22, 23, 24, 27, 28, 30 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkName";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaHome";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaVersion";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRequirement";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectJdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaHomeJdk";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ExternalSystemJdkUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableJdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDependentJdk";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestJdkHomePaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaSdkType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalJdk";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupJdkByPath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createJdk";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJdk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProjectJDK";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependentJdk";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "suggestJdkHomePaths";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJavaVersion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lookupJdkByName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lookupJdkByVersion";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lookupJdkByPath";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchJavaVersion";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findJdkInSdkTableByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 10, 11, 15, 18, 19, 22, 23, 24, 27, 28, 30 -> new IllegalArgumentException(string);
        };
    }
}

