/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution.cmd;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.util.TextFieldCompletionProvider;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;

public abstract class CommandLineCompletionProvider
extends TextFieldCompletionProvider {
    private final Options myOptions;

    public CommandLineCompletionProvider(Options options2) {
        super(true);
        this.myOptions = options2;
    }

    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(0);
        }
        ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
        while (lexer.nextToken()) {
            if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
            String string = lexer.getCurrentToken();
            if (string == null) {
                CommandLineCompletionProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    protected LookupElement createLookupElement(@NotNull Option option, @NotNull String text) {
        if (option == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(2);
        }
        if (text == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(3);
        }
        LookupElementBuilder res = LookupElementBuilder.create((String)text);
        if (option.getDescription() != null) {
            return TailTypeDecorator.withTail((LookupElement)res.withTypeText(option.getDescription(), true), (TailType)TailTypes.insertSpaceType());
        }
        return res;
    }

    protected abstract void addArgumentVariants(@NotNull CompletionResultSet var1);

    protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
        if (text == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(5);
        }
        if (result == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(6);
        }
        ParametersListLexer lexer = new ParametersListLexer(text);
        int argCount = 0;
        while (lexer.nextToken() && offset >= lexer.getTokenStart()) {
            Option option2;
            if (offset <= lexer.getTokenEnd()) {
                if (argCount == 0) {
                    if (prefix.startsWith("--")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getLongOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "--" + option2.getLongOpt()));
                        }
                    } else if (prefix.startsWith("-")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getOpt() == null) continue;
                            result.addElement(this.createLookupElement(option2, "-" + option2.getOpt()));
                        }
                    } else {
                        this.addArgumentVariants(result);
                    }
                }
                return;
            }
            if (argCount > 0) {
                --argCount;
                continue;
            }
            String token = lexer.getCurrentToken();
            if (!token.startsWith("-") || (option2 = this.myOptions.getOption(token)) == null) continue;
            int optionArgCount = option2.getArgs();
            if (optionArgCount == -2) {
                argCount = Integer.MAX_VALUE;
                continue;
            }
            if (optionArgCount == -1) continue;
            argCount = optionArgCount;
        }
        if (argCount > 0) {
            return;
        }
        this.addArgumentVariants(result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTextPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/cmd/CommandLineCompletionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/cmd/CommandLineCompletionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariants";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

