/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ModifiableModel;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeModifiableModelsProvider
extends IdeModelsProviderImpl
implements IdeModifiableModelsProvider {
    private static final Logger LOG = Logger.getInstance(AbstractIdeModifiableModelsProvider.class);
    protected ModifiableModuleModel myModifiableModuleModel;
    protected final Map<Module, ModifiableRootModel> myModifiableRootModels;
    protected final Map<Module, ModifiableFacetModel> myModifiableFacetModels;
    protected final Map<Module, String> myProductionModulesForTestModules;
    protected final Map<Library, Library.ModifiableModel> myModifiableLibraryModels;
    protected final ClassMap<ModifiableModel> myModifiableModels;
    protected final MyUserDataHolderBase myUserData;
    private volatile boolean myDisposed;

    public AbstractIdeModifiableModelsProvider(@NotNull Project project) {
        if (project == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModifiableRootModels = new HashMap<Module, ModifiableRootModel>();
        this.myModifiableFacetModels = new HashMap<Module, ModifiableFacetModel>();
        this.myProductionModulesForTestModules = new HashMap<Module, String>();
        this.myModifiableLibraryModels = new IdentityHashMap<Library, Library.ModifiableModel>();
        this.myModifiableModels = new ClassMap();
        this.myUserData = new MyUserDataHolderBase();
        EP_NAME.forEachExtensionSafe(extension -> {
            Pair pair = extension.create(project, (IdeModifiableModelsProvider)this);
            this.myModifiableModels.put((Class)pair.first, (Object)((ModifiableModel)pair.second));
        });
    }

    @Nullable
    public <T extends ModifiableModel> T findModifiableModel(@NotNull Class<T> instanceOf) {
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(1);
        }
        return (T)((ModifiableModel)ObjectUtils.tryCast((Object)this.myModifiableModels.get(instanceOf), instanceOf));
    }

    @NotNull
    public <T extends ModifiableModel> T getModifiableModel(@NotNull Class<T> instanceOf) {
        ModifiableModel model;
        if (instanceOf == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(2);
        }
        if (instanceOf.isInstance(model = (ModifiableModel)this.myModifiableModels.get(instanceOf))) {
            ModifiableModel modifiableModel = (ModifiableModel)instanceOf.cast(model);
            if (modifiableModel == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(3);
            }
            return (T)modifiableModel;
        }
        throw new AssertionError((Object)String.format("Unable to get `%s` model", instanceOf.getSimpleName()));
    }

    protected abstract ModifiableModuleModel doGetModifiableModuleModel();

    protected abstract ModifiableRootModel doGetModifiableRootModel(Module var1);

    protected abstract ModifiableFacetModel doGetModifiableFacetModel(Module var1);

    protected abstract Library.ModifiableModel doGetModifiableLibraryModel(Library var1);

    @NotNull
    public abstract LibraryTable.ModifiableModel getModifiableProjectLibrariesModel();

    @Override
    public Module @NotNull [] getModules() {
        Module[] moduleArray = this.getModifiableModuleModel().getModules();
        if (moduleArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(4);
        }
        return moduleArray;
    }

    @Override
    public OrderEntry @NotNull [] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(5);
        }
        OrderEntry[] orderEntryArray = this.getRootModel(module).getOrderEntries();
        if (orderEntryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(6);
        }
        return orderEntryArray;
    }

    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(7);
        }
        Module module = this.getModifiableModuleModel().newModule(filePath, moduleTypeId);
        String moduleName = FileUtilRt.getNameWithoutExtension((String)new File(filePath).getName());
        if (!module.getName().equals(moduleName)) {
            try {
                this.getModifiableModuleModel().renameModule(module, moduleName);
            }
            catch (ModuleWithNameAlreadyExists exists) {
                LOG.warn((Throwable)exists);
            }
        }
        module.setModuleType(moduleTypeId);
        Module module2 = module;
        if (module2 == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(8);
        }
        return module2;
    }

    @NotNull
    public Module newModule(@NotNull ModuleData moduleData) {
        if (moduleData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(9);
        }
        String imlName = null;
        for (String candidate : this.suggestModuleNameCandidates(moduleData)) {
            Module module = this.findIdeModule(candidate);
            if (module != null) continue;
            imlName = candidate;
            break;
        }
        assert (imlName != null) : "Too many duplicated module names";
        String filePath = ExternalSystemApiUtil.toCanonicalPath((String)(moduleData.getModuleFileDirectoryPath() + "/" + imlName + ".iml"));
        Module module = this.newModule(filePath, moduleData.getModuleTypeId());
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(10);
        }
        return module;
    }

    @Override
    @Nullable
    public Module findIdeModule(@NotNull String ideModuleName) {
        Module module;
        if (ideModuleName == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(11);
        }
        return (module = this.getModifiableModuleModel().findModuleByName(ideModuleName)) == null ? this.getModifiableModuleModel().getModuleToBeRenamed(ideModuleName) : module;
    }

    @Override
    @Nullable
    public Library findIdeLibrary(@NotNull LibraryData libraryData) {
        if (libraryData == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(12);
        }
        LibraryTable.ModifiableModel libraryTable = this.getModifiableProjectLibrariesModel();
        for (Library ideLibrary : libraryTable.getLibraries()) {
            if (!ExternalSystemApiUtil.isRelated((Library)ideLibrary, (LibraryData)libraryData)) continue;
            return ideLibrary;
        }
        return null;
    }

    @Override
    public VirtualFile @NotNull [] getContentRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getContentRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(13);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots();
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(14);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getSourceRoots(Module module, boolean includingTests) {
        VirtualFile[] virtualFileArray = this.getRootModel(module).getSourceRoots(includingTests);
        if (virtualFileArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    @NotNull
    public ModifiableModuleModel getModifiableModuleModel() {
        if (this.myModifiableModuleModel == null) {
            this.myModifiableModuleModel = this.doGetModifiableModuleModel();
        }
        ModifiableModuleModel modifiableModuleModel = this.myModifiableModuleModel;
        if (modifiableModuleModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(16);
        }
        return modifiableModuleModel;
    }

    @NotNull
    public ModifiableRootModel getModifiableRootModel(Module module) {
        return (ModifiableRootModel)this.getRootModel(module);
    }

    @NotNull
    private ModuleRootModel getRootModel(Module module) {
        ModuleRootModel moduleRootModel = (ModuleRootModel)this.myModifiableRootModels.computeIfAbsent(module, k -> this.doGetModifiableRootModel(module));
        if (moduleRootModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(17);
        }
        return moduleRootModel;
    }

    @NotNull
    public ModifiableFacetModel getModifiableFacetModel(Module module) {
        ModifiableFacetModel modifiableFacetModel = this.myModifiableFacetModels.computeIfAbsent(module, k -> this.doGetModifiableFacetModel(module));
        if (modifiableFacetModel == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(18);
        }
        return modifiableFacetModel;
    }

    @Override
    public Library @NotNull [] getAllLibraries() {
        Library[] libraryArray = this.getModifiableProjectLibrariesModel().getLibraries();
        if (libraryArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(19);
        }
        return libraryArray;
    }

    @Override
    @Nullable
    public Library getLibraryByName(String name) {
        return this.getModifiableProjectLibrariesModel().getLibraryByName(name);
    }

    public Library createLibrary(String name) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name);
    }

    public Library createLibrary(String name, @Nullable ProjectModelExternalSource externalSource) {
        return this.getModifiableProjectLibrariesModel().createLibrary(name, null, externalSource);
    }

    public void removeLibrary(Library library) {
        this.getModifiableProjectLibrariesModel().removeLibrary(library);
    }

    public Library.ModifiableModel getModifiableLibraryModel(Library library) {
        return this.myModifiableLibraryModels.computeIfAbsent(library, k -> this.doGetModifiableLibraryModel(library));
    }

    @Override
    public String @NotNull [] getLibraryUrls(@NotNull Library library, @NotNull OrderRootType type) {
        Library.ModifiableModel model;
        if (library == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(20);
        }
        if (type == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(21);
        }
        if ((model = this.myModifiableLibraryModels.get(library)) != null) {
            String[] stringArray = model.getUrls(type);
            if (stringArray == null) {
                AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(22);
            }
            return stringArray;
        }
        String[] stringArray = library.getUrls(type);
        if (stringArray == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.nonModal();
    }

    @Override
    @NotNull
    public List<Module> getAllDependentModules(@NotNull Module module) {
        if (module == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(24);
        }
        ArrayList<Module> list = new ArrayList<Module>();
        Graph<Module> graph = this.getModuleGraph();
        Iterator i2 = graph.getOut((Object)module);
        while (i2.hasNext()) {
            list.add((Module)i2.next());
        }
        ArrayList<Module> arrayList = list;
        if (arrayList == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private Graph<Module> getModuleGraph() {
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            @NotNull
            public Collection<Module> getNodes() {
                List<Module> list = Arrays.asList(AbstractIdeModifiableModelsProvider.this.getModules());
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @NotNull
            public Iterator<Module> getIn(Module m) {
                Module[] dependentModules = AbstractIdeModifiableModelsProvider.this.getModifiableRootModel(m).getModuleDependencies(true);
                Iterator<Module> iterator = Arrays.asList(dependentModules).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(1);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodes";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIn";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }));
    }

    public void dispose() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        assert (!this.myDisposed) : "Already disposed!";
        this.myDisposed = true;
        for (ModifiableRootModel modifiableRootModel : this.myModifiableRootModels.values()) {
            if (modifiableRootModel.isDisposed()) continue;
            modifiableRootModel.dispose();
        }
        Disposer.dispose((Disposable)this.getModifiableProjectLibrariesModel());
        for (Library.ModifiableModel modifiableModel : this.myModifiableLibraryModels.values()) {
            if (modifiableModel instanceof LibraryEx && ((LibraryEx)modifiableModel).isDisposed()) continue;
            Disposer.dispose((Disposable)modifiableModel);
        }
        if (this.myModifiableModuleModel != null && this.myModifiableModuleModel.isChanged()) {
            this.myModifiableModuleModel.dispose();
        }
        this.myModifiableModels.values().forEach(ModifiableModel::dispose);
        this.myModifiableRootModels.clear();
        this.myModifiableFacetModels.clear();
        this.myModifiableLibraryModels.clear();
        this.myUserData.clear();
    }

    public void setTestModuleProperties(Module testModule, String productionModuleName) {
        this.myProductionModulesForTestModules.put(testModule, productionModuleName);
    }

    @Nullable
    public String getProductionModuleName(Module module) {
        return this.myProductionModulesForTestModules.get(module);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(26);
        }
        return (T)this.myUserData.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            AbstractIdeModifiableModelsProvider.$$$reportNull$$$0(27);
        }
        this.myUserData.putUserData(key, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 10, 13, 14, 15, 16, 17, 18, 19, 22, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModuleName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/AbstractIdeModifiableModelsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModuleModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableFacetModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibraries";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryUrls";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findModifiableModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModel";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findIdeModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findIdeLibrary";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryUrls";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 10, 13, 14, 15, 16, 17, 18, 19, 22, 23, 25 -> new IllegalStateException(string);
        };
    }

    protected static class MyUserDataHolderBase
    extends UserDataHolderBase {
        protected MyUserDataHolderBase() {
        }

        void clear() {
            this.clearUserData();
        }
    }
}

