/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0007J$\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JU\u0010\u0014\u001a\u0002H\u0015\"\b\b\u0000\u0010\u0016*\u00020\u0017\"\u0004\b\u0001\u0010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u0002H\u00162\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00060\u00052\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u00150\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cRU\u0010\u0004\u001aI\u0012@\u0012>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\u0007 \u000b*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemModuleDataIndex;", "", "<init>", "()V", "MODULE_NODE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "findModuleNode", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "modulePath", "collectAllModuleNodes", "getDataStorageCachedValue", "T", "H", "Lcom/intellij/openapi/util/UserDataHolder;", "dataHolder", "key", "createValue", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/UserDataHolder;Lcom/intellij/openapi/util/Key;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemModuleDataIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemModuleDataIndex.kt\ncom/intellij/openapi/externalSystem/service/project/ExternalSystemModuleDataIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1208#2,2:56\n1236#2,4:58\n1617#2,9:62\n1869#2:71\n1870#2:73\n1626#2:74\n1460#2,5:75\n1#3:72\n*S KotlinDebug\n*F\n+ 1 ExternalSystemModuleDataIndex.kt\ncom/intellij/openapi/externalSystem/service/project/ExternalSystemModuleDataIndex\n*L\n46#1:56,2\n46#1:58,4\n43#1:62,9\n43#1:71\n43#1:73\n43#1:74\n44#1:75,5\n43#1:72\n*E\n"})
public final class ExternalSystemModuleDataIndex {
    @NotNull
    public static final ExternalSystemModuleDataIndex INSTANCE = new ExternalSystemModuleDataIndex();
    @NotNull
    private static final Key<CachedValue<Map<String, DataNode<? extends ModuleData>>>> MODULE_NODE_KEY;

    private ExternalSystemModuleDataIndex() {
    }

    @JvmStatic
    @Nullable
    public static final DataNode<? extends ModuleData> findModuleNode(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (ExternalSystemApiUtil.getExternalRootProjectPath((Module)module) == null) {
            return null;
        }
        if (ExternalSystemApiUtil.getExternalProjectId((Module)module) == null) {
            return null;
        }
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ExternalSystemModuleDataIndex.findModuleNode(project, externalProjectPath);
    }

    @JvmStatic
    @Nullable
    public static final DataNode<? extends ModuleData> findModuleNode(@NotNull Project project, @NotNull String modulePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Map<String, DataNode<? extends ModuleData>> cache2 = INSTANCE.getDataStorageCachedValue(project, (UserDataHolder)project, MODULE_NODE_KEY, (Function1)new Function1<Project, Map<String, ? extends DataNode<? extends ModuleData>>>((Object)INSTANCE){

            public final Map<String, DataNode<? extends ModuleData>> invoke(Project p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ExternalSystemModuleDataIndex.access$collectAllModuleNodes((ExternalSystemModuleDataIndex)this.receiver, p0);
            }
        });
        return cache2.get(modulePath);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DataNode<? extends ModuleData>> collectAllModuleNodes(Project project) {
        void $this$associateByTo$iv$iv;
        ArrayList moduleNodes = new ArrayList();
        ExternalProjectsDataStorage projectDataStorage = ExternalProjectsDataStorage.getInstance(project);
        ExternalSystemManager.EP_NAME.forEachExtensionSafe(arg_0 -> ExternalSystemModuleDataIndex.collectAllModuleNodes$lambda$1(arg_0 -> ExternalSystemModuleDataIndex.collectAllModuleNodes$lambda$0(projectDataStorage, moduleNodes, arg_0), arg_0));
        Iterable $this$associateBy$iv = moduleNodes;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            DataNode dataNode = (DataNode)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = ((ModuleData)it.getData()).getLinkedExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLinkedExternalProjectPath(...)");
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @ApiStatus.Internal
    public final <H extends UserDataHolder, T> T getDataStorageCachedValue(@NotNull Project project, @NotNull H dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull Function1<? super H, ? extends T> createValue) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataHolder, (String)"dataHolder");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(createValue, (String)"createValue");
        return (T)CachedValuesManager.getManager((Project)project).getCachedValue(dataHolder, key, () -> ExternalSystemModuleDataIndex.getDataStorageCachedValue$lambda$0(createValue, dataHolder, project), false);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit collectAllModuleNodes$lambda$0(ExternalProjectsDataStorage $projectDataStorage, ArrayList $moduleNodes, ExternalSystemManager manager) {
        void $this$flatMapTo$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection<ExternalProjectInfo> collection = $projectDataStorage.list(manager.getSystemId());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"list(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DataNode it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ExternalProjectInfo it = (ExternalProjectInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getExternalProjectStructure() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        Collection destination$iv = $moduleNodes;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            DataNode it = (DataNode)element$iv;
            boolean bl = false;
            Collection collection2 = ExternalSystemApiUtil.getChildren((DataNode)it, (com.intellij.openapi.externalSystem.model.Key)ProjectKeys.MODULE);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getChildren(...)");
            Iterable list$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return Unit.INSTANCE;
    }

    private static final void collectAllModuleNodes$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getDataStorageCachedValue$lambda$0(Function1 $createValue, UserDataHolder $dataHolder, Project $project) {
        Object[] objectArray = new Object[]{ExternalProjectsDataStorage.getInstance($project)};
        return CachedValueProvider.Result.create((Object)$createValue.invoke((Object)$dataHolder), (Object[])objectArray);
    }

    public static final /* synthetic */ Map access$collectAllModuleNodes(ExternalSystemModuleDataIndex $this, Project project) {
        return $this.collectAllModuleNodes(project);
    }

    static {
        Key key = Key.create((String)"ExternalSystemModuleDataIndex");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        MODULE_NODE_KEY = key;
    }
}

