/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.autoimport.ProjectAware;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemActivityKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J:\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J:\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/autoimport/ExternalProjectsSettingsWatcher;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "<init>", "()V", "onProjectsLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "onProjectsLinked", "onProjectsUnlinked", "linkedProjectPaths", "", "", "intellij.platform.externalSystem.impl"})
public final class ExternalProjectsSettingsWatcher
implements ExternalSystemSettingsListenerEx {
    public void onProjectsLoaded(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        TrackingUtil.trackActivityBlocking((Project)project, (ActivityKey)((ActivityKey)ExternalSystemActivityKey.INSTANCE), () -> ExternalProjectsSettingsWatcher.onProjectsLoaded$lambda$0(project, manager, settings));
    }

    public void onProjectsLinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        Disposable disposable = ExtensionPointUtil.createExtensionDisposable(manager, (ExtensionPointName)ExternalSystemManager.EP_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"createExtensionDisposable(...)");
        Disposable extensionDisposable = disposable;
        Disposer.register((Disposable)((Disposable)project), (Disposable)extensionDisposable);
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
        ProjectSystemId projectSystemId = manager.getSystemId();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getSystemId(...)");
        ProjectSystemId systemId = projectSystemId;
        for (ExternalProjectSettings externalProjectSettings : settings) {
            String string = externalProjectSettings.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
            ExternalSystemProjectId id = new ExternalSystemProjectId(systemId, string);
            projectTracker.register((ExternalSystemProjectAware)new ProjectAware(project, id, (ExternalSystemAutoImportAware)manager), extensionDisposable);
        }
    }

    public void onProjectsUnlinked(@NotNull Project project, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Set<String> linkedProjectPaths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(linkedProjectPaths, (String)"linkedProjectPaths");
        if (!(manager instanceof ExternalSystemAutoImportAware)) {
            return;
        }
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
        ProjectSystemId projectSystemId = manager.getSystemId();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getSystemId(...)");
        ProjectSystemId systemId = projectSystemId;
        for (String linkedProjectPath : linkedProjectPaths) {
            projectTracker.remove(new ExternalSystemProjectId(systemId, linkedProjectPath));
        }
    }

    private static final Unit onProjectsLoaded$lambda$0(Project $project, ExternalSystemManager $manager, Collection $settings) {
        ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance($project);
        ProjectSystemId projectSystemId = $manager.getSystemId();
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"getSystemId(...)");
        ProjectSystemId systemId = projectSystemId;
        for (ExternalProjectSettings projectSettings : $settings) {
            String string = projectSettings.getExternalProjectPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
            projectTracker.activate(new ExternalSystemProjectId(systemId, string));
        }
        return Unit.INSTANCE;
    }
}

